/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Range;
import weka.core.SerializedObject;
import weka.core.Utils;
import weka.gui.Logger;

public class SubstringLabelerRules
implements EnvironmentHandler,
Serializable {
    public static final String MATCH_RULE_SEPARATOR = "@@match-rule@@";
    private static final long serialVersionUID = 1392983905562573599L;
    protected List<SubstringLabelerMatchRule> m_matchRules;
    protected boolean m_hasLabels;
    protected boolean m_consumeNonMatching;
    protected Instances m_inputStructure;
    protected Instances m_outputStructure;
    protected String m_attName = "newAtt";
    protected String m_statusMessagePrefix = "";
    protected boolean m_nominalBinary;
    protected transient Environment m_env = Environment.getSystemWide();

    public SubstringLabelerRules(String matchDetails, String newAttName, boolean consumeNonMatching, boolean nominalBinary, Instances inputStructure, String statusMessagePrefix, Logger log, Environment env) throws Exception {
        this.m_matchRules = SubstringLabelerRules.matchRulesFromInternal(matchDetails, inputStructure, statusMessagePrefix, log, env);
        this.m_inputStructure = new Instances(inputStructure, 0);
        this.m_attName = newAttName;
        this.m_statusMessagePrefix = statusMessagePrefix;
        this.m_consumeNonMatching = consumeNonMatching;
        this.m_nominalBinary = nominalBinary;
        this.m_env = env;
        this.makeOutputStructure();
    }

    public SubstringLabelerRules(String matchDetails, String newAttName, Instances inputStructure) throws Exception {
        this(matchDetails, newAttName, false, false, inputStructure, "", null, Environment.getSystemWide());
    }

    public void setConsumeNonMatching(boolean n) {
        this.m_consumeNonMatching = n;
    }

    public boolean getConsumeNonMatching() {
        return this.m_consumeNonMatching;
    }

    public void setNominalBinary(boolean n) {
        this.m_nominalBinary = n;
    }

    public boolean getNominalBinary() {
        return this.m_nominalBinary;
    }

    public Instances getOutputStructure() {
        return this.m_outputStructure;
    }

    public Instances getInputStructure() {
        return this.m_inputStructure;
    }

    public void setNewAttributeName(String newName) {
        this.m_attName = newName;
    }

    public String getNewAttributeName() {
        return this.m_attName;
    }

    @Override
    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    public static List<SubstringLabelerMatchRule> matchRulesFromInternal(String matchDetails, Instances inputStructure, String statusMessagePrefix, Logger log, Environment env) {
        String[] matchParts;
        ArrayList<SubstringLabelerMatchRule> matchRules = new ArrayList<SubstringLabelerMatchRule>();
        for (String p : matchParts = matchDetails.split(MATCH_RULE_SEPARATOR)) {
            SubstringLabelerMatchRule m = new SubstringLabelerMatchRule(p.trim());
            m.m_statusMessagePrefix = statusMessagePrefix == null ? "" : statusMessagePrefix;
            m.m_logger = log;
            m.init(env, inputStructure);
            matchRules.add(m);
        }
        return matchRules;
    }

    protected void makeOutputStructure() throws Exception {
        if (this.m_matchRules.size() > 0) {
            int labelCount = 0;
            HashSet<String> uniqueLabels = new HashSet<String>();
            Vector<String> labelVec = new Vector<String>();
            for (SubstringLabelerMatchRule m : this.m_matchRules) {
                if (m.getLabel() == null || m.getLabel().length() <= 0) continue;
                if (!uniqueLabels.contains(m.getLabel())) {
                    uniqueLabels.add(m.getLabel());
                    labelVec.addElement(m.getLabel());
                }
                ++labelCount;
            }
            if (labelCount > 0) {
                if (labelCount == this.m_matchRules.size()) {
                    this.m_hasLabels = true;
                } else {
                    throw new Exception("Can't have only some rules with a label!");
                }
            }
            this.m_outputStructure = (Instances)new SerializedObject(this.m_inputStructure).getObject();
            Attribute newAtt = null;
            if (this.m_hasLabels) {
                newAtt = new Attribute(this.m_attName, labelVec);
            } else if (this.m_nominalBinary) {
                labelVec.addElement("0");
                labelVec.addElement("1");
                newAtt = new Attribute(this.m_attName, labelVec);
            } else {
                newAtt = new Attribute(this.m_attName);
            }
            this.m_outputStructure.insertAttributeAt(newAtt, this.m_outputStructure.numAttributes());
            return;
        }
        this.m_outputStructure = new Instances(this.m_inputStructure);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Instance makeOutputInstance(Instance inputI, boolean batch) throws Exception {
        SubstringLabelerMatchRule m;
        if (this.m_outputStructure == null) {
            throw new Exception("OutputStructure has not been determined!");
        }
        int newAttIndex = this.m_outputStructure.numAttributes() - 1;
        Instance result = inputI;
        if (this.m_matchRules.size() <= 0) return result;
        String label = null;
        Iterator<SubstringLabelerMatchRule> iterator = this.m_matchRules.iterator();
        while (iterator.hasNext() && (label = (m = iterator.next()).apply(inputI)) == null) {
        }
        double[] vals = new double[this.m_outputStructure.numAttributes()];
        for (int i = 0; i < inputI.numAttributes(); ++i) {
            String v;
            if (!inputI.attribute(i).isString()) {
                vals[i] = inputI.value(i);
                continue;
            }
            if (!batch) {
                vals[i] = 0.0;
                v = inputI.stringValue(i);
                this.m_outputStructure.attribute(i).setStringValue(v);
                continue;
            }
            v = inputI.stringValue(i);
            vals[i] = this.m_outputStructure.attribute(i).addStringValue(v);
        }
        if (label != null) {
            vals[newAttIndex] = this.m_hasLabels ? (double)this.m_outputStructure.attribute(this.m_attName).indexOfValue(label) : 1.0;
        } else if (this.m_hasLabels) {
            if (this.getConsumeNonMatching()) return null;
            vals[newAttIndex] = Utils.missingValue();
        } else {
            vals[newAttIndex] = 0.0;
        }
        result = new DenseInstance(1.0, vals);
        result.setDataset(this.m_outputStructure);
        return result;
    }

    public static class SubstringLabelerMatchRule
    implements Serializable {
        public static final String MATCH_PART_SEPARATOR = "@@MR@@";
        private static final long serialVersionUID = 6518104085439241523L;
        protected String m_match = "";
        protected String m_label = "";
        protected boolean m_regex;
        protected boolean m_ignoreCase;
        protected Pattern m_regexPattern;
        protected String m_attsToApplyTo = "";
        protected String m_matchS;
        protected String m_labelS;
        protected int[] m_selectedAtts;
        protected String m_statusMessagePrefix;
        protected Logger m_logger;

        public SubstringLabelerMatchRule() {
        }

        public SubstringLabelerMatchRule(String setup) {
            this.parseFromInternal(setup);
        }

        public SubstringLabelerMatchRule(String match, boolean regex, boolean ignoreCase, String selectedAtts) {
            this.m_match = match;
            this.m_regex = regex;
            this.m_ignoreCase = ignoreCase;
            this.m_attsToApplyTo = selectedAtts;
        }

        protected void parseFromInternal(String setup) {
            String[] parts = setup.split(MATCH_PART_SEPARATOR);
            if (parts.length < 4 || parts.length > 5) {
                throw new IllegalArgumentException("Malformed match definition: " + setup);
            }
            this.m_attsToApplyTo = parts[0].trim();
            this.m_regex = parts[1].trim().toLowerCase().equals("t");
            this.m_ignoreCase = parts[2].trim().toLowerCase().equals("t");
            this.m_match = parts[3].trim();
            if (this.m_match == null || this.m_match.length() == 0) {
                throw new IllegalArgumentException("Must provide something to match!");
            }
            if (parts.length == 5) {
                this.m_label = parts[4].trim();
            }
        }

        public void setMatch(String match) {
            this.m_match = match;
        }

        public String getMatch() {
            return this.m_match;
        }

        public void setLabel(String label) {
            this.m_label = label;
        }

        public String getLabel() {
            return this.m_label;
        }

        public void setRegex(boolean regex) {
            this.m_regex = regex;
        }

        public boolean getRegex() {
            return this.m_regex;
        }

        public void setIgnoreCase(boolean ignore) {
            this.m_ignoreCase = ignore;
        }

        public boolean getIgnoreCase() {
            return this.m_ignoreCase;
        }

        public void setAttsToApplyTo(String a) {
            this.m_attsToApplyTo = a;
        }

        public String getAttsToApplyTo() {
            return this.m_attsToApplyTo;
        }

        public void init(Environment env, Instances structure) {
            HashSet<Integer> indexes;
            this.m_matchS = this.m_match;
            this.m_labelS = this.m_label;
            String attsToApplyToS = this.m_attsToApplyTo;
            try {
                this.m_matchS = env.substitute(this.m_matchS);
                this.m_labelS = env.substitute(this.m_labelS);
                attsToApplyToS = env.substitute(attsToApplyToS);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_regex) {
                String match = this.m_matchS;
                if (this.m_ignoreCase) {
                    match = match.toLowerCase();
                }
                this.m_regexPattern = Pattern.compile(match);
            }
            String tempRangeS = attsToApplyToS;
            tempRangeS = tempRangeS.replace("/first", "first").replace("/last", "last");
            Range tempR = new Range();
            tempR.setRanges(attsToApplyToS);
            try {
                tempR.setUpper(structure.numAttributes() - 1);
                this.m_selectedAtts = tempR.getSelection();
            }
            catch (IllegalArgumentException ex) {
                this.m_selectedAtts = null;
            }
            if (this.m_selectedAtts == null) {
                String[] stringArray;
                indexes = new HashSet<Integer>();
                for (String string : stringArray = this.m_attsToApplyTo.split(",")) {
                    String string2 = string.trim();
                    if (string2.toLowerCase().equals("/first")) {
                        indexes.add(0);
                        continue;
                    }
                    if (string2.toLowerCase().equals("/last")) {
                        indexes.add(structure.numAttributes() - 1);
                        continue;
                    }
                    if (structure.attribute(string2) != null) {
                        indexes.add(new Integer(structure.attribute(string2).index()));
                        continue;
                    }
                    if (this.m_logger == null) continue;
                    String msg = this.m_statusMessagePrefix + "Can't find attribute '" + string2 + "in the incoming instances - ignoring";
                    this.m_logger.logMessage(msg);
                }
                this.m_selectedAtts = new int[indexes.size()];
                boolean bl = false;
                for (Integer i : indexes) {
                    this.m_selectedAtts[++var8_15] = i;
                }
            }
            indexes = new HashSet();
            for (int m_selectedAtt : this.m_selectedAtts) {
                if (structure.attribute(m_selectedAtt).isString()) {
                    indexes.add(m_selectedAtt);
                    continue;
                }
                if (this.m_logger == null) continue;
                String string = this.m_statusMessagePrefix + "Attribute '" + structure.attribute(m_selectedAtt).name() + "is not a string attribute - " + "ignoring";
                this.m_logger.logMessage(string);
            }
            this.m_selectedAtts = new int[indexes.size()];
            boolean bl = false;
            for (Integer i : indexes) {
                this.m_selectedAtts[++var7_12] = i;
            }
        }

        public String apply(Instance inst) {
            for (int i = 0; i < this.m_selectedAtts.length; ++i) {
                String value;
                String result;
                if (inst.isMissing(this.m_selectedAtts[i]) || (result = this.apply(value = inst.stringValue(this.m_selectedAtts[i]))) == null) continue;
                return result;
            }
            return null;
        }

        protected String apply(String source) {
            String result = source;
            String match = this.m_matchS;
            boolean ruleMatches = false;
            if (this.m_ignoreCase) {
                result = result.toLowerCase();
                match = match.toLowerCase();
            }
            if (result != null && result.length() > 0) {
                if (this.m_regex) {
                    if (this.m_regexPattern.matcher(result).matches()) {
                        ruleMatches = true;
                    }
                } else {
                    ruleMatches = result.indexOf(match) >= 0;
                }
            }
            return ruleMatches ? this.m_label : null;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.m_regex ? "Regex: " : "Substring: ");
            buff.append(this.m_match).append("  ");
            buff.append(this.m_ignoreCase ? "[ignore case]" : "").append("  ");
            if (this.m_label != null && this.m_label.length() > 0) {
                buff.append("Label: ").append(this.m_label).append("  ");
            }
            buff.append("[Atts: " + this.m_attsToApplyTo + "]");
            return buff.toString();
        }

        public String toStringInternal() {
            StringBuffer buff = new StringBuffer();
            buff.append(this.m_attsToApplyTo).append(MATCH_PART_SEPARATOR);
            buff.append(this.m_regex ? "t" : "f").append(MATCH_PART_SEPARATOR);
            buff.append(this.m_ignoreCase ? "t" : "f").append(MATCH_PART_SEPARATOR);
            buff.append(this.m_match).append(MATCH_PART_SEPARATOR);
            buff.append(this.m_label);
            return buff.toString();
        }
    }
}

