/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.generators;

import java.util.Arrays;
import weka.classifiers.meta.generators.InstanceHandler;
import weka.classifiers.meta.generators.NumericAttributeGenerator;
import weka.classifiers.meta.generators.RandomizableGenerator;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;

public class DiscreteGenerator
extends RandomizableGenerator
implements InstanceHandler,
NumericAttributeGenerator {
    private static final long serialVersionUID = -2990312384506940726L;
    protected double[][] m_Probabilities;
    protected double m_Unseen = Double.MIN_VALUE;

    public String globalInfo() {
        return "An artificial data generator that uses discrete buckets for values.\n\nIn this discrete generator, values are ranked according to how often they appear.  This is not to be confused with the discrete uniform generator which gives every bucket the  same probability.";
    }

    public Capabilities getCapabilities() {
        Capabilities result = new Capabilities(this);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enableAllClasses();
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        result.enable(Capabilities.Capability.NO_CLASS);
        return result;
    }

    public void buildGenerator(Instances someinstances) throws Exception {
        int i;
        this.getCapabilities().testWithFail(someinstances);
        someinstances = new Instances(someinstances);
        someinstances.deleteWithMissing(0);
        double[] values = new double[someinstances.numInstances()];
        for (int i2 = 0; i2 < someinstances.numInstances(); ++i2) {
            Instance aninst = someinstances.instance(i2);
            values[i2] = aninst.value(0);
        }
        Arrays.sort(values);
        double count = 1.0;
        for (int i3 = 1; i3 < values.length; ++i3) {
            if (values[i3] == values[i3 - 1]) continue;
            count += 1.0;
        }
        double[][] allvals = new double[(int)count][2];
        int position = 0;
        allvals[0][0] = values[0];
        allvals[0][1] = 1.0;
        for (i = 1; i < values.length; ++i) {
            if (values[i] != values[i - 1]) {
                allvals[++position][0] = values[i];
                allvals[position][1] = 1.0;
                continue;
            }
            double[] dArray = allvals[position];
            dArray[1] = dArray[1] + 1.0;
        }
        i = 0;
        while ((double)i < count) {
            double[] dArray = allvals[i];
            dArray[1] = dArray[1] / ((double)values.length + 1.0);
            ++i;
        }
        this.m_Probabilities = allvals;
        this.m_Unseen = 1.0 / ((double)values.length + 1.0);
    }

    public double generate() {
        double aprob = this.m_Random.nextDouble();
        double currentprob = 0.0;
        for (int i = 0; i < this.m_Probabilities.length; ++i) {
            if (currentprob + this.m_Probabilities[i][1] >= aprob) {
                return this.m_Probabilities[i][0];
            }
            currentprob += this.m_Probabilities[i][1];
        }
        return 0.0;
    }

    public double getProbabilityOf(double valuex) {
        for (int i = 0; i < this.m_Probabilities.length; ++i) {
            if (valuex != this.m_Probabilities[i][0]) continue;
            return this.m_Probabilities[i][1];
        }
        return this.m_Unseen;
    }

    public double getLogProbabilityOf(double valuex) {
        return Math.log(this.getProbabilityOf(valuex));
    }
}

