/*
 * Decompiled with CFR 0.152.
 */
package weka.core.converters;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.SingleIndex;
import weka.core.Utils;
import weka.core.converters.AbstractFileSaver;
import weka.core.converters.BatchConverter;
import weka.core.converters.IncrementalConverter;
import weka.core.converters.LibSVMLoader;

public class LibSVMSaver
extends AbstractFileSaver
implements BatchConverter,
IncrementalConverter {
    private static final long serialVersionUID = 2792295817125694786L;
    public static String FILE_EXTENSION = LibSVMLoader.FILE_EXTENSION;
    protected SingleIndex m_ClassIndex = new SingleIndex("last");

    public LibSVMSaver() {
        this.resetOptions();
    }

    public String globalInfo() {
        return "Writes to a destination that is in libsvm format.\n\nFor more information about libsvm see:\n\nhttp://www.csie.ntu.edu.tw/~cjlin/libsvm/";
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tThe class index\n\t(default: last)", "c", 1, "-c <class index>"));
        return vector.elements();
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-c");
        vector.add(this.getClassIndex());
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('c', stringArray);
        if (string.length() != 0) {
            this.setClassIndex(string);
        } else {
            this.setClassIndex("last");
        }
    }

    public String getFileDescription() {
        return "libsvm data files";
    }

    public void resetOptions() {
        super.resetOptions();
        this.setFileExtension(LibSVMLoader.FILE_EXTENSION);
    }

    public String classIndexTipText() {
        return "Sets the class index (\"first\" and \"last\" are valid values)";
    }

    public String getClassIndex() {
        return this.m_ClassIndex.getSingleIndex();
    }

    public void setClassIndex(String string) {
        this.m_ClassIndex.setSingleIndex(string);
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NOMINAL_CLASS);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        return capabilities;
    }

    public void setInstances(Instances instances) {
        this.m_ClassIndex.setUpper(instances.numAttributes() - 1);
        instances.setClassIndex(this.m_ClassIndex.getIndex());
        super.setInstances(instances);
    }

    protected String instanceToLibsvm(Instance instance) {
        StringBuffer stringBuffer = new StringBuffer("" + instance.classValue());
        for (int i = 0; i < instance.numAttributes(); ++i) {
            if (i == instance.classIndex() || instance.value(i) == 0.0) continue;
            stringBuffer.append(" " + (i + 1) + ":" + instance.value(i));
        }
        return stringBuffer.toString();
    }

    public void writeIncremental(Instance instance) throws IOException {
        int n = this.getWriteMode();
        Instances instances = this.getInstances();
        PrintWriter printWriter = null;
        if (this.getRetrieval() == 1 || this.getRetrieval() == 0) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        if (this.getWriter() != null) {
            printWriter = new PrintWriter(this.getWriter());
        }
        if (n == 1) {
            if (instances == null) {
                this.setWriteMode(2);
                if (instance != null) {
                    System.err.println("Structure (Header Information) has to be set in advance");
                }
            } else {
                this.setWriteMode(3);
            }
            n = this.getWriteMode();
        }
        if (n == 2) {
            if (printWriter != null) {
                printWriter.close();
            }
            this.cancel();
        }
        if (n == 3) {
            this.setWriteMode(0);
            n = this.getWriteMode();
        }
        if (n == 0) {
            if (instances == null) {
                throw new IOException("No instances information available.");
            }
            if (instance != null) {
                if (this.retrieveFile() == null || printWriter == null) {
                    System.out.println(this.instanceToLibsvm(instance));
                } else {
                    printWriter.println(this.instanceToLibsvm(instance));
                    ++this.m_incrementalCounter;
                    if (this.m_incrementalCounter > 100) {
                        this.m_incrementalCounter = 0;
                        printWriter.flush();
                    }
                }
            } else {
                if (printWriter != null) {
                    printWriter.flush();
                    printWriter.close();
                }
                this.m_incrementalCounter = 0;
                this.resetStructure();
                printWriter = null;
                this.resetWriter();
            }
        }
    }

    public void writeBatch() throws IOException {
        if (this.getInstances() == null) {
            throw new IOException("No instances to save");
        }
        if (this.getRetrieval() == 2) {
            throw new IOException("Batch and incremental saving cannot be mixed.");
        }
        this.setRetrieval(1);
        this.setWriteMode(0);
        if (this.retrieveFile() == null && this.getWriter() == null) {
            for (int i = 0; i < this.getInstances().numInstances(); ++i) {
                System.out.println(this.instanceToLibsvm(this.getInstances().instance(i)));
            }
            this.setWriteMode(1);
        } else {
            PrintWriter printWriter = new PrintWriter(this.getWriter());
            for (int i = 0; i < this.getInstances().numInstances(); ++i) {
                printWriter.println(this.instanceToLibsvm(this.getInstances().instance(i)));
            }
            printWriter.flush();
            printWriter.close();
            this.setWriteMode(1);
            printWriter = null;
            this.resetWriter();
            this.setWriteMode(2);
        }
    }

    public static void main(String[] stringArray) {
        LibSVMSaver.runFileSaver(new LibSVMSaver(), stringArray);
    }
}

