/*
 * Decompiled with CFR 0.152.
 */
package weka.core.neighboursearch;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.AdditionalMeasureProducer;
import weka.core.DistanceFunction;
import weka.core.EuclideanDistance;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;
import weka.core.neighboursearch.PerformanceStats;

public abstract class NearestNeighbourSearch
implements Serializable,
OptionHandler,
AdditionalMeasureProducer {
    protected Instances m_Instances;
    protected int m_kNN;
    protected DistanceFunction m_DistanceFunction = new EuclideanDistance();
    protected PerformanceStats m_Stats = null;
    protected boolean m_MeasurePerformance = false;

    public NearestNeighbourSearch() {
        if (this.m_MeasurePerformance) {
            this.m_Stats = new PerformanceStats();
        }
    }

    public NearestNeighbourSearch(Instances instances) {
        this();
        this.m_Instances = instances;
    }

    public String globalInfo() {
        return "Abstract class for nearest neighbour search. All algorithms (classes) that do nearest neighbour search should extend this class.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.add(new Option("\tDistance function to use.\n\t(default: weka.core.EuclideanDistance)", "A", 1, "-A <classname and options>"));
        vector.add(new Option("\tCalculate performance statistics.", "P", 0, "-P"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('A', stringArray);
        if (string.length() != 0) {
            String[] stringArray2 = Utils.splitOptions(string);
            if (stringArray2.length == 0) {
                throw new Exception("Invalid DistanceFunction specification string.");
            }
            String string2 = stringArray2[0];
            stringArray2[0] = "";
            this.setDistanceFunction((DistanceFunction)Utils.forName(DistanceFunction.class, string2, stringArray2));
        } else {
            this.setDistanceFunction(new EuclideanDistance());
        }
        this.setMeasurePerformance(Utils.getFlag('P', stringArray));
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-A");
        vector.add((this.m_DistanceFunction.getClass().getName() + " " + Utils.joinOptions(this.m_DistanceFunction.getOptions())).trim());
        if (this.getMeasurePerformance()) {
            vector.add("-P");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String distanceFunctionTipText() {
        return "The distance function to use for finding neighbours (default: weka.core.EuclideanDistance). ";
    }

    public DistanceFunction getDistanceFunction() {
        return this.m_DistanceFunction;
    }

    public void setDistanceFunction(DistanceFunction distanceFunction) throws Exception {
        this.m_DistanceFunction = distanceFunction;
    }

    public String measurePerformanceTipText() {
        return "Whether to calculate performance statistics for the NN search or not";
    }

    public boolean getMeasurePerformance() {
        return this.m_MeasurePerformance;
    }

    public void setMeasurePerformance(boolean bl) {
        this.m_MeasurePerformance = bl;
        if (this.m_MeasurePerformance) {
            if (this.m_Stats == null) {
                this.m_Stats = new PerformanceStats();
            }
        } else {
            this.m_Stats = null;
        }
    }

    public abstract Instance nearestNeighbour(Instance var1) throws Exception;

    public abstract Instances kNearestNeighbours(Instance var1, int var2) throws Exception;

    public abstract double[] getDistances() throws Exception;

    public abstract void update(Instance var1) throws Exception;

    public void addInstanceInfo(Instance instance) {
    }

    public void setInstances(Instances instances) throws Exception {
        this.m_Instances = instances;
    }

    public Instances getInstances() {
        return this.m_Instances;
    }

    public PerformanceStats getPerformanceStats() {
        return this.m_Stats;
    }

    public Enumeration enumerateMeasures() {
        Vector vector;
        if (this.m_Stats == null) {
            vector = new Vector(0);
        } else {
            vector = new Vector();
            Enumeration enumeration = this.m_Stats.enumerateMeasures();
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (this.m_Stats == null) {
            throw new IllegalArgumentException(string + " not supported (NearestNeighbourSearch)");
        }
        return this.m_Stats.getMeasure(string);
    }

    public static void combSort11(double[] dArray, int[] nArray) {
        int n;
        int n2 = dArray.length;
        do {
            n2 = (int)((double)n2 / 1.3);
            switch (n2) {
                case 0: {
                    n2 = 1;
                    break;
                }
                case 9: 
                case 10: {
                    n2 = 11;
                    break;
                }
            }
            n = 0;
            int n3 = dArray.length - n2;
            for (int i = 0; i < n3; ++i) {
                int n4 = i + n2;
                if (!(dArray[i] > dArray[n4])) continue;
                double d = dArray[i];
                int n5 = nArray[i];
                dArray[i] = dArray[n4];
                nArray[i] = nArray[n4];
                dArray[n4] = d;
                nArray[n4] = n5;
                ++n;
            }
        } while (n > 0 || n2 > 1);
    }

    protected static int partition(double[] dArray, double[] dArray2, int n, int n2) {
        double d = dArray[(n + n2) / 2];
        while (n < n2) {
            while (dArray[n] < d && n < n2) {
                ++n;
            }
            while (dArray[n2] > d && n < n2) {
                --n2;
            }
            if (n >= n2) continue;
            double d2 = dArray[n];
            dArray[n] = dArray[n2];
            dArray[n2] = d2;
            d2 = dArray2[n];
            dArray2[n] = dArray2[n2];
            dArray2[n2] = d2;
            ++n;
            --n2;
        }
        if (n == n2 && dArray[n2] > d) {
            --n2;
        }
        return n2;
    }

    public static void quickSort(double[] dArray, double[] dArray2, int n, int n2) {
        if (n < n2) {
            int n3 = NearestNeighbourSearch.partition(dArray, dArray2, n, n2);
            NearestNeighbourSearch.quickSort(dArray, dArray2, n, n3);
            NearestNeighbourSearch.quickSort(dArray, dArray2, n3 + 1, n2);
        }
    }

    protected class NeighborList {
        protected NeighborNode m_First;
        protected NeighborNode m_Last;
        protected int m_Length = 1;

        public NeighborList(int n) {
            this.m_Length = n;
        }

        public boolean isEmpty() {
            return this.m_First == null;
        }

        public int currentLength() {
            int n = 0;
            NeighborNode neighborNode = this.m_First;
            while (neighborNode != null) {
                ++n;
                neighborNode = neighborNode.m_Next;
            }
            return n;
        }

        public void insertSorted(double d, Instance instance) {
            if (this.isEmpty()) {
                this.m_First = this.m_Last = new NeighborNode(d, instance);
            } else {
                NeighborNode neighborNode = this.m_First;
                if (d < this.m_First.m_Distance) {
                    this.m_First = new NeighborNode(d, instance, this.m_First);
                } else {
                    while (neighborNode.m_Next != null && neighborNode.m_Next.m_Distance < d) {
                        neighborNode = neighborNode.m_Next;
                    }
                    neighborNode.m_Next = new NeighborNode(d, instance, neighborNode.m_Next);
                    if (neighborNode.equals(this.m_Last)) {
                        this.m_Last = neighborNode.m_Next;
                    }
                }
                int n = 0;
                neighborNode = this.m_First;
                while (neighborNode.m_Next != null) {
                    if (++n >= this.m_Length && neighborNode.m_Distance != neighborNode.m_Next.m_Distance) {
                        this.m_Last = neighborNode;
                        neighborNode.m_Next = null;
                        break;
                    }
                    neighborNode = neighborNode.m_Next;
                }
            }
        }

        public void pruneToK(int n) {
            if (this.isEmpty()) {
                return;
            }
            if (n < 1) {
                n = 1;
            }
            int n2 = 0;
            double d = this.m_First.m_Distance;
            NeighborNode neighborNode = this.m_First;
            while (neighborNode.m_Next != null) {
                d = neighborNode.m_Distance;
                if (++n2 >= n && d != neighborNode.m_Next.m_Distance) {
                    this.m_Last = neighborNode;
                    neighborNode.m_Next = null;
                    break;
                }
                neighborNode = neighborNode.m_Next;
            }
        }

        public void printList() {
            if (this.isEmpty()) {
                System.out.println("Empty list");
            } else {
                NeighborNode neighborNode = this.m_First;
                while (neighborNode != null) {
                    System.out.println("Node: instance " + neighborNode.m_Instance + ", distance " + neighborNode.m_Distance);
                    neighborNode = neighborNode.m_Next;
                }
                System.out.println();
            }
        }

        public NeighborNode getFirst() {
            return this.m_First;
        }

        public NeighborNode getLast() {
            return this.m_Last;
        }
    }

    protected class NeighborNode {
        public Instance m_Instance;
        public double m_Distance;
        public NeighborNode m_Next;

        public NeighborNode(double d, Instance instance, NeighborNode neighborNode) {
            this.m_Distance = d;
            this.m_Instance = instance;
            this.m_Next = neighborNode;
        }

        public NeighborNode(double d, Instance instance) {
            this(d, instance, null);
        }
    }

    protected class MyHeapElement {
        public int index;
        public double distance;

        public MyHeapElement(int n, double d) {
            this.distance = d;
            this.index = n;
        }
    }

    protected class MyHeap {
        MyHeapElement[] m_heap = null;
        MyHeapElement[] m_KthNearest = null;
        int m_KthNearestSize = 0;
        int initSize = 10;

        public MyHeap(int n) {
            if (n % 2 == 0) {
                ++n;
            }
            this.m_heap = new MyHeapElement[n + 1];
            this.m_heap[0] = new MyHeapElement(0, 0.0);
        }

        public int size() {
            return this.m_heap[0].index;
        }

        public MyHeapElement peek() {
            return this.m_heap[1];
        }

        public MyHeapElement get() throws Exception {
            if (this.m_heap[0].index == 0) {
                throw new Exception("No elements present in the heap");
            }
            MyHeapElement myHeapElement = this.m_heap[1];
            this.m_heap[1] = this.m_heap[this.m_heap[0].index];
            --this.m_heap[0].index;
            this.downheap();
            return myHeapElement;
        }

        public void put(int n, double d) throws Exception {
            if (this.m_heap[0].index + 1 > this.m_heap.length - 1) {
                throw new Exception("the number of elements cannot exceed the initially set maximum limit");
            }
            ++this.m_heap[0].index;
            this.m_heap[this.m_heap[0].index] = new MyHeapElement(n, d);
            this.upheap();
        }

        public void putBySubstitute(int n, double d) throws Exception {
            MyHeapElement myHeapElement = this.get();
            this.put(n, d);
            if (myHeapElement.distance == this.m_heap[1].distance) {
                this.putKthNearest(myHeapElement.index, myHeapElement.distance);
            } else if (myHeapElement.distance > this.m_heap[1].distance) {
                this.m_KthNearest = null;
                this.m_KthNearestSize = 0;
                this.initSize = 10;
            } else if (myHeapElement.distance < this.m_heap[1].distance) {
                throw new Exception("The substituted element is smaller than the head element. put() should have been called in place of putBySubstitute()");
            }
        }

        public int noOfKthNearest() {
            return this.m_KthNearestSize;
        }

        public void putKthNearest(int n, double d) {
            if (this.m_KthNearest == null) {
                this.m_KthNearest = new MyHeapElement[this.initSize];
            }
            if (this.m_KthNearestSize >= this.m_KthNearest.length) {
                this.initSize += this.initSize;
                MyHeapElement[] myHeapElementArray = new MyHeapElement[this.initSize];
                System.arraycopy(this.m_KthNearest, 0, myHeapElementArray, 0, this.m_KthNearest.length);
                this.m_KthNearest = myHeapElementArray;
            }
            this.m_KthNearest[this.m_KthNearestSize++] = new MyHeapElement(n, d);
        }

        public MyHeapElement getKthNearest() {
            if (this.m_KthNearestSize == 0) {
                return null;
            }
            --this.m_KthNearestSize;
            return this.m_KthNearest[this.m_KthNearestSize];
        }

        protected void upheap() {
            int n = this.m_heap[0].index;
            while (n > 1 && this.m_heap[n].distance > this.m_heap[n / 2].distance) {
                MyHeapElement myHeapElement = this.m_heap[n];
                this.m_heap[n] = this.m_heap[n / 2];
                this.m_heap[n /= 2] = myHeapElement;
            }
        }

        protected void downheap() {
            int n = 1;
            while (2 * n <= this.m_heap[0].index && this.m_heap[n].distance < this.m_heap[2 * n].distance || 2 * n + 1 <= this.m_heap[0].index && this.m_heap[n].distance < this.m_heap[2 * n + 1].distance) {
                MyHeapElement myHeapElement;
                if (2 * n + 1 <= this.m_heap[0].index) {
                    if (this.m_heap[2 * n].distance > this.m_heap[2 * n + 1].distance) {
                        myHeapElement = this.m_heap[n];
                        this.m_heap[n] = this.m_heap[2 * n];
                        n = 2 * n;
                        this.m_heap[n] = myHeapElement;
                        continue;
                    }
                    myHeapElement = this.m_heap[n];
                    this.m_heap[n] = this.m_heap[2 * n + 1];
                    n = 2 * n + 1;
                    this.m_heap[n] = myHeapElement;
                    continue;
                }
                myHeapElement = this.m_heap[n];
                this.m_heap[n] = this.m_heap[2 * n];
                n = 2 * n;
                this.m_heap[n] = myHeapElement;
            }
        }

        public int totalSize() {
            return this.size() + this.noOfKthNearest();
        }
    }
}

