/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.part;

import weka.classifiers.rules.part.ClassifierDecList;
import weka.classifiers.trees.j48.Distribution;
import weka.classifiers.trees.j48.ModelSelection;
import weka.classifiers.trees.j48.NoSplit;
import weka.core.Instances;
import weka.core.Utils;

public class PruneableDecList
extends ClassifierDecList {
    private static final long serialVersionUID = -7228103346297172921L;

    public PruneableDecList(ModelSelection modelSelection, int n) {
        super(modelSelection, n);
    }

    public void buildRule(Instances instances, Instances instances2) throws Exception {
        this.buildDecList(instances, instances2, false);
        this.cleanup(new Instances(instances, 0));
    }

    public void buildDecList(Instances instances, Instances instances2, boolean bl) throws Exception {
        this.m_train = null;
        this.m_isLeaf = false;
        this.m_isEmpty = false;
        this.m_sons = null;
        this.indeX = 0;
        double d = instances.sumOfWeights();
        NoSplit noSplit = new NoSplit(new Distribution(instances));
        this.m_localModel = bl ? noSplit : this.m_toSelectModel.selectModel(instances, instances2);
        this.m_test = new Distribution(instances2, this.m_localModel);
        if (this.m_localModel.numSubsets() > 1) {
            int n;
            int n2;
            Instances[] instancesArray = this.m_localModel.split(instances);
            Instances[] instancesArray2 = this.m_localModel.split(instances2);
            instances = null;
            instances2 = null;
            this.m_sons = new ClassifierDecList[this.m_localModel.numSubsets()];
            int n3 = 0;
            do {
                ++n3;
                n2 = this.chooseIndex();
                if (n2 == -1) {
                    for (n = 0; n < this.m_sons.length; ++n) {
                        if (this.m_sons[n] != null) continue;
                        this.m_sons[n] = this.getNewDecList(instancesArray[n], instancesArray2[n], true);
                    }
                    if (n3 < 2) {
                        this.m_localModel = noSplit;
                        this.m_isLeaf = true;
                        this.m_sons = null;
                        if (Utils.eq(d, 0.0)) {
                            this.m_isEmpty = true;
                        }
                        return;
                    }
                    n2 = 0;
                    break;
                }
                this.m_sons[n2] = this.getNewDecList(instancesArray[n2], instancesArray2[n2], false);
            } while (n3 < this.m_sons.length && this.m_sons[n2].m_isLeaf);
            for (n = 0; n < this.m_sons.length && this.m_sons[n] != null && this.m_sons[n].m_isLeaf; ++n) {
            }
            if (n == this.m_sons.length) {
                this.pruneEnd();
                if (!this.m_isLeaf) {
                    this.indeX = this.chooseLastIndex();
                }
            } else {
                this.indeX = this.chooseLastIndex();
            }
        } else {
            this.m_isLeaf = true;
            if (Utils.eq(d, 0.0)) {
                this.m_isEmpty = true;
            }
        }
    }

    protected ClassifierDecList getNewDecList(Instances instances, Instances instances2, boolean bl) throws Exception {
        PruneableDecList pruneableDecList = new PruneableDecList(this.m_toSelectModel, this.m_minNumObj);
        pruneableDecList.buildDecList(instances, instances2, bl);
        return pruneableDecList;
    }

    protected void pruneEnd() throws Exception {
        double d = this.errorsForTree();
        double d2 = this.errorsForLeaf();
        if (Utils.smOrEq(d2, d)) {
            this.m_isLeaf = true;
            this.m_sons = null;
            this.m_localModel = new NoSplit(this.localModel().distribution());
        }
    }

    private double errorsForTree() throws Exception {
        if (this.m_isLeaf) {
            return this.errorsForLeaf();
        }
        double d = 0.0;
        for (int i = 0; i < this.m_sons.length; ++i) {
            if (Utils.eq(this.son(i).localModel().distribution().total(), 0.0)) {
                d += this.m_test.perBag(i) - this.m_test.perClassPerBag(i, this.localModel().distribution().maxClass());
                continue;
            }
            d += ((PruneableDecList)this.son(i)).errorsForTree();
        }
        return d;
    }

    private double errorsForLeaf() throws Exception {
        return this.m_test.total() - this.m_test.perClass(this.localModel().distribution().maxClass());
    }
}

