/*
 * Decompiled with CFR 0.152.
 */
package weka.associations;

import java.util.Enumeration;
import java.util.Vector;
import weka.associations.Apriori;
import weka.associations.Associator;
import weka.core.Capabilities;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Utils;

public abstract class SingleAssociatorEnhancer
extends Associator
implements OptionHandler {
    private static final long serialVersionUID = -3665885256363525164L;
    protected Associator m_Associator = new Apriori();

    protected String defaultAssociatorString() {
        return Apriori.class.getName();
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tFull name of base associator.\n\t(default: " + this.defaultAssociatorString() + ")", "W", 1, "-W"));
        if (this.m_Associator instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to associator " + this.m_Associator.getClass().getName() + ":"));
            Enumeration enumeration = ((OptionHandler)((Object)this.m_Associator)).listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('W', stringArray);
        if (string.length() > 0) {
            this.setAssociator(Associator.forName(string, null));
            this.setAssociator(Associator.forName(string, Utils.partitionOptions(stringArray)));
        } else {
            this.setAssociator(Associator.forName(this.defaultAssociatorString(), null));
            this.setAssociator(Associator.forName(this.defaultAssociatorString(), Utils.partitionOptions(stringArray)));
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-W");
        vector.add(this.getAssociator().getClass().getName());
        if (this.getAssociator() instanceof OptionHandler) {
            String[] stringArray = ((OptionHandler)((Object)this.getAssociator())).getOptions();
            vector.add("--");
            for (int i = 0; i < stringArray.length; ++i) {
                vector.add(stringArray[i]);
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String associatorTipText() {
        return "The base associator to be used.";
    }

    public void setAssociator(Associator associator) {
        this.m_Associator = associator;
    }

    public Associator getAssociator() {
        return this.m_Associator;
    }

    protected String getAssociatorSpec() {
        Associator associator = this.getAssociator();
        return associator.getClass().getName() + " " + Utils.joinOptions(((OptionHandler)((Object)associator)).getOptions());
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = this.getAssociator() != null ? this.getAssociator().getCapabilities() : new Capabilities(this);
        for (Capabilities.Capability capability : Capabilities.Capability.values()) {
            capabilities.enableDependency(capability);
        }
        capabilities.setOwner(this);
        return capabilities;
    }
}

