/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.io.File;
import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import weka.core.Environment;
import weka.core.EnvironmentHandler;
import weka.core.RevisionHandler;
import weka.core.logging.Logger;
import weka.gui.Logger;
import weka.gui.beans.BeanCommon;
import weka.gui.beans.BeanInstance;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.Startable;
import weka.gui.beans.xml.XMLBeans;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowRunner
implements RevisionHandler {
    protected Vector m_beans;
    protected int m_runningCount = 0;
    protected transient Logger m_log = null;
    protected transient Environment m_env;
    protected boolean m_startSequentially = false;

    public FlowRunner() {
        KnowledgeFlowApp.loadProperties();
    }

    public void setLog(Logger log) {
        this.m_log = log;
    }

    protected void runSequentially(TreeMap<Integer, Startable> startables) {
        Set<Integer> s = startables.keySet();
        for (Integer i : s) {
            try {
                Startable startPoint = startables.get(i);
                startPoint.start();
                Thread.sleep(200L);
                this.waitUntilFinished();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (this.m_log != null) {
                    this.m_log.logMessage(ex.getMessage());
                    this.m_log.logMessage("Aborting...");
                    break;
                }
                System.err.println(ex.getMessage());
                System.err.println("Aborting...");
                break;
            }
        }
    }

    protected synchronized void launchThread(final Startable s, final int flowNum) {
        Thread t = new Thread(){
            private int m_num;
            {
                this.m_num = flowNum;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    try {
                        s.start();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (FlowRunner.this.m_log != null) {
                            FlowRunner.this.m_log.logMessage(ex.getMessage());
                        } else {
                            System.err.println(ex.getMessage());
                        }
                        Object var3_2 = null;
                        FlowRunner.this.decreaseCount();
                    }
                    Object var3_1 = null;
                    FlowRunner.this.decreaseCount();
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    FlowRunner.this.decreaseCount();
                    throw throwable;
                }
            }
        };
        ++this.m_runningCount;
        t.setPriority(1);
        t.start();
    }

    protected synchronized void decreaseCount() {
        --this.m_runningCount;
    }

    public synchronized void stopAllFlows() {
        for (int i = 0; i < this.m_beans.size(); ++i) {
            BeanInstance temp = (BeanInstance)this.m_beans.elementAt(i);
            if (!(temp.getBean() instanceof BeanCommon)) continue;
            ((BeanCommon)temp.getBean()).stop();
        }
    }

    public void waitUntilFinished() {
        try {
            while (this.m_runningCount > 0) {
                Thread.sleep(200L);
            }
            while (true) {
                boolean busy = false;
                for (int i = 0; i < this.m_beans.size(); ++i) {
                    BeanInstance temp = (BeanInstance)this.m_beans.elementAt(i);
                    if (!(temp.getBean() instanceof BeanCommon) || !((BeanCommon)temp.getBean()).isBusy()) continue;
                    busy = true;
                    break;
                }
                if (busy) {
                    Thread.sleep(3000L);
                    continue;
                }
                break;
            }
        }
        catch (Exception ex) {
            if (this.m_log != null) {
                this.m_log.logMessage("[FlowRunner] Attempting to stop all flows...");
            } else {
                System.err.println("[FlowRunner] Attempting to stop all flows...");
            }
            this.stopAllFlows();
        }
    }

    public void load(String fileName) throws Exception {
        if (!fileName.endsWith(".kf") && !fileName.endsWith(".kfml")) {
            throw new Exception("Can only load and run binary or xml serialized KnowledgeFlows (*.kf | *.kfml)");
        }
        if (fileName.endsWith(".kf")) {
            this.loadBinary(fileName);
        } else if (fileName.endsWith(".kfml")) {
            this.loadXML(fileName);
        }
    }

    public void loadBinary(String fileName) throws Exception {
        if (!fileName.endsWith(".kf")) {
            throw new Exception("File must be a binary flow (*.kf)");
        }
        FileInputStream is = new FileInputStream(fileName);
        ObjectInputStream ois = new ObjectInputStream(is);
        this.m_beans = (Vector)ois.readObject();
        ois.close();
        if (this.m_env != null) {
            String parentDir = new File(fileName).getParent();
            if (parentDir == null) {
                parentDir = "./";
            }
            this.m_env.addVariable("Internal.knowledgeflow.directory", parentDir);
        }
    }

    public void loadXML(String fileName) throws Exception {
        if (!fileName.endsWith(".kfml")) {
            throw new Exception("File must be an XML flow (*.kfml)");
        }
        XMLBeans xml = new XMLBeans(null, null);
        Vector v = (Vector)xml.read(new File(fileName));
        this.m_beans = (Vector)v.get(0);
        if (this.m_env != null) {
            String parentDir = new File(fileName).getParent();
            if (parentDir == null) {
                parentDir = "./";
            }
            this.m_env.addVariable("Internal.knowledgeflow.directory", parentDir);
        } else {
            System.err.println("++++++++++++ Environment variables null!!...");
        }
    }

    public Vector getFlows() {
        return this.m_beans;
    }

    public void setFlows(Vector beans) {
        this.m_beans = beans;
    }

    public void setEnvironment(Environment env) {
        this.m_env = env;
    }

    public Environment getEnvironment() {
        return this.m_env;
    }

    public void setStartSequentially(boolean s) {
        this.m_startSequentially = s;
    }

    public boolean getStartSequentially() {
        return this.m_startSequentially;
    }

    public void run() throws Exception {
        if (this.m_beans == null) {
            throw new Exception("Don't seem to have any beans I can execute.");
        }
        for (int i = 0; i < this.m_beans.size(); ++i) {
            BeanInstance tempB = (BeanInstance)this.m_beans.elementAt(i);
            if (this.m_log != null && tempB.getBean() instanceof BeanCommon) {
                ((BeanCommon)tempB.getBean()).setLog(this.m_log);
            }
            if (!(tempB.getBean() instanceof EnvironmentHandler)) continue;
            ((EnvironmentHandler)tempB.getBean()).setEnvironment(this.m_env);
        }
        int numFlows = 1;
        if (this.m_log != null) {
            if (this.m_startSequentially) {
                this.m_log.logMessage("[FlowRunner] launching flow start points sequentially...");
            } else {
                this.m_log.logMessage("[FlowRunner] launching flow start points in parallel...");
            }
        }
        TreeMap<Integer, Startable> startables = new TreeMap<Integer, Startable>();
        for (int i = 0; i < this.m_beans.size(); ++i) {
            BeanInstance tempB = (BeanInstance)this.m_beans.elementAt(i);
            if (!(tempB.getBean() instanceof Startable)) continue;
            Startable s = (Startable)tempB.getBean();
            if (!this.m_startSequentially) {
                if (s.getStartMessage().charAt(0) != '$') {
                    if (this.m_log != null) {
                        this.m_log.logMessage("[FlowRunner] Launching flow " + numFlows + "...");
                    } else {
                        System.out.println("[FlowRunner] Launching flow " + numFlows + "...");
                    }
                    this.launchThread(s, numFlows);
                    ++numFlows;
                    continue;
                }
                String beanName = s.getClass().getName();
                if (s instanceof BeanCommon) {
                    String customName;
                    beanName = customName = ((BeanCommon)((Object)s)).getCustomName();
                }
                if (this.m_log != null) {
                    this.m_log.logMessage("[FlowRunner] WARNING: Can't start " + beanName + " at this time.");
                    continue;
                }
                System.out.println("[FlowRunner] WARNING: Can't start " + beanName + " at this time.");
                continue;
            }
            boolean ok = false;
            Integer position = null;
            String beanName = s.getClass().getName();
            if (s instanceof BeanCommon) {
                String customName;
                beanName = customName = ((BeanCommon)((Object)s)).getCustomName();
                if (customName.indexOf(58) > 0) {
                    String startPos = customName.substring(0, customName.indexOf(58));
                    try {
                        position = new Integer(startPos);
                        ok = true;
                    }
                    catch (NumberFormatException n) {
                        // empty catch block
                    }
                }
            }
            if (!ok) {
                if (startables.size() == 0) {
                    position = new Integer(0);
                } else {
                    int newPos = startables.lastKey();
                    position = new Integer(++newPos);
                }
            }
            if (s.getStartMessage().charAt(0) != '$') {
                if (this.m_log != null) {
                    this.m_log.logMessage("[FlowRunner] adding start point " + beanName + " to the execution list (position " + position + ")");
                } else {
                    System.out.println("[FlowRunner] adding start point " + beanName + " to the execution list (position " + position + ")");
                }
                startables.put(position, s);
                continue;
            }
            if (this.m_log != null) {
                this.m_log.logMessage("[FlowRunner] WARNING: Can't start " + beanName + " at this time.");
                continue;
            }
            System.out.println("[FlowRunner] WARNING: Can't start " + beanName + " at this time.");
        }
        if (this.m_startSequentially) {
            this.runSequentially(startables);
        }
    }

    public static void main(String[] args) {
        weka.core.logging.Logger.log(Logger.Level.INFO, "Logging started");
        if (args.length < 1) {
            System.err.println("Usage:\n\nFlowRunner <serialized kf file> [-s]\n\n\tUse -s to launch start points sequentially (default launches in parallel).");
        } else {
            try {
                FlowRunner fr = new FlowRunner();
                SimpleLogger sl = new SimpleLogger();
                String fileName = args[0];
                if (args.length == 2 && args[1].equals("-s")) {
                    fr.setStartSequentially(true);
                }
                Environment env = Environment.getSystemWide();
                fr.setLog(sl);
                fr.setEnvironment(env);
                fr.load(fileName);
                fr.run();
                fr.waitUntilFinished();
                System.out.println("Finished all flows.");
                System.exit(1);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println(ex.getMessage());
            }
        }
    }

    @Override
    public String getRevision() {
        return "$Revision: 6017 $";
    }

    public static class SimpleLogger
    implements Logger {
        SimpleDateFormat m_DateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

        public void logMessage(String lm) {
            System.out.println(this.m_DateFormat.format(new Date()) + ": " + lm);
        }

        public void statusMessage(String lm) {
            System.out.println(this.m_DateFormat.format(new Date()) + ": " + lm);
        }
    }
}

