/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.core.Capabilities;
import weka.core.CapabilitiesHandler;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.SerializedObject;
import weka.core.Utils;

public abstract class Kernel
implements Serializable,
OptionHandler,
CapabilitiesHandler,
RevisionHandler {
    private static final long serialVersionUID = -6102771099905817064L;
    protected Instances m_data;
    protected boolean m_Debug = false;
    protected boolean m_ChecksTurnedOff = false;

    public abstract String globalInfo();

    public abstract double eval(int var1, int var2, Instance var3) throws Exception;

    public abstract void clean();

    public abstract int numEvals();

    public abstract int numCacheHits();

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tEnables debugging output (if available) to be printed.\n\t(default: off)", "D", 0, "-D"));
        vector.addElement(new Option("\tTurns off all checks - use with caution!\n\t(default: checks on)", "no-checks", 0, "-no-checks"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.setDebug(Utils.getFlag('D', stringArray));
        this.setChecksTurnedOff(Utils.getFlag("no-checks", stringArray));
        Utils.checkForRemainingOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.getDebug()) {
            vector.add("-D");
        }
        if (this.getChecksTurnedOff()) {
            vector.add("-no-checks");
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "Turns on the output of debugging information.";
    }

    public void setChecksTurnedOff(boolean bl) {
        this.m_ChecksTurnedOff = bl;
    }

    public boolean getChecksTurnedOff() {
        return this.m_ChecksTurnedOff;
    }

    public String checksTurnedOffTipText() {
        return "Turns time-consuming checks off - use with caution.";
    }

    protected void initVars(Instances instances) {
        this.m_data = instances;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = new Capabilities(this);
        capabilities.enableAll();
        return capabilities;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5517 $");
    }

    public void buildKernel(Instances instances) throws Exception {
        if (!this.getChecksTurnedOff()) {
            this.getCapabilities().testWithFail(instances);
        }
        this.initVars(instances);
    }

    public static Kernel makeCopy(Kernel kernel) throws Exception {
        return (Kernel)new SerializedObject(kernel).getObject();
    }

    public static Kernel[] makeCopies(Kernel kernel, int n) throws Exception {
        if (kernel == null) {
            throw new Exception("No model kernel set");
        }
        Kernel[] kernelArray = new Kernel[n];
        SerializedObject serializedObject = new SerializedObject(kernel);
        for (int i = 0; i < kernelArray.length; ++i) {
            kernelArray[i] = (Kernel)serializedObject.getObject();
        }
        return kernelArray;
    }

    public static Kernel forName(String string, String[] stringArray) throws Exception {
        return (Kernel)Utils.forName(Kernel.class, string, stringArray);
    }
}

