/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.ensembleSelection;

import java.util.Random;
import weka.classifiers.Evaluation;
import weka.classifiers.meta.ensembleSelection.EnsembleMetricHelper;
import weka.core.Instances;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class ModelBag
implements RevisionHandler {
    private double[][][] m_models;
    private int[] m_modelIndex;
    private int m_bagSize;
    private int m_numChosen;
    private int[] m_timesChosen;
    private boolean m_debug;
    private double m_bestPerformance;
    private int[] m_bestTimesChosen;

    public ModelBag(double[][][] dArray, double d, boolean bl) {
        this.m_debug = bl;
        if (dArray.length == 0) {
            throw new IllegalArgumentException("ModelBag needs at least 1 model.");
        }
        this.m_bagSize = (int)((double)dArray.length * d);
        this.m_models = dArray;
        this.m_modelIndex = new int[this.m_models.length];
        this.m_timesChosen = new int[this.m_models.length];
        this.m_bestTimesChosen = this.m_timesChosen;
        this.m_bestPerformance = 0.0;
        this.m_numChosen = 0;
        for (int i = 0; i < this.m_models.length; ++i) {
            this.m_modelIndex[i] = i;
            this.m_timesChosen[i] = 0;
        }
    }

    private void swap(int n, int n2) {
        if (n != n2) {
            int n3 = this.m_modelIndex[n];
            this.m_modelIndex[n] = this.m_modelIndex[n2];
            this.m_modelIndex[n2] = n3;
            int n4 = this.m_timesChosen[n];
            this.m_timesChosen[n] = this.m_timesChosen[n2];
            this.m_timesChosen[n2] = n4;
        }
    }

    public void shuffle(Random random) {
        if (this.m_models.length < 2) {
            return;
        }
        for (int i = 0; i < this.m_models.length; ++i) {
            int n = random.nextInt(this.m_models.length - 1);
            if (n >= i) {
                ++n;
            }
            this.swap(i, n);
        }
    }

    private int[] virtualToRealWeights(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray2.length; ++i) {
            nArray2[this.m_modelIndex[i]] = nArray[i];
        }
        return nArray2;
    }

    private void updateBestTimesChosen() {
        this.m_bestTimesChosen = this.virtualToRealWeights(this.m_timesChosen);
    }

    public int[] sortInitialize(int n, boolean bl, Instances instances, int n2) throws Exception {
        double d;
        double[] dArray = new double[this.m_bagSize];
        for (int i = 0; i < this.m_bagSize; ++i) {
            dArray[i] = this.evaluatePredictions(instances, this.model(i), n2);
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            int n3 = i;
            double d2 = dArray[i];
            for (int j = i + 1; j < this.m_bagSize; ++j) {
                if (!(dArray[j] > d2)) continue;
                d2 = dArray[j];
                n3 = j;
            }
            this.swap(i, n3);
            d = dArray[i];
            dArray[i] = dArray[n3];
            dArray[n3] = d;
            nArray[i] = this.m_modelIndex[i];
            if (bl) continue;
            int n4 = i;
            this.m_timesChosen[n4] = this.m_timesChosen[n4] + 1;
            ++this.m_numChosen;
        }
        if (bl) {
            double[][] dArray2 = null;
            double d3 = 0.0;
            if (n > 0) {
                this.m_timesChosen[0] = this.m_timesChosen[0] + 1;
                ++this.m_numChosen;
                this.updateBestTimesChosen();
            }
            int n5 = 1;
            while (n5 < n && (d = this.evaluatePredictions(instances, dArray2 = this.computePredictions(n5, true), n2)) > d3) {
                d3 = d;
                int n6 = n5++;
                this.m_timesChosen[n6] = this.m_timesChosen[n6] + 1;
                ++this.m_numChosen;
                this.updateBestTimesChosen();
            }
        }
        this.updateBestTimesChosen();
        if (this.m_debug) {
            System.out.println("Sort Initialization added best " + this.m_numChosen + " models to the bag.");
        }
        return nArray;
    }

    public void weightAll(int n) {
        int n2 = 0;
        while (n2 < this.m_bagSize) {
            int n3 = n2++;
            this.m_timesChosen[n3] = this.m_timesChosen[n3] + n;
            this.m_numChosen += n;
        }
        this.updateBestTimesChosen();
    }

    public void forwardSelect(boolean bl, Instances instances, int n) throws Exception {
        double d = -1.0;
        int n2 = -1;
        for (int i = 0; i < this.m_bagSize; ++i) {
            double[][] dArray;
            double d2;
            if (this.m_timesChosen[i] != 0 && !bl || !((d2 = this.evaluatePredictions(instances, dArray = this.computePredictions(i, true), n)) > d)) continue;
            n2 = i;
            d = d2;
        }
        if (n2 == -1) {
            if (this.m_debug) {
                System.out.println("Couldn't add model.  No action performed.");
            }
            return;
        }
        int n3 = n2;
        this.m_timesChosen[n3] = this.m_timesChosen[n3] + 1;
        ++this.m_numChosen;
        if (d > this.m_bestPerformance) {
            this.updateBestTimesChosen();
            this.m_bestPerformance = d;
        }
    }

    public void backwardEliminate(Instances instances, int n) throws Exception {
        if (this.m_numChosen <= 1) {
            return;
        }
        double d = -1.0;
        int n2 = -1;
        for (int i = 0; i < this.m_bagSize; ++i) {
            double[][] dArray;
            double d2;
            if (this.m_timesChosen[i] <= 0 || !((d2 = this.evaluatePredictions(instances, dArray = this.computePredictions(i, false), n)) > d)) continue;
            n2 = i;
            d = d2;
        }
        if (n2 == -1) {
            if (this.m_debug) {
                System.out.println("Couldn't remove model.  No action performed.");
            }
            return;
        }
        int n3 = n2;
        this.m_timesChosen[n3] = this.m_timesChosen[n3] - 1;
        --this.m_numChosen;
        if (this.m_debug) {
            System.out.println("Removing model " + this.m_modelIndex[n2] + " (" + n2 + ") " + d);
        }
        if (d > this.m_bestPerformance) {
            this.updateBestTimesChosen();
            this.m_bestPerformance = d;
        }
    }

    public void forwardSelectOrBackwardEliminate(boolean bl, Instances instances, int n) throws Exception {
        int n2;
        double d = -1.0;
        int n3 = -1;
        boolean bl2 = true;
        for (n2 = 0; n2 < this.m_bagSize; ++n2) {
            double[][] dArray;
            double d2;
            if (this.m_timesChosen[n2] > 0 && (d2 = this.evaluatePredictions(instances, dArray = this.computePredictions(n2, false), n)) > d) {
                n3 = n2;
                d = d2;
                bl2 = false;
            }
            if (this.m_timesChosen[n2] != 0 && !bl || !((d2 = this.evaluatePredictions(instances, dArray = this.computePredictions(n2, true), n)) > d)) continue;
            n3 = n2;
            d = d2;
            bl2 = true;
        }
        if (n3 == -1) {
            if (this.m_debug) {
                System.out.println("Couldn't add or remove model.  No action performed.");
            }
            return;
        }
        n2 = bl2 ? 1 : -1;
        int n4 = n3;
        this.m_timesChosen[n4] = this.m_timesChosen[n4] + n2;
        this.m_numChosen += n2;
        if (d > this.m_bestPerformance) {
            this.updateBestTimesChosen();
            this.m_bestPerformance = d;
        }
    }

    public int[] getModelWeights() {
        return this.m_bestTimesChosen;
    }

    private double[][] model(int n) {
        return this.m_models[this.m_modelIndex[n]];
    }

    private double[][] computePredictions(int n, boolean bl) {
        int n2;
        int n3;
        int n4;
        double[][] dArray = new double[this.m_models[0].length][this.m_models[0][0].length];
        for (n4 = 0; n4 < this.m_bagSize; ++n4) {
            if (this.m_timesChosen[n4] <= 0) continue;
            for (n3 = 0; n3 < this.m_models[0].length; ++n3) {
                for (n2 = 0; n2 < this.m_models[0][n3].length; ++n2) {
                    double[] dArray2 = dArray[n3];
                    int n5 = n2;
                    dArray2[n5] = dArray2[n5] + this.model(n4)[n3][n2] * (double)this.m_timesChosen[n4];
                }
            }
        }
        for (n4 = 0; n4 < this.m_models[0].length; ++n4) {
            n3 = bl ? 1 : -1;
            n2 = 0;
            while (n2 < this.m_models[0][n4].length) {
                double[] dArray3 = dArray[n4];
                int n6 = n2;
                dArray3[n6] = dArray3[n6] + (double)n3 * this.model(n)[n4][n2];
                double[] dArray4 = dArray[n4];
                int n7 = n2++;
                dArray4[n7] = dArray4[n7] / (double)(this.m_numChosen + n3);
            }
        }
        return dArray;
    }

    private double evaluatePredictions(Instances instances, double[][] dArray, int n) throws Exception {
        Evaluation evaluation = new Evaluation(instances);
        for (int i = 0; i < instances.numInstances(); ++i) {
            evaluation.evaluateModelOnceAndRecordPrediction(dArray[i], instances.instance(i));
        }
        return EnsembleMetricHelper.getMetric(evaluation, n);
    }

    public double[] getIndividualPerformance(Instances instances, int n) throws Exception {
        double[] dArray = new double[this.m_bagSize];
        for (int i = 0; i < this.m_bagSize; ++i) {
            dArray[i] = this.evaluatePredictions(instances, this.model(i), n);
        }
        return dArray;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

