/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import weka.classifiers.bayes.net.GUI;
import weka.classifiers.evaluation.ThresholdCurve;
import weka.core.Copyright;
import weka.core.Instances;
import weka.core.Memory;
import weka.core.SystemInfo;
import weka.core.Utils;
import weka.core.Version;
import weka.core.logging.Logger;
import weka.gui.BrowserHelper;
import weka.gui.ExtensionFileFilter;
import weka.gui.GenericObjectEditor;
import weka.gui.LogWindow;
import weka.gui.LookAndFeel;
import weka.gui.MainMenuExtension;
import weka.gui.MemoryUsagePanel;
import weka.gui.SimpleCLI;
import weka.gui.arffviewer.ArffViewer;
import weka.gui.beans.KnowledgeFlow;
import weka.gui.beans.KnowledgeFlowApp;
import weka.gui.beans.StartUpListener;
import weka.gui.boundaryvisualizer.BoundaryVisualizer;
import weka.gui.experiment.Experimenter;
import weka.gui.explorer.Explorer;
import weka.gui.graphvisualizer.GraphVisualizer;
import weka.gui.sql.SqlViewer;
import weka.gui.treevisualizer.Node;
import weka.gui.treevisualizer.NodePlace;
import weka.gui.treevisualizer.PlaceNode2;
import weka.gui.treevisualizer.TreeBuild;
import weka.gui.treevisualizer.TreeVisualizer;
import weka.gui.visualize.PlotData2D;
import weka.gui.visualize.ThresholdVisualizePanel;
import weka.gui.visualize.VisualizePanel;

public class GUIChooser
extends JFrame {
    private static final long serialVersionUID = 9001529425230247914L;
    protected GUIChooser m_Self;
    private JMenuBar m_jMenuBar;
    private JMenu m_jMenuProgram;
    private JMenu m_jMenuVisualization;
    private JMenu m_jMenuTools;
    private JMenu m_jMenuHelp;
    protected JPanel m_PanelApplications = new JPanel();
    protected JButton m_ExplorerBut = new JButton("Explorer");
    protected JFrame m_ExplorerFrame;
    protected JButton m_ExperimenterBut = new JButton("Experimenter");
    protected JFrame m_ExperimenterFrame;
    protected JButton m_KnowledgeFlowBut = new JButton("KnowledgeFlow");
    protected JFrame m_KnowledgeFlowFrame;
    protected JButton m_SimpleBut = new JButton("Simple CLI");
    protected SimpleCLI m_SimpleCLI;
    protected Vector m_ArffViewers = new Vector();
    protected JFrame m_SqlViewerFrame;
    protected JFrame m_BayesNetGUIFrame;
    protected JFrame m_EnsembleLibraryFrame;
    protected Vector m_Plots = new Vector();
    protected Vector m_ROCs = new Vector();
    protected Vector m_TreeVisualizers = new Vector();
    protected Vector m_GraphVisualizers = new Vector();
    protected JFrame m_BoundaryVisualizerFrame;
    protected JFrame m_SystemInfoFrame;
    protected JFrame m_MemoryUsageFrame;
    protected static LogWindow m_LogWindow = new LogWindow();
    Image m_weka = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/gui/images/weka_background.gif"));
    protected JFileChooser m_FileChooserTreeVisualizer = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserGraphVisualizer = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserPlot = new JFileChooser(new File(System.getProperty("user.dir")));
    protected JFileChooser m_FileChooserROC = new JFileChooser(new File(System.getProperty("user.dir")));
    protected Image m_Icon;
    protected HashSet<Container> m_ChildFrames = new HashSet();
    private static GUIChooser m_chooser;
    private static Memory m_Memory;

    public GUIChooser() {
        super("Weka GUI Chooser");
        JMenuItem jMenuItem;
        JMenuItem jMenuItem2;
        Object object;
        Object object2;
        Serializable serializable;
        Object object3;
        this.m_Self = this;
        this.m_FileChooserGraphVisualizer.addChoosableFileFilter(new ExtensionFileFilter(".bif", "BIF Files (*.bif)"));
        this.m_FileChooserGraphVisualizer.addChoosableFileFilter(new ExtensionFileFilter(".xml", "XML Files (*.xml)"));
        this.m_FileChooserPlot.addChoosableFileFilter(new ExtensionFileFilter(".arff", "ARFF Files (*.arff)"));
        this.m_FileChooserPlot.setMultiSelectionEnabled(true);
        this.m_FileChooserROC.addChoosableFileFilter(new ExtensionFileFilter(".arff", "ARFF Files (*.arff)"));
        this.m_Icon = Toolkit.getDefaultToolkit().getImage(ClassLoader.getSystemResource("weka/gui/weka_icon.gif"));
        this.setIconImage(this.m_Icon);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.m_PanelApplications, "East");
        this.m_PanelApplications.setBorder(BorderFactory.createTitledBorder("Applications"));
        this.m_PanelApplications.setLayout(new GridLayout(4, 1));
        this.m_PanelApplications.add(this.m_ExplorerBut);
        this.m_PanelApplications.add(this.m_ExperimenterBut);
        this.m_PanelApplications.add(this.m_KnowledgeFlowBut);
        this.m_PanelApplications.add(this.m_SimpleBut);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.setLayout(new BorderLayout());
        jPanel.setToolTipText("Weka, a native bird of New Zealand");
        ImageIcon imageIcon = new ImageIcon(this.m_weka);
        JLabel jLabel = new JLabel(imageIcon);
        jPanel.add((Component)jLabel, "Center");
        String string = "<html><font size=-2>Waikato Environment for Knowledge Analysis<br>Version " + Version.VERSION + "<br>" + "(c) " + Copyright.getFromYear() + " - " + Copyright.getToYear() + "<br>" + Copyright.getOwner() + "<br>" + Copyright.getAddress() + "</font>" + "</html>";
        JLabel jLabel2 = new JLabel(string);
        jLabel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jLabel2, "South");
        this.getContentPane().add((Component)jPanel, "Center");
        this.m_jMenuBar = new JMenuBar();
        this.m_jMenuProgram = new JMenu();
        this.m_jMenuBar.add(this.m_jMenuProgram);
        this.m_jMenuProgram.setText("Program");
        this.m_jMenuProgram.setMnemonic('P');
        JMenuItem jMenuItem3 = new JMenuItem();
        this.m_jMenuProgram.add(jMenuItem3);
        jMenuItem3.setText("LogWindow");
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        m_LogWindow.setIconImage(this.m_Icon);
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                m_LogWindow.setVisible(true);
            }
        });
        final JMenuItem jMenuItem4 = new JMenuItem();
        this.m_jMenuProgram.add(jMenuItem4);
        jMenuItem4.setText("Memory usage");
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(77, 2));
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIChooser.this.m_MemoryUsageFrame == null) {
                    final MemoryUsagePanel memoryUsagePanel = new MemoryUsagePanel();
                    jMenuItem4.setEnabled(false);
                    GUIChooser.this.m_MemoryUsageFrame = new JFrame("Memory usage");
                    GUIChooser.this.m_MemoryUsageFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_MemoryUsageFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_MemoryUsageFrame.getContentPane().add((Component)memoryUsagePanel, "Center");
                    GUIChooser.this.m_MemoryUsageFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            memoryUsagePanel.stopMonitoring();
                            GUIChooser.this.m_MemoryUsageFrame.dispose();
                            GUIChooser.this.m_MemoryUsageFrame = null;
                            jMenuItem4.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_MemoryUsageFrame.pack();
                    GUIChooser.this.m_MemoryUsageFrame.setSize(400, 50);
                    Point point = memoryUsagePanel.getFrameLocation();
                    if (point.x != -1 && point.y != -1) {
                        GUIChooser.this.m_MemoryUsageFrame.setLocation(point);
                    }
                    GUIChooser.this.m_MemoryUsageFrame.setVisible(true);
                    Dimension dimension = GUIChooser.this.m_MemoryUsageFrame.getPreferredSize();
                    GUIChooser.this.m_MemoryUsageFrame.setSize(new Dimension((int)dimension.getWidth(), (int)dimension.getHeight()));
                }
            }
        });
        this.m_jMenuProgram.add(new JSeparator());
        JMenuItem jMenuItem5 = new JMenuItem();
        this.m_jMenuProgram.add(jMenuItem5);
        jMenuItem5.setText("Exit");
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GUIChooser.this.dispose();
                GUIChooser.this.checkExit();
            }
        });
        this.m_jMenuVisualization = new JMenu();
        this.m_jMenuBar.add(this.m_jMenuVisualization);
        this.m_jMenuVisualization.setText("Visualization");
        this.m_jMenuVisualization.setMnemonic('V');
        JMenuItem jMenuItem6 = new JMenuItem();
        this.m_jMenuVisualization.add(jMenuItem6);
        jMenuItem6.setText("Plot");
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = GUIChooser.this.m_FileChooserPlot.showOpenDialog(GUIChooser.this.m_Self);
                if (n != 0) {
                    return;
                }
                VisualizePanel visualizePanel = new VisualizePanel();
                String string = "";
                File[] fileArray = GUIChooser.this.m_FileChooserPlot.getSelectedFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    String string2 = fileArray[i].getAbsolutePath();
                    if (i > 0) {
                        string = string + ", ";
                    }
                    string = string + string2;
                    System.err.println("Loading instances from " + string2);
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(string2));
                        Instances instances = new Instances(bufferedReader);
                        instances.setClassIndex(instances.numAttributes() - 1);
                        PlotData2D plotData2D = new PlotData2D(instances);
                        if (i == 0) {
                            plotData2D.setPlotName("Master plot");
                            visualizePanel.setMasterPlot(plotData2D);
                            continue;
                        }
                        plotData2D.setPlotName("Plot " + (i + 1));
                        plotData2D.m_useCustomColour = true;
                        plotData2D.m_customColour = i % 2 == 0 ? Color.red : Color.blue;
                        visualizePanel.addPlot(plotData2D);
                        continue;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        JOptionPane.showMessageDialog(GUIChooser.this.m_Self, "Error loading file '" + fileArray[i] + "':\n" + exception.getMessage());
                        return;
                    }
                }
                final JFrame jFrame = new JFrame("Plot - " + string);
                jFrame.setIconImage(GUIChooser.this.m_Icon);
                jFrame.getContentPane().setLayout(new BorderLayout());
                jFrame.getContentPane().add((Component)visualizePanel, "Center");
                jFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        GUIChooser.this.m_Plots.remove(jFrame);
                        jFrame.dispose();
                        GUIChooser.this.checkExit();
                    }
                });
                jFrame.pack();
                jFrame.setSize(800, 600);
                jFrame.setVisible(true);
                GUIChooser.this.m_Plots.add(jFrame);
            }
        });
        JMenuItem jMenuItem7 = new JMenuItem();
        this.m_jMenuVisualization.add(jMenuItem7);
        jMenuItem7.setText("ROC");
        jMenuItem7.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = GUIChooser.this.m_FileChooserROC.showOpenDialog(GUIChooser.this.m_Self);
                if (n != 0) {
                    return;
                }
                String string = GUIChooser.this.m_FileChooserROC.getSelectedFile().getAbsolutePath();
                Instances instances = null;
                try {
                    instances = new Instances(new BufferedReader(new FileReader(string)));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(GUIChooser.this.m_Self, "Error loading file '" + string + "':\n" + exception.getMessage());
                    return;
                }
                instances.setClassIndex(instances.numAttributes() - 1);
                ThresholdVisualizePanel thresholdVisualizePanel = new ThresholdVisualizePanel();
                thresholdVisualizePanel.setROCString("(Area under ROC = " + Utils.doubleToString(ThresholdCurve.getROCArea(instances), 4) + ")");
                thresholdVisualizePanel.setName(instances.relationName());
                PlotData2D plotData2D = new PlotData2D(instances);
                plotData2D.setPlotName(instances.relationName());
                plotData2D.addInstanceNumberAttribute();
                try {
                    thresholdVisualizePanel.addPlot(plotData2D);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(GUIChooser.this.m_Self, "Error adding plot:\n" + exception.getMessage());
                    return;
                }
                final JFrame jFrame = new JFrame("ROC - " + string);
                jFrame.setIconImage(GUIChooser.this.m_Icon);
                jFrame.getContentPane().setLayout(new BorderLayout());
                jFrame.getContentPane().add((Component)thresholdVisualizePanel, "Center");
                jFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        GUIChooser.this.m_ROCs.remove(jFrame);
                        jFrame.dispose();
                        GUIChooser.this.checkExit();
                    }
                });
                jFrame.pack();
                jFrame.setSize(800, 600);
                jFrame.setVisible(true);
                GUIChooser.this.m_ROCs.add(jFrame);
            }
        });
        JMenuItem jMenuItem8 = new JMenuItem();
        this.m_jMenuVisualization.add(jMenuItem8);
        jMenuItem8.setText("TreeVisualizer");
        jMenuItem8.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = GUIChooser.this.m_FileChooserTreeVisualizer.showOpenDialog(GUIChooser.this.m_Self);
                if (n != 0) {
                    return;
                }
                String string = GUIChooser.this.m_FileChooserTreeVisualizer.getSelectedFile().getAbsolutePath();
                TreeBuild treeBuild = new TreeBuild();
                Node node = null;
                PlaceNode2 placeNode2 = new PlaceNode2();
                try {
                    node = treeBuild.create(new FileReader(string));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(GUIChooser.this.m_Self, "Error loading file '" + string + "':\n" + exception.getMessage());
                    return;
                }
                final JFrame jFrame = new JFrame("TreeVisualizer - " + string);
                jFrame.setIconImage(GUIChooser.this.m_Icon);
                jFrame.getContentPane().setLayout(new BorderLayout());
                jFrame.getContentPane().add((Component)new TreeVisualizer(null, node, (NodePlace)placeNode2), "Center");
                jFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        GUIChooser.this.m_TreeVisualizers.remove(jFrame);
                        jFrame.dispose();
                        GUIChooser.this.checkExit();
                    }
                });
                jFrame.pack();
                jFrame.setSize(800, 600);
                jFrame.setVisible(true);
                GUIChooser.this.m_TreeVisualizers.add(jFrame);
            }
        });
        JMenuItem jMenuItem9 = new JMenuItem();
        this.m_jMenuVisualization.add(jMenuItem9);
        jMenuItem9.setText("GraphVisualizer");
        jMenuItem9.setAccelerator(KeyStroke.getKeyStroke(71, 2));
        jMenuItem9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = GUIChooser.this.m_FileChooserGraphVisualizer.showOpenDialog(GUIChooser.this.m_Self);
                if (n != 0) {
                    return;
                }
                String string = GUIChooser.this.m_FileChooserGraphVisualizer.getSelectedFile().getAbsolutePath();
                GraphVisualizer graphVisualizer = new GraphVisualizer();
                try {
                    if (string.toLowerCase().endsWith(".xml") || string.toLowerCase().endsWith(".bif")) {
                        graphVisualizer.readBIF(new FileInputStream(string));
                    } else {
                        graphVisualizer.readDOT(new FileReader(string));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(GUIChooser.this.m_Self, "Error loading file '" + string + "':\n" + exception.getMessage());
                    return;
                }
                final JFrame jFrame = new JFrame("GraphVisualizer - " + string);
                jFrame.setIconImage(GUIChooser.this.m_Icon);
                jFrame.getContentPane().setLayout(new BorderLayout());
                jFrame.getContentPane().add((Component)graphVisualizer, "Center");
                jFrame.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        GUIChooser.this.m_GraphVisualizers.remove(jFrame);
                        jFrame.dispose();
                        GUIChooser.this.checkExit();
                    }
                });
                jFrame.pack();
                jFrame.setSize(800, 600);
                jFrame.setVisible(true);
                GUIChooser.this.m_GraphVisualizers.add(jFrame);
            }
        });
        final JMenuItem jMenuItem10 = new JMenuItem();
        this.m_jMenuVisualization.add(jMenuItem10);
        jMenuItem10.setText("BoundaryVisualizer");
        jMenuItem10.setAccelerator(KeyStroke.getKeyStroke(66, 2));
        jMenuItem10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIChooser.this.m_BoundaryVisualizerFrame == null) {
                    jMenuItem10.setEnabled(false);
                    GUIChooser.this.m_BoundaryVisualizerFrame = new JFrame("BoundaryVisualizer");
                    GUIChooser.this.m_BoundaryVisualizerFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_BoundaryVisualizerFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_BoundaryVisualizerFrame.getContentPane().add((Component)new BoundaryVisualizer(), "Center");
                    GUIChooser.this.m_BoundaryVisualizerFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            GUIChooser.this.m_BoundaryVisualizerFrame.dispose();
                            GUIChooser.this.m_BoundaryVisualizerFrame = null;
                            jMenuItem10.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_BoundaryVisualizerFrame.pack();
                    GUIChooser.this.m_BoundaryVisualizerFrame.setSize(800, 600);
                    GUIChooser.this.m_BoundaryVisualizerFrame.setVisible(true);
                    BoundaryVisualizer.setExitIfNoWindowsOpen(false);
                }
            }
        });
        JMenu jMenu = new JMenu("Extensions");
        jMenu.setMnemonic(69);
        this.m_jMenuBar.add(jMenu);
        jMenu.setVisible(false);
        String string2 = GenericObjectEditor.EDITOR_PROPERTIES.getProperty(MainMenuExtension.class.getName(), "");
        if (string2.length() > 0) {
            jMenu.setVisible(true);
            object3 = GenericObjectEditor.EDITOR_PROPERTIES.getProperty(MainMenuExtension.class.getName(), "").split(",");
            serializable = new Hashtable();
            for (int i = 0; i < ((String[])object3).length; ++i) {
                object2 = object3[i];
                try {
                    object = (MainMenuExtension)Class.forName((String)object2).newInstance();
                    jMenuItem2 = null;
                    if (object.getSubmenuTitle() != null && (jMenuItem2 = (JMenu)((Hashtable)serializable).get(object.getSubmenuTitle())) == null) {
                        jMenuItem2 = new JMenu(object.getSubmenuTitle());
                        ((Hashtable)serializable).put(object.getSubmenuTitle(), jMenuItem2);
                        this.insertMenuItem(jMenu, jMenuItem2);
                    }
                    jMenuItem = new JMenuItem();
                    jMenuItem.setText(object.getMenuTitle());
                    ActionListener actionListener = object.getActionListener(this.m_Self);
                    if (actionListener != null) {
                        jMenuItem.addActionListener(actionListener);
                    } else {
                        final JMenuItem jMenuItem11 = jMenuItem;
                        final MainMenuExtension mainMenuExtension = object;
                        jMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                Container container = GUIChooser.this.createFrame(GUIChooser.this.m_Self, jMenuItem11.getText(), null, null, null, -1, -1, null, false, false);
                                mainMenuExtension.fillFrame(container);
                                container.setVisible(true);
                            }
                        });
                    }
                    if (jMenuItem2 != null) {
                        this.insertMenuItem((JMenu)jMenuItem2, jMenuItem);
                        continue;
                    }
                    this.insertMenuItem(jMenu, jMenuItem);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        this.m_jMenuTools = new JMenu();
        this.m_jMenuBar.add(this.m_jMenuTools);
        this.m_jMenuTools.setText("Tools");
        this.m_jMenuTools.setMnemonic('T');
        object3 = new JMenuItem();
        this.m_jMenuTools.add((JMenuItem)object3);
        ((AbstractButton)object3).setText("ArffViewer");
        ((JMenuItem)object3).setAccelerator(KeyStroke.getKeyStroke(65, 2));
        ((AbstractButton)object3).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                final ArffViewer arffViewer = new ArffViewer();
                arffViewer.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        GUIChooser.this.m_ArffViewers.remove(arffViewer);
                        GUIChooser.this.checkExit();
                    }
                });
                arffViewer.setVisible(true);
                GUIChooser.this.m_ArffViewers.add(arffViewer);
            }
        });
        serializable = new JMenuItem();
        this.m_jMenuTools.add((JMenuItem)serializable);
        ((AbstractButton)serializable).setText("SqlViewer");
        ((JMenuItem)serializable).setAccelerator(KeyStroke.getKeyStroke(83, 2));
        ((AbstractButton)serializable).addActionListener(new ActionListener((JMenuItem)serializable){
            final /* synthetic */ JMenuItem val$jMenuItemToolsSql;
            {
                this.val$jMenuItemToolsSql = jMenuItem;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIChooser.this.m_SqlViewerFrame == null) {
                    this.val$jMenuItemToolsSql.setEnabled(false);
                    final SqlViewer sqlViewer = new SqlViewer(null);
                    GUIChooser.this.m_SqlViewerFrame = new JFrame("SqlViewer");
                    GUIChooser.this.m_SqlViewerFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_SqlViewerFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_SqlViewerFrame.getContentPane().add((Component)sqlViewer, "Center");
                    GUIChooser.this.m_SqlViewerFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            sqlViewer.saveSize();
                            GUIChooser.this.m_SqlViewerFrame.dispose();
                            GUIChooser.this.m_SqlViewerFrame = null;
                            val$jMenuItemToolsSql.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_SqlViewerFrame.pack();
                    GUIChooser.this.m_SqlViewerFrame.setVisible(true);
                }
            }
        });
        final JMenuItem jMenuItem12 = new JMenuItem();
        this.m_jMenuTools.add(jMenuItem12);
        jMenuItem12.setText("Bayes net editor");
        jMenuItem12.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        jMenuItem12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIChooser.this.m_BayesNetGUIFrame == null) {
                    jMenuItem12.setEnabled(false);
                    GUI gUI = new GUI();
                    JMenuBar jMenuBar = gUI.getMenuBar();
                    GUIChooser.this.m_BayesNetGUIFrame = new JFrame("Bayes Network Editor");
                    GUIChooser.this.m_BayesNetGUIFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_BayesNetGUIFrame.setJMenuBar(jMenuBar);
                    GUIChooser.this.m_BayesNetGUIFrame.getContentPane().add((Component)gUI, "Center");
                    GUIChooser.this.m_BayesNetGUIFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            GUIChooser.this.m_BayesNetGUIFrame.dispose();
                            GUIChooser.this.m_BayesNetGUIFrame = null;
                            jMenuItem12.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_BayesNetGUIFrame.setSize(800, 600);
                    GUIChooser.this.m_BayesNetGUIFrame.setVisible(true);
                }
            }
        });
        this.m_jMenuHelp = new JMenu();
        this.m_jMenuBar.add(this.m_jMenuHelp);
        this.m_jMenuHelp.setText("Help");
        this.m_jMenuHelp.setMnemonic('H');
        object2 = new JMenuItem();
        this.m_jMenuHelp.add((JMenuItem)object2);
        ((AbstractButton)object2).setText("Weka homepage");
        ((JMenuItem)object2).setAccelerator(KeyStroke.getKeyStroke(72, 2));
        ((AbstractButton)object2).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserHelper.openURL("http://www.cs.waikato.ac.nz/~ml/weka/");
            }
        });
        this.m_jMenuHelp.add(new JSeparator());
        object = new JMenuItem();
        this.m_jMenuHelp.add((JMenuItem)object);
        ((AbstractButton)object).setText("HOWTOs, code snippets, etc.");
        ((JMenuItem)object).setAccelerator(KeyStroke.getKeyStroke(87, 2));
        ((AbstractButton)object).addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserHelper.openURL("http://weka.wiki.sourceforge.net/");
            }
        });
        jMenuItem2 = new JMenuItem();
        this.m_jMenuHelp.add(jMenuItem2);
        jMenuItem2.setText("Weka on Sourceforge");
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserHelper.openURL("http://sourceforge.net/projects/weka/");
            }
        });
        jMenuItem = new JMenuItem();
        this.m_jMenuHelp.add(jMenuItem);
        jMenuItem.setText("SystemInfo");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(73, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIChooser.this.m_SystemInfoFrame == null) {
                    jMenuItem.setEnabled(false);
                    GUIChooser.this.m_SystemInfoFrame = new JFrame("SystemInfo");
                    GUIChooser.this.m_SystemInfoFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_SystemInfoFrame.getContentPane().setLayout(new BorderLayout());
                    Hashtable hashtable = new SystemInfo().getSystemInfo();
                    Vector vector = new Vector();
                    Enumeration enumeration = hashtable.keys();
                    while (enumeration.hasMoreElements()) {
                        vector.add(enumeration.nextElement());
                    }
                    Collections.sort(vector);
                    Object[][] objectArray = new String[hashtable.size()][2];
                    for (int i = 0; i < vector.size(); ++i) {
                        objectArray[i][0] = vector.get(i).toString();
                        objectArray[i][1] = hashtable.get(objectArray[i][0]).toString();
                    }
                    Object[] objectArray2 = new String[]{"Key", "Value"};
                    JTable jTable = new JTable(objectArray, objectArray2);
                    GUIChooser.this.m_SystemInfoFrame.getContentPane().add((Component)new JScrollPane(jTable), "Center");
                    GUIChooser.this.m_SystemInfoFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            GUIChooser.this.m_SystemInfoFrame.dispose();
                            GUIChooser.this.m_SystemInfoFrame = null;
                            jMenuItem.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_SystemInfoFrame.pack();
                    GUIChooser.this.m_SystemInfoFrame.setSize(800, 600);
                    GUIChooser.this.m_SystemInfoFrame.setVisible(true);
                }
            }
        });
        this.m_ExplorerBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIChooser.this.m_ExplorerFrame == null) {
                    GUIChooser.this.m_ExplorerBut.setEnabled(false);
                    GUIChooser.this.m_ExplorerFrame = new JFrame("Weka Explorer");
                    GUIChooser.this.m_ExplorerFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_ExplorerFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_ExplorerFrame.getContentPane().add((Component)new Explorer(), "Center");
                    GUIChooser.this.m_ExplorerFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            GUIChooser.this.m_ExplorerFrame.dispose();
                            GUIChooser.this.m_ExplorerFrame = null;
                            GUIChooser.this.m_ExplorerBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_ExplorerFrame.pack();
                    GUIChooser.this.m_ExplorerFrame.setSize(800, 600);
                    GUIChooser.this.m_ExplorerFrame.setVisible(true);
                }
            }
        });
        this.m_ExperimenterBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIChooser.this.m_ExperimenterFrame == null) {
                    GUIChooser.this.m_ExperimenterBut.setEnabled(false);
                    GUIChooser.this.m_ExperimenterFrame = new JFrame("Weka Experiment Environment");
                    GUIChooser.this.m_ExperimenterFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_ExperimenterFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_ExperimenterFrame.getContentPane().add((Component)new Experimenter(false), "Center");
                    GUIChooser.this.m_ExperimenterFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            GUIChooser.this.m_ExperimenterFrame.dispose();
                            GUIChooser.this.m_ExperimenterFrame = null;
                            GUIChooser.this.m_ExperimenterBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_ExperimenterFrame.pack();
                    GUIChooser.this.m_ExperimenterFrame.setSize(800, 600);
                    GUIChooser.this.m_ExperimenterFrame.setVisible(true);
                }
            }
        });
        KnowledgeFlowApp.addStartupListener(new StartUpListener(){

            public void startUpComplete() {
                if (GUIChooser.this.m_KnowledgeFlowFrame == null) {
                    final KnowledgeFlowApp knowledgeFlowApp = KnowledgeFlowApp.getSingleton();
                    GUIChooser.this.m_KnowledgeFlowBut.setEnabled(false);
                    GUIChooser.this.m_KnowledgeFlowFrame = new JFrame("Weka KnowledgeFlow Environment");
                    GUIChooser.this.m_KnowledgeFlowFrame.setIconImage(GUIChooser.this.m_Icon);
                    GUIChooser.this.m_KnowledgeFlowFrame.getContentPane().setLayout(new BorderLayout());
                    GUIChooser.this.m_KnowledgeFlowFrame.getContentPane().add((Component)knowledgeFlowApp, "Center");
                    GUIChooser.this.m_KnowledgeFlowFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            knowledgeFlowApp.clearLayout();
                            GUIChooser.this.m_KnowledgeFlowFrame.dispose();
                            GUIChooser.this.m_KnowledgeFlowFrame = null;
                            GUIChooser.this.m_KnowledgeFlowBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_KnowledgeFlowFrame.pack();
                    GUIChooser.this.m_KnowledgeFlowFrame.setSize(1000, 750);
                    GUIChooser.this.m_KnowledgeFlowFrame.setVisible(true);
                }
            }
        });
        this.m_KnowledgeFlowBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KnowledgeFlow.startApp();
            }
        });
        this.m_SimpleBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (GUIChooser.this.m_SimpleCLI == null) {
                    GUIChooser.this.m_SimpleBut.setEnabled(false);
                    try {
                        GUIChooser.this.m_SimpleCLI = new SimpleCLI();
                        GUIChooser.this.m_SimpleCLI.setIconImage(GUIChooser.this.m_Icon);
                    }
                    catch (Exception exception) {
                        throw new Error("Couldn't start SimpleCLI!");
                    }
                    GUIChooser.this.m_SimpleCLI.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            GUIChooser.this.m_SimpleCLI.dispose();
                            GUIChooser.this.m_SimpleCLI = null;
                            GUIChooser.this.m_SimpleBut.setEnabled(true);
                            GUIChooser.this.checkExit();
                        }
                    });
                    GUIChooser.this.m_SimpleCLI.setVisible(true);
                }
            }
        });
        this.setJMenuBar(this.m_jMenuBar);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                GUIChooser.this.dispose();
                GUIChooser.this.checkExit();
            }
        });
        this.pack();
    }

    protected void insertMenuItem(JMenu jMenu, JMenuItem jMenuItem) {
        this.insertMenuItem(jMenu, jMenuItem, 0);
    }

    protected void insertMenuItem(JMenu jMenu, JMenuItem jMenuItem, int n) {
        boolean bl = false;
        String string = jMenuItem.getText().toLowerCase();
        for (int i = n; i < jMenu.getMenuComponentCount(); ++i) {
            JMenuItem jMenuItem2;
            String string2;
            if (!(jMenu.getMenuComponent(i) instanceof JMenuItem) || (string2 = (jMenuItem2 = (JMenuItem)jMenu.getMenuComponent(i)).getText().toLowerCase()).compareTo(string) <= 0) continue;
            bl = true;
            jMenu.insert(jMenuItem, i);
            break;
        }
        if (!bl) {
            jMenu.add(jMenuItem);
        }
    }

    protected Container createFrame(GUIChooser gUIChooser, String string, Component component, LayoutManager layoutManager, Object object, int n, int n2, JMenuBar jMenuBar, boolean bl, boolean bl2) {
        ChildFrameSDI childFrameSDI = null;
        final ChildFrameSDI childFrameSDI2 = new ChildFrameSDI(gUIChooser, string);
        childFrameSDI2.setLayout(layoutManager);
        if (component != null) {
            childFrameSDI2.getContentPane().add(component, object);
        }
        childFrameSDI2.setJMenuBar(jMenuBar);
        childFrameSDI2.pack();
        if (n > -1 && n2 > -1) {
            childFrameSDI2.setSize(n, n2);
        }
        childFrameSDI2.validate();
        int n3 = this.getGraphicsConfiguration().getBounds().height;
        int n4 = this.getGraphicsConfiguration().getBounds().width;
        childFrameSDI2.setLocation((n4 - childFrameSDI2.getBounds().width) / 2, (n3 - childFrameSDI2.getBounds().height) / 2);
        if (bl) {
            childFrameSDI2.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    childFrameSDI2.dispose();
                }
            });
        }
        if (bl2) {
            childFrameSDI2.setVisible(true);
        }
        childFrameSDI = childFrameSDI2;
        return childFrameSDI;
    }

    protected void createTitle(String string) {
        String string2 = "Weka " + new Version();
        if (string.length() != 0) {
            string2 = string2 + " - " + string;
        }
        this.setTitle(string2);
    }

    public void addChildFrame(Container container) {
        this.m_ChildFrames.add(container);
    }

    public boolean removeChildFrame(Container container) {
        boolean bl = this.m_ChildFrames.remove(container);
        return bl;
    }

    private void checkExit() {
        if (!this.isVisible() && this.m_ExplorerFrame == null && this.m_ExperimenterFrame == null && this.m_KnowledgeFlowFrame == null && this.m_SimpleCLI == null && this.m_ArffViewers.size() == 0 && this.m_SqlViewerFrame == null && this.m_EnsembleLibraryFrame == null && this.m_Plots.size() == 0 && this.m_ROCs.size() == 0 && this.m_TreeVisualizers.size() == 0 && this.m_GraphVisualizers.size() == 0 && this.m_BoundaryVisualizerFrame == null && this.m_SystemInfoFrame == null) {
            System.exit(0);
        }
    }

    public static void main(String[] stringArray) {
        Logger.log(Logger.Level.INFO, "Logging started");
        LookAndFeel.setLookAndFeel();
        try {
            m_chooser = new GUIChooser();
            m_chooser.setVisible(true);
            Thread thread = new Thread(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                24.sleep(4000L);
                                System.gc();
                                if (!m_Memory.isOutOfMemory()) continue;
                                m_chooser.dispose();
                                if (m_chooser.m_ExperimenterFrame != null) {
                                    m_chooser.m_ExperimenterFrame.dispose();
                                    m_chooser.m_ExperimenterFrame = null;
                                }
                                if (m_chooser.m_ExplorerFrame != null) {
                                    m_chooser.m_ExplorerFrame.dispose();
                                    m_chooser.m_ExplorerFrame = null;
                                }
                                if (m_chooser.m_KnowledgeFlowFrame != null) {
                                    m_chooser.m_KnowledgeFlowFrame.dispose();
                                    m_chooser.m_KnowledgeFlowFrame = null;
                                }
                                if (m_chooser.m_SimpleCLI != null) {
                                    m_chooser.m_SimpleCLI.dispose();
                                    m_chooser.m_SimpleCLI = null;
                                }
                                if (m_chooser.m_ArffViewers.size() > 0) {
                                    for (int i = 0; i < m_chooser.m_ArffViewers.size(); ++i) {
                                        ArffViewer arffViewer = (ArffViewer)m_chooser.m_ArffViewers.get(i);
                                        arffViewer.dispose();
                                    }
                                    m_chooser.m_ArffViewers.clear();
                                }
                                m_chooser = null;
                                System.gc();
                                m_Memory.stopThreads();
                                m_chooser;
                                m_LogWindow.setVisible(true);
                                m_chooser;
                                m_LogWindow.toFront();
                                System.err.println("\ndisplayed message:");
                                m_Memory.showOutOfMemory();
                                System.err.println("\nexiting...");
                                System.exit(-1);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            };
            thread.setPriority(5);
            thread.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }

    static {
        m_Memory = new Memory(true);
    }

    public static class ChildFrameSDI
    extends JFrame {
        private static final long serialVersionUID = 8588293938686425618L;
        protected GUIChooser m_Parent;

        public ChildFrameSDI(GUIChooser gUIChooser, String string) {
            super(string);
            this.m_Parent = gUIChooser;
            this.addWindowListener(new WindowAdapter(){

                public void windowActivated(WindowEvent windowEvent) {
                    if (ChildFrameSDI.this.getParentFrame() != null) {
                        ChildFrameSDI.this.getParentFrame().createTitle(ChildFrameSDI.this.getTitle());
                    }
                }
            });
            if (this.getParentFrame() != null) {
                this.getParentFrame().addChildFrame(this);
                this.setIconImage(this.getParentFrame().getIconImage());
            }
        }

        public GUIChooser getParentFrame() {
            return this.m_Parent;
        }

        public void dispose() {
            if (this.getParentFrame() != null) {
                this.getParentFrame().removeChildFrame(this);
                this.getParentFrame().createTitle("");
            }
            super.dispose();
        }
    }
}

