/*
 * Decompiled with CFR 0.152.
 */
package weka.filters.unsupervised.attribute;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;
import weka.core.AttributeStats;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.MathematicalExpression;
import weka.core.Option;
import weka.core.Range;
import weka.core.SparseInstance;
import weka.core.Utils;
import weka.filters.UnsupervisedFilter;
import weka.filters.unsupervised.attribute.PotentialClassIgnorer;

public class MathExpression
extends PotentialClassIgnorer
implements UnsupervisedFilter {
    static final long serialVersionUID = -3713222714671997901L;
    protected Range m_SelectCols = new Range();
    public static final String m_defaultExpression = "(A-MIN)/(MAX-MIN)";
    private String m_expression = "(A-MIN)/(MAX-MIN)";
    private MathematicalExpression.TreeNode m_expTree = null;
    private AttributeStats[] m_attStats;

    public MathExpression() {
        this.setInvertSelection(false);
    }

    public String globalInfo() {
        return "Modify numeric attributes according to a given expression ";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enableAllAttributes();
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        return capabilities;
    }

    public boolean setInputFormat(Instances instances) throws Exception {
        this.m_SelectCols.setUpper(instances.numAttributes() - 1);
        super.setInputFormat(instances);
        this.setOutputFormat(instances);
        this.m_attStats = null;
        this.m_expTree = null;
        return true;
    }

    public boolean input(Instance instance) throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_NewBatch) {
            this.resetQueue();
            this.m_NewBatch = false;
        }
        if (this.m_attStats == null) {
            this.bufferInput(instance);
            return false;
        }
        this.convertInstance(instance);
        return true;
    }

    public boolean batchFinished() throws Exception {
        if (this.getInputFormat() == null) {
            throw new IllegalStateException("No input instance format defined");
        }
        if (this.m_attStats == null) {
            int n;
            Instances instances = this.getInputFormat();
            this.m_expTree = MathematicalExpression.parse(this.getExpression());
            this.m_attStats = new AttributeStats[instances.numAttributes()];
            for (n = 0; n < instances.numAttributes(); ++n) {
                if (!instances.attribute(n).isNumeric() || instances.classIndex() == n) continue;
                this.m_attStats[n] = instances.attributeStats(n);
            }
            for (n = 0; n < instances.numInstances(); ++n) {
                this.convertInstance(instances.instance(n));
            }
        }
        this.flushInput();
        this.m_NewBatch = true;
        return this.numPendingOutput() != 0;
    }

    private void convertInstance(Instance instance) throws Exception {
        Instance instance2 = null;
        HashMap<String, Double> hashMap = new HashMap<String, Double>(5);
        if (instance instanceof SparseInstance) {
            double[] dArray = new double[instance.numAttributes()];
            int[] nArray = new int[instance.numAttributes()];
            double[] dArray2 = instance.toDoubleArray();
            int n = 0;
            for (int i = 0; i < instance.numAttributes(); ++i) {
                double d;
                if (!this.m_SelectCols.isInRange(i)) continue;
                if (instance.attribute(i).isNumeric() && !Instance.isMissingValue(dArray2[i]) && this.getInputFormat().classIndex() != i) {
                    hashMap.put("A", new Double(dArray2[i]));
                    hashMap.put("MAX", new Double(this.m_attStats[i].numericStats.max));
                    hashMap.put("MIN", new Double(this.m_attStats[i].numericStats.min));
                    hashMap.put("MEAN", new Double(this.m_attStats[i].numericStats.mean));
                    hashMap.put("SD", new Double(this.m_attStats[i].numericStats.stdDev));
                    hashMap.put("COUNT", new Double(this.m_attStats[i].numericStats.count));
                    hashMap.put("SUM", new Double(this.m_attStats[i].numericStats.sum));
                    hashMap.put("SUMSQUARED", new Double(this.m_attStats[i].numericStats.sumSq));
                    d = this.m_expTree.eval(hashMap);
                    if (Double.isNaN(d) || Double.isInfinite(d)) {
                        System.err.println("WARNING:Error in evaluating the expression: missing value set");
                        d = Instance.missingValue();
                    }
                    if (d == 0.0) continue;
                    dArray[n] = d;
                    nArray[n] = i;
                    ++n;
                    continue;
                }
                d = dArray2[i];
                if (d == 0.0) continue;
                dArray[n] = d;
                nArray[n] = i;
                ++n;
            }
            double[] dArray3 = new double[n];
            int[] nArray2 = new int[n];
            System.arraycopy(dArray, 0, dArray3, 0, n);
            System.arraycopy(nArray, 0, nArray2, 0, n);
            instance2 = new SparseInstance(instance.weight(), dArray3, nArray2, instance.numAttributes());
        } else {
            double[] dArray = instance.toDoubleArray();
            for (int i = 0; i < this.getInputFormat().numAttributes(); ++i) {
                if (!this.m_SelectCols.isInRange(i) || !instance.attribute(i).isNumeric() || Instance.isMissingValue(dArray[i]) || this.getInputFormat().classIndex() == i) continue;
                hashMap.put("A", new Double(dArray[i]));
                hashMap.put("MAX", new Double(this.m_attStats[i].numericStats.max));
                hashMap.put("MIN", new Double(this.m_attStats[i].numericStats.min));
                hashMap.put("MEAN", new Double(this.m_attStats[i].numericStats.mean));
                hashMap.put("SD", new Double(this.m_attStats[i].numericStats.stdDev));
                hashMap.put("COUNT", new Double(this.m_attStats[i].numericStats.count));
                hashMap.put("SUM", new Double(this.m_attStats[i].numericStats.sum));
                hashMap.put("SUMSQUARED", new Double(this.m_attStats[i].numericStats.sumSq));
                dArray[i] = this.m_expTree.eval(hashMap);
                if (!Double.isNaN(dArray[i]) && !Double.isInfinite(dArray[i])) continue;
                System.err.println("WARNING:Error in Evaluation the Expression: missing value set");
                dArray[i] = Instance.missingValue();
            }
            instance2 = new Instance(instance.weight(), dArray);
        }
        instance2.setDataset(instance.dataset());
        this.push(instance2);
    }

    public void setOptions(String[] stringArray) throws Exception {
        super.setOptions(stringArray);
        String string = Utils.getOption('E', stringArray);
        if (string.length() != 0) {
            this.setExpression(string);
        } else {
            this.setExpression(m_defaultExpression);
        }
        String string2 = Utils.getOption('R', stringArray);
        if (string2.length() != 0) {
            this.setIgnoreRange(string2);
        }
        this.setInvertSelection(Utils.getFlag('V', stringArray));
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-E");
        vector.add(this.getExpression());
        if (this.getInvertSelection()) {
            vector.add("-V");
        }
        if (!this.getIgnoreRange().equals("")) {
            vector.add("-R");
            vector.add(this.getIgnoreRange());
        }
        return vector.toArray(new String[vector.size()]);
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        vector.addElement(new Option("\tSpecify the expression to apply. Eg. pow(A,6)/(MEAN+MAX)\n\tSupported operators are +, -, *, /, pow, log,\n\tabs, cos, exp, sqrt, tan, sin, ceil, floor, rint, (, ), \n\tMEAN, MAX, MIN, SD, COUNT, SUM, SUMSQUARED, ifelse", "E", 1, "-E <expression>"));
        vector.addElement(new Option("\tSpecify list of columns to ignore. First and last are valid\n\tindexes. (default none)", "R", 1, "-R <index1,index2-index4,...>"));
        vector.addElement(new Option("\tInvert matching sense (i.e. only modify specified columns)", "V", 0, "-V"));
        return vector.elements();
    }

    public String expressionTipText() {
        return "Specify the expression to apply. The 'A' letterrefers to the attribute value. MIN,MAX,MEAN,SDrefer respectively to minimum, maximum, mean andstandard deviation of the attribute.\n\tSupported operators are +, -, *, /, pow, log,abs, cos, exp, sqrt, tan, sin, ceil, floor, rint, (, ),A,MEAN, MAX, MIN, SD, COUNT, SUM, SUMSQUARED, ifelse\n\tEg. pow(A,6)/(MEAN+MAX)*ifelse(A<0,0,sqrt(A))+ifelse(![A>9 && A<15])";
    }

    public void setExpression(String string) {
        this.m_expression = string;
    }

    public String getExpression() {
        return this.m_expression;
    }

    public String invertSelectionTipText() {
        return "Determines whether action is to select or unselect. If set to true, only the specified attributes will be modified; If set to false, specified attributes will not be modified.";
    }

    public boolean getInvertSelection() {
        return !this.m_SelectCols.getInvert();
    }

    public void setInvertSelection(boolean bl) {
        this.m_SelectCols.setInvert(!bl);
    }

    public String ignoreRangeTipText() {
        return "Specify range of attributes to act on. This is a comma separated list of attribute indices, with \"first\" and \"last\" valid values. Specify an inclusive range with \"-\". E.g: \"first-3,5,6-10,last\".";
    }

    public String getIgnoreRange() {
        return this.m_SelectCols.getRanges();
    }

    public void setIgnoreRange(String string) {
        this.m_SelectCols.setRanges(string);
    }

    public static void main(String[] stringArray) {
        MathExpression.runFilter(new MathExpression(), stringArray);
    }
}

