/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Arrays;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;

public class IsotonicRegression
extends Classifier
implements WeightedInstancesHandler {
    static final long serialVersionUID = 1679336022835454137L;
    private Attribute m_attribute;
    private double[] m_cuts;
    private double[] m_values;
    private double m_minMsq;

    public String globalInfo() {
        return "Learns an isotonic regression model. Picks the attribute that results in the lowest squared error. Missing values are not allowed. Can only deal with numeric attributes.Considers the monotonically increasing case as well as the monotonicallydecreasing case";
    }

    public double classifyInstance(Instance instance) throws Exception {
        if (instance.isMissing(this.m_attribute.index())) {
            throw new Exception("IsotonicRegression: No missing values!");
        }
        int n = Arrays.binarySearch(this.m_cuts, instance.value(this.m_attribute));
        if (n < 0) {
            return this.m_values[-n - 1];
        }
        return this.m_values[n + 1];
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_CLASS);
        capabilities.enable(Capabilities.Capability.DATE_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    protected void regress(Attribute attribute, Instances instances, boolean bl) throws Exception {
        double[] dArray;
        double[] dArray2;
        int n;
        instances.sort(attribute);
        double[] dArray3 = new double[instances.numInstances()];
        double[] dArray4 = new double[instances.numInstances()];
        double[] dArray5 = new double[instances.numInstances() - 1];
        int n2 = 0;
        dArray3[0] = instances.instance(0).classValue();
        dArray4[0] = instances.instance(0).weight();
        for (n = 1; n < instances.numInstances(); ++n) {
            if (instances.instance(n).value(attribute) > instances.instance(n - 1).value(attribute)) {
                dArray5[n2] = (instances.instance(n).value(attribute) + instances.instance(n - 1).value(attribute)) / 2.0;
            }
            int n3 = ++n2;
            dArray3[n3] = dArray3[n3] + instances.instance(n).classValue();
            int n4 = n2;
            dArray4[n4] = dArray4[n4] + instances.instance(n).weight();
        }
        ++n2;
        do {
            n = 0;
            double[] dArray6 = new double[n2];
            dArray2 = new double[n2];
            dArray = new double[n2 - 1];
            int n5 = 0;
            dArray6[0] = dArray3[0];
            dArray2[0] = dArray4[0];
            for (int i = 1; i < n2; ++i) {
                if (bl && dArray3[i] / dArray4[i] > dArray6[n5] / dArray2[n5] || !bl && dArray3[i] / dArray4[i] < dArray6[n5] / dArray2[n5]) {
                    dArray[n5] = dArray5[i - 1];
                    dArray6[++n5] = dArray3[i];
                    dArray2[n5] = dArray4[i];
                    continue;
                }
                int n6 = n5;
                dArray2[n6] = dArray2[n6] + dArray4[i];
                int n7 = n5;
                dArray6[n7] = dArray6[n7] + dArray3[i];
                n = 1;
            }
            dArray3 = dArray6;
            dArray4 = dArray2;
            dArray5 = dArray;
            n2 = ++n5;
        } while (n != 0);
        for (int i = 0; i < n2; ++i) {
            int n8 = i;
            dArray3[n8] = dArray3[n8] / dArray4[i];
        }
        Attribute attribute2 = this.m_attribute;
        dArray2 = this.m_cuts;
        dArray = this.m_values;
        this.m_attribute = attribute;
        this.m_cuts = dArray5;
        this.m_values = dArray3;
        Evaluation evaluation = new Evaluation(instances);
        evaluation.evaluateModel(this, instances);
        double d = evaluation.rootMeanSquaredError();
        if (d < this.m_minMsq) {
            this.m_minMsq = d;
        } else {
            this.m_attribute = attribute2;
            this.m_cuts = dArray2;
            this.m_values = dArray;
        }
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_minMsq = Double.MAX_VALUE;
        this.m_attribute = null;
        for (int i = 0; i < instances.numAttributes(); ++i) {
            if (i == instances.classIndex()) continue;
            this.regress(instances.attribute(i), instances, true);
            this.regress(instances.attribute(i), instances, false);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Isotonic regression\n\n");
        if (this.m_attribute == null) {
            stringBuffer.append("No model built yet!");
        } else {
            stringBuffer.append("Based on attribute: " + this.m_attribute.name() + "\n\n");
            for (int i = 0; i < this.m_values.length; ++i) {
                stringBuffer.append("prediction: " + Utils.doubleToString(this.m_values[i], 10, 2));
                if (i >= this.m_cuts.length) continue;
                stringBuffer.append("\t\tcut point: " + Utils.doubleToString(this.m_cuts[i], 10, 2) + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        IsotonicRegression.runClassifier(new IsotonicRegression(), stringArray);
    }
}

