/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import weka.core.FastVector;
import weka.core.RevisionUtils;
import weka.experiment.DatabaseUtils;
import weka.experiment.ResultListener;
import weka.experiment.ResultProducer;

public class DatabaseResultListener
extends DatabaseUtils
implements ResultListener {
    static final long serialVersionUID = 7388014746954652818L;
    protected ResultProducer m_ResultProducer;
    protected String m_ResultsTableName;
    protected boolean m_Debug = true;
    protected String m_CacheKeyName = "";
    protected int m_CacheKeyIndex;
    protected Object[] m_CacheKey;
    protected FastVector m_Cache = new FastVector();

    public String globalInfo() {
        return "Takes results from a result producer and sends them to a database.";
    }

    public void preProcess(ResultProducer resultProducer) throws Exception {
        this.m_ResultProducer = resultProducer;
        this.updateResultsTableName(this.m_ResultProducer);
    }

    public void postProcess(ResultProducer resultProducer) throws Exception {
        if (this.m_ResultProducer != resultProducer) {
            throw new Error("Unrecognized ResultProducer calling postProcess!!");
        }
        this.disconnectFromDatabase();
    }

    public String[] determineColumnConstraints(ResultProducer resultProducer) throws Exception {
        Object object;
        FastVector fastVector = new FastVector();
        this.updateResultsTableName(resultProducer);
        DatabaseMetaData databaseMetaData = this.m_Connection.getMetaData();
        ResultSet resultSet = this.m_checkForUpperCaseNames ? databaseMetaData.getColumns(null, null, this.m_ResultsTableName.toUpperCase(), null) : databaseMetaData.getColumns(null, null, this.m_ResultsTableName, null);
        boolean bl = false;
        int n = 0;
        while (resultSet.next()) {
            bl = true;
            object = resultSet.getString(4);
            if (!((String)object).toLowerCase().startsWith("measure")) continue;
            ++n;
            fastVector.addElement(object);
        }
        if (!bl) {
            return null;
        }
        object = new String[n];
        for (int i = 0; i < n; ++i) {
            object[i] = (String)fastVector.elementAt(i);
        }
        return object;
    }

    public void acceptResult(ResultProducer resultProducer, Object[] objectArray, Object[] objectArray2) throws Exception {
        if (this.m_ResultProducer != resultProducer) {
            throw new Error("Unrecognized ResultProducer calling acceptResult!!");
        }
        if (objectArray2 != null) {
            this.putResultInTable(this.m_ResultsTableName, resultProducer, objectArray, objectArray2);
        }
    }

    public boolean isResultRequired(ResultProducer resultProducer, Object[] objectArray) throws Exception {
        int n;
        if (this.m_ResultProducer != resultProducer) {
            throw new Error("Unrecognized ResultProducer calling isResultRequired!");
        }
        if (this.m_Debug) {
            System.err.print("Is result required...");
            for (n = 0; n < objectArray.length; ++n) {
                System.err.print(" " + objectArray[n]);
            }
            System.err.flush();
        }
        n = 0;
        if (!this.m_CacheKeyName.equals("")) {
            if (!this.isCacheValid(objectArray)) {
                this.loadCache(resultProducer, objectArray);
            }
            n = !this.isKeyInCache(resultProducer, objectArray) ? 1 : 0;
        } else {
            int n2 = n = !this.isKeyInTable(this.m_ResultsTableName, resultProducer, objectArray) ? 1 : 0;
        }
        if (this.m_Debug) {
            System.err.println(" ..." + (n != 0 ? "required" : "not required") + (this.m_CacheKeyName.equals("") ? "" : " (cache)"));
            System.err.flush();
        }
        return n != 0;
    }

    protected void updateResultsTableName(ResultProducer resultProducer) throws Exception {
        String string;
        if (!this.isConnected()) {
            this.connectToDatabase();
        }
        if (!this.experimentIndexExists()) {
            this.createExperimentIndex();
        }
        if ((string = this.getResultsTableName(resultProducer)) == null) {
            string = this.createExperimentIndexEntry(resultProducer);
        }
        if (!this.tableExists(string)) {
            this.createResultsTable(resultProducer, string);
        }
        this.m_ResultsTableName = string;
    }

    public String cacheKeyNameTipText() {
        return "Set the name of the key field by which to cache.";
    }

    public String getCacheKeyName() {
        return this.m_CacheKeyName;
    }

    public void setCacheKeyName(String string) {
        this.m_CacheKeyName = string;
    }

    protected boolean isCacheValid(Object[] objectArray) {
        if (this.m_CacheKey == null) {
            return false;
        }
        if (this.m_CacheKey.length != objectArray.length) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (i == this.m_CacheKeyIndex || this.m_CacheKey[i].equals(objectArray[i])) continue;
            return false;
        }
        return true;
    }

    protected boolean isKeyInCache(ResultProducer resultProducer, Object[] objectArray) throws Exception {
        for (int i = 0; i < this.m_Cache.size(); ++i) {
            if (!this.m_Cache.elementAt(i).equals(objectArray[this.m_CacheKeyIndex])) continue;
            return true;
        }
        return false;
    }

    protected void loadCache(ResultProducer resultProducer, Object[] objectArray) throws Exception {
        int n;
        System.err.print(" (updating cache)");
        System.err.flush();
        this.m_Cache.removeAllElements();
        this.m_CacheKey = null;
        String string = "SELECT Key_" + this.m_CacheKeyName + " FROM " + this.m_ResultsTableName;
        String[] stringArray = resultProducer.getKeyNames();
        if (stringArray.length != objectArray.length) {
            throw new Exception("Key names and key values of different lengths");
        }
        this.m_CacheKeyIndex = -1;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equalsIgnoreCase(this.m_CacheKeyName)) continue;
            this.m_CacheKeyIndex = n;
            break;
        }
        if (this.m_CacheKeyIndex == -1) {
            throw new Exception("No key field named " + this.m_CacheKeyName + " (as specified for caching)");
        }
        n = 1;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || i == this.m_CacheKeyIndex) continue;
            if (n != 0) {
                string = string + " WHERE ";
                n = 0;
            } else {
                string = string + " AND ";
            }
            string = string + "Key_" + stringArray[i] + '=';
            string = objectArray[i] instanceof String ? string + "'" + DatabaseUtils.processKeyString(objectArray[i].toString()) + "'" : string + objectArray[i].toString();
        }
        ResultSet resultSet = this.select(string);
        while (resultSet.next()) {
            String string2 = resultSet.getString(1);
            if (resultSet.wasNull()) continue;
            this.m_Cache.addElement(string2);
        }
        this.close(resultSet);
        this.m_CacheKey = (Object[])objectArray.clone();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5125 $");
    }
}

