/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.clusterers.RandomizableClusterer;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.core.matrix.Matrix;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class sIB
extends RandomizableClusterer
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -8652125897352654213L;
    private Instances m_data;
    private int m_numCluster = 2;
    private int m_numRestarts = 5;
    private boolean m_verbose = false;
    private boolean m_uniformPrior = true;
    private int m_maxLoop = 100;
    private int m_minChange = 0;
    private ReplaceMissingValues m_replaceMissing;
    private int m_numInstances;
    private int m_numAttributes;
    private Random random;
    private Partition bestT;
    private Input input;

    public void buildClusterer(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        this.m_replaceMissing = new ReplaceMissingValues();
        Instances instances2 = new Instances(instances);
        instances2.setClassIndex(-1);
        this.m_replaceMissing.setInputFormat(instances2);
        instances = Filter.useFilter(instances2, this.m_replaceMissing);
        instances2 = null;
        this.m_data = instances;
        this.m_numInstances = this.m_data.numInstances();
        this.m_numAttributes = this.m_data.numAttributes();
        this.random = new Random(this.getSeed());
        this.input = this.sIB_ProcessInput();
        this.bestT = new Partition();
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.m_numRestarts; ++i) {
            if (this.m_verbose) {
                System.out.format("restart number %s...\n", i);
            }
            Partition partition = this.sIB_InitT(this.input);
            if ((partition = this.sIB_OptimizeT(partition, this.input)).L > d) {
                partition.copy(this.bestT);
                d = this.bestT.L;
            }
            if (!this.m_verbose) continue;
            System.out.println("\nPartition status : ");
            System.out.println("------------------");
            System.out.println(partition.toString() + "\n");
        }
        if (this.m_verbose) {
            System.out.println("\nBest Partition");
            System.out.println("===============");
            System.out.println(this.bestT.toString());
        }
        this.m_data = new Instances(this.m_data, 0);
    }

    public int clusterInstance(Instance instance) throws Exception {
        double d = 1.0 / this.input.sumVals;
        double[] dArray = new double[this.m_numCluster];
        for (int i = 0; i < this.m_numCluster; ++i) {
            double d2 = this.bestT.Pt[i] + d;
            double d3 = d / d2;
            double d4 = this.bestT.Pt[i] / d2;
            dArray[i] = d2 * this.JS(instance, i, d3, d4);
        }
        return Utils.minIndex(dArray);
    }

    private Input sIB_ProcessInput() {
        int n;
        int n2;
        double d = 0.0;
        for (int i = 0; i < this.m_numInstances; ++i) {
            d = 0.0;
            for (n2 = 0; n2 < this.m_data.instance(i).numValues(); ++n2) {
                d += this.m_data.instance(i).valueSparse(n2);
            }
            if (!(d <= 0.0)) continue;
            if (this.m_verbose) {
                System.out.format("Instance %s sum of value = %s <= 0, removed.\n", i, d);
            }
            this.m_data.delete(i);
            --this.m_numInstances;
        }
        Input input = new Input();
        input.Py_x = this.getTransposedNormedMatrix(this.m_data);
        if (this.m_uniformPrior) {
            input.Pyx = input.Py_x.copy();
            this.normalizePrior(this.m_data);
        } else {
            input.Pyx = this.getTransposedMatrix(this.m_data);
        }
        input.sumVals = this.getTotalSum(this.m_data);
        input.Pyx.timesEquals(1.0 / input.sumVals);
        Input.access$1002(input, new double[this.m_numInstances]);
        for (n2 = 0; n2 < this.m_numInstances; ++n2) {
            for (n = 0; n < this.m_numAttributes; ++n) {
                double[] dArray = input.Px;
                int n3 = n2;
                dArray[n3] = dArray[n3] + input.Pyx.get(n, n2);
            }
        }
        Input.access$1102(input, new double[this.m_numAttributes]);
        for (n2 = 0; n2 < input.Pyx.getRowDimension(); ++n2) {
            for (n = 0; n < input.Pyx.getColumnDimension(); ++n) {
                double[] dArray = input.Py;
                int n4 = n2;
                dArray[n4] = dArray[n4] + input.Pyx.get(n2, n);
            }
        }
        this.MI(input.Pyx, input);
        return input;
    }

    private Partition sIB_InitT(Input input) {
        int n;
        Partition partition = new Partition();
        int n2 = (int)Math.ceil((double)this.m_numInstances / (double)this.m_numCluster);
        ArrayList arrayList = new ArrayList();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (n = 0; n < this.m_numInstances; ++n) {
            arrayList2.add(n);
        }
        while (arrayList2.size() != 0) {
            n = this.random.nextInt(arrayList2.size());
            arrayList.add(arrayList2.get(n));
            arrayList2.remove(n);
        }
        for (n = 0; n < this.m_numCluster; ++n) {
            int n3;
            int n4 = n2 > arrayList.size() ? arrayList.size() : n2;
            for (n3 = 0; n3 < n4; ++n3) {
                ((Partition)partition).Pt_x[((Integer)arrayList.get((int)n3)).intValue()] = n;
            }
            for (n3 = 0; n3 < n4; ++n3) {
                arrayList.remove(0);
            }
        }
        for (n = 0; n < this.m_numCluster; ++n) {
            ArrayList arrayList3 = partition.find(n);
            for (int i = 0; i < arrayList3.size(); ++i) {
                double[] dArray = partition.Pt;
                int n5 = n;
                dArray[n5] = dArray[n5] + input.Px[(Integer)arrayList3.get(i)];
            }
            double[][] dArray = input.Pyx.getArray();
            for (int i = 0; i < this.m_numAttributes; ++i) {
                double d = 0.0;
                for (int j = 0; j < arrayList3.size(); ++j) {
                    d += dArray[i][(Integer)arrayList3.get(j)];
                }
                partition.Py_t.set(i, n, d /= partition.Pt[n]);
            }
        }
        if (this.m_verbose) {
            System.out.println("Initializing...");
        }
        return partition;
    }

    private Partition sIB_OptimizeT(Partition partition, Input input) {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        if (this.m_verbose) {
            System.out.println("Optimizing...");
            System.out.println("-------------");
        }
        while (!bl) {
            n = 0;
            for (int i = 0; i < this.m_numInstances; ++i) {
                int n3 = partition.Pt_x[i];
                if (partition.size(n3) == 1) {
                    if (!this.m_verbose) continue;
                    System.out.format("cluster %s has only 1 doc remain\n", n3);
                    continue;
                }
                this.reduce_x(i, n3, partition, input);
                int n4 = this.clusterInstance(i, input, partition);
                if (n4 == n3) continue;
                ++n;
                this.updateAssignment(i, n4, partition, input.Px[i], input.Py_x);
            }
            partition.counter += n;
            if (this.m_verbose) {
                System.out.format("iteration %s , changes : %s\n", n2, n);
            }
            bl = this.checkConvergence(n, n2);
            ++n2;
        }
        partition.L = this.sIB_local_MI(partition.Py_t, partition.Pt);
        if (this.m_verbose) {
            System.out.format("score (L) : %s \n", Utils.doubleToString(partition.L, 4));
        }
        return partition;
    }

    private void reduce_x(int n, int n2, Partition partition, Input input) {
        ArrayList arrayList = partition.find(n2);
        double d = 0.0;
        for (int i = 0; i < arrayList.size(); ++i) {
            if ((Integer)arrayList.get(i) == n) continue;
            d += input.Px[(Integer)arrayList.get(i)];
        }
        ((Partition)partition).Pt[n2] = d;
        if (partition.Pt[n2] < 0.0) {
            System.out.format("Warning: probability < 0 (%s)\n", partition.Pt[n2]);
            ((Partition)partition).Pt[n2] = 0.0;
        }
        double[][] dArray = input.Pyx.getArray();
        for (int i = 0; i < this.m_numAttributes; ++i) {
            d = 0.0;
            for (int j = 0; j < arrayList.size(); ++j) {
                if ((Integer)arrayList.get(j) == n) continue;
                d += dArray[i][(Integer)arrayList.get(j)];
            }
            partition.Py_t.set(i, n2, d / partition.Pt[n2]);
        }
    }

    private void updateAssignment(int n, int n2, Partition partition, double d, Matrix matrix) {
        ((Partition)partition).Pt_x[n] = n2;
        double d2 = d + partition.Pt[n2];
        double d3 = d / d2;
        double d4 = partition.Pt[n2] / d2;
        for (int i = 0; i < this.m_numAttributes; ++i) {
            partition.Py_t.set(i, n2, d3 * matrix.get(i, n) + d4 * partition.Py_t.get(i, n2));
        }
        ((Partition)partition).Pt[n2] = d2;
    }

    private boolean checkConvergence(int n, int n2) {
        if (n <= this.m_minChange || n2 >= this.m_maxLoop) {
            if (this.m_verbose) {
                System.out.format("\nsIB converged after %s iterations with %s changes\n", n2, n);
            }
            return true;
        }
        return false;
    }

    private int clusterInstance(int n, Input input, Partition partition) {
        double[] dArray = new double[this.m_numCluster];
        for (int i = 0; i < this.m_numCluster; ++i) {
            double d = input.Px[n] + partition.Pt[i];
            double d2 = input.Px[n] / d;
            double d3 = partition.Pt[i] / d;
            dArray[i] = d * this.JS(n, input, partition, i, d2, d3);
        }
        return Utils.minIndex(dArray);
    }

    private double JS(int n, Input input, Partition partition, int n2, double d, double d2) {
        int n3;
        if (Math.min(d, d2) <= 0.0) {
            System.out.format("Warning: zero or negative weights in JS calculation! (pi1 %s, pi2 %s)\n", d, d2);
            return 0.0;
        }
        Instance instance = this.m_data.instance(n);
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (n3 = 0; n3 < instance.numValues(); ++n3) {
            d5 = input.Py_x.get(instance.index(n3), n);
            if (d5 == 0.0) continue;
            d3 += d5 * Math.log(d5 / (d5 * d + d2 * partition.Py_t.get(instance.index(n3), n2)));
        }
        for (n3 = 0; n3 < this.m_numAttributes; ++n3) {
            d5 = partition.Py_t.get(n3, n2);
            if (d5 == 0.0) continue;
            d4 += d5 * Math.log(d5 / (input.Py_x.get(n3, n) * d + d2 * d5));
        }
        return d * d3 + d2 * d4;
    }

    private double JS(Instance instance, int n, double d, double d2) {
        int n2;
        if (Math.min(d, d2) <= 0.0) {
            System.out.format("Warning: zero or negative weights in JS calculation! (pi1 %s, pi2 %s)\n", d, d2);
            return 0.0;
        }
        double d3 = Utils.sum(instance.toDoubleArray());
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (n2 = 0; n2 < instance.numValues(); ++n2) {
            d6 = instance.valueSparse(n2) / d3;
            if (d6 == 0.0) continue;
            d4 += d6 * Math.log(d6 / (d6 * d + d2 * this.bestT.Py_t.get(instance.index(n2), n)));
        }
        for (n2 = 0; n2 < this.m_numAttributes; ++n2) {
            d6 = this.bestT.Py_t.get(n2, n);
            if (d6 == 0.0) continue;
            d5 += d6 * Math.log(d6 / (instance.value(n2) * d / d3 + d2 * d6));
        }
        return d * d4 + d2 * d5;
    }

    private double sIB_local_MI(Matrix matrix, double[] dArray) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        for (n = 0; n < dArray.length; ++n) {
            d2 += dArray[n] * Math.log(dArray[n]);
        }
        d2 = -d2;
        for (n = 0; n < this.m_numAttributes; ++n) {
            double d3 = 0.0;
            for (int i = 0; i < this.m_numCluster; ++i) {
                d3 += matrix.get(n, i) * dArray[i];
            }
            if (d3 == 0.0) continue;
            d += d3 * Math.log(d3);
        }
        d = -d;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                d5 = matrix.get(i, j);
                if (d5 == 0.0 || dArray[j] == 0.0) continue;
                d4 += (d5 *= dArray[j]) * Math.log(d5);
            }
        }
        return d + d2 + d4;
    }

    private double getTotalSum(Instances instances) {
        double d = 0.0;
        for (int i = 0; i < instances.numInstances(); ++i) {
            for (int j = 0; j < instances.instance(i).numValues(); ++j) {
                d += instances.instance(i).valueSparse(j);
            }
        }
        return d;
    }

    private Matrix getTransposedMatrix(Instances instances) {
        double[][] dArray = new double[instances.numAttributes()][instances.numInstances()];
        for (int i = 0; i < instances.numInstances(); ++i) {
            Instance instance = instances.instance(i);
            for (int j = 0; j < instance.numValues(); ++j) {
                dArray[instance.index((int)j)][i] = instance.valueSparse(j);
            }
        }
        Matrix matrix = new Matrix(dArray);
        return matrix;
    }

    private void normalizePrior(Instances instances) {
        for (int i = 0; i < instances.numInstances(); ++i) {
            this.normalizeInstance(instances.instance(i));
        }
    }

    private Instance normalizeInstance(Instance instance) {
        double[] dArray = instance.toDoubleArray();
        double d = Utils.sum(dArray);
        int n = 0;
        while (n < dArray.length) {
            int n2 = n++;
            dArray[n2] = dArray[n2] / d;
        }
        return new Instance(instance.weight(), dArray);
    }

    private Matrix getTransposedNormedMatrix(Instances instances) {
        Matrix matrix = new Matrix(instances.numAttributes(), instances.numInstances());
        for (int i = 0; i < instances.numInstances(); ++i) {
            double[] dArray = instances.instance(i).toDoubleArray();
            double d = Utils.sum(dArray);
            for (int j = 0; j < dArray.length; ++j) {
                int n = j;
                dArray[n] = dArray[n] / d;
                matrix.set(j, i, dArray[j]);
            }
        }
        return matrix;
    }

    private void MI(Matrix matrix, Input input) {
        int n;
        int n2 = n = matrix.getColumnDimension() < matrix.getRowDimension() ? matrix.getColumnDimension() : matrix.getRowDimension();
        if (n < 2) {
            System.err.println("Warning : This is not a JOINT distribution");
            input.Hx = this.Entropy(matrix);
            input.Hy = 0.0;
            input.Ixy = 0.0;
            return;
        }
        input.Hx = this.Entropy(input.Px);
        input.Hy = this.Entropy(input.Py);
        double d = input.Hx + input.Hy;
        for (int i = 0; i < this.m_numInstances; ++i) {
            Instance instance = this.m_data.instance(i);
            for (int j = 0; j < instance.numValues(); ++j) {
                double d2 = matrix.get(instance.index(j), i);
                if (d2 <= 0.0) continue;
                d += d2 * Math.log(d2);
            }
        }
        input.Ixy = d;
        if (this.m_verbose) {
            System.out.println("Ixy = " + input.Ixy);
        }
    }

    private double Entropy(double[] dArray) {
        for (int i = 0; i < dArray.length; ++i) {
            if (!(dArray[i] <= 0.0)) continue;
            if (this.m_verbose) {
                System.out.println("Warning: Negative probability.");
            }
            return Double.NaN;
        }
        if (Math.abs(Utils.sum(dArray) - 1.0) >= 1.0E-6) {
            if (this.m_verbose) {
                System.out.println("Warning: Not normalized.");
            }
            return Double.NaN;
        }
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i] * Math.log(dArray[i]);
        }
        d = -d;
        return d;
    }

    private double Entropy(Matrix matrix) {
        double d = 0.0;
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                if (matrix.get(i, j) == 0.0) continue;
                d += matrix.get(i, j) + Math.log(matrix.get(i, j));
            }
        }
        d = -d;
        return d;
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('I', stringArray);
        if (string.length() != 0) {
            this.setMaxIterations(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('M', stringArray)).length() != 0) {
            this.setMinChange(new Integer(string));
        }
        if ((string = Utils.getOption('N', stringArray)).length() != 0) {
            this.setNumClusters(Integer.parseInt(string));
        }
        if ((string = Utils.getOption('R', stringArray)).length() != 0) {
            this.setNumRestarts(new Integer(string));
        }
        this.setNotUnifyNorm(Utils.getFlag('U', stringArray));
        this.setDebug(Utils.getFlag('V', stringArray));
        super.setOptions(stringArray);
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tmaximum number of iterations\n\t(default 100).", "I", 1, "-I <num>"));
        vector.addElement(new Option("\tminimum number of changes in a single iteration\n\t(default 0).", "M", 1, "-M <num>"));
        vector.addElement(new Option("\tnumber of clusters.\n\t(default 2).", "N", 1, "-N <num>"));
        vector.addElement(new Option("\tnumber of restarts.\n\t(default 5).", "R", 1, "-R <num>"));
        vector.addElement(new Option("\tset not to normalize the data\n\t(default true).", "U", 0, "-U"));
        vector.addElement(new Option("\tset to output debug info\n\t(default false).", "V", 0, "-V"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        vector.add("-I");
        vector.add("" + this.getMaxIterations());
        vector.add("-M");
        vector.add("" + this.getMinChange());
        vector.add("-N");
        vector.add("" + this.getNumClusters());
        vector.add("-R");
        vector.add("" + this.getNumRestarts());
        if (this.getNotUnifyNorm()) {
            vector.add("-U");
        }
        if (this.getDebug()) {
            vector.add("-V");
        }
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String debugTipText() {
        return "If set to true, clusterer may output additional info to the console.";
    }

    public void setDebug(boolean bl) {
        this.m_verbose = bl;
    }

    public boolean getDebug() {
        return this.m_verbose;
    }

    public String maxIterationsTipText() {
        return "set maximum number of iterations (default 100)";
    }

    public void setMaxIterations(int n) {
        this.m_maxLoop = n;
    }

    public int getMaxIterations() {
        return this.m_maxLoop;
    }

    public String minChangeTipText() {
        return "set minimum number of changes (default 0)";
    }

    public void setMinChange(int n) {
        this.m_minChange = n;
    }

    public int getMinChange() {
        return this.m_minChange;
    }

    public String numClustersTipText() {
        return "set number of clusters (default 2)";
    }

    public void setNumClusters(int n) {
        this.m_numCluster = n;
    }

    public int getNumClusters() {
        return this.m_numCluster;
    }

    public int numberOfClusters() {
        return this.m_numCluster;
    }

    public String numRestartsTipText() {
        return "set number of restarts (default 5)";
    }

    public void setNumRestarts(int n) {
        this.m_numRestarts = n;
    }

    public int getNumRestarts() {
        return this.m_numRestarts;
    }

    public String notUnifyNormTipText() {
        return "set whether to normalize each instance to a unify prior probability (eg. 1).";
    }

    public void setNotUnifyNorm(boolean bl) {
        this.m_uniformPrior = !bl;
    }

    public boolean getNotUnifyNorm() {
        return !this.m_uniformPrior;
    }

    public String globalInfo() {
        return "Cluster data using the sequential information bottleneck algorithm.\n\nNote: only hard clustering scheme is supported. sIB assign for each instance the cluster that have the minimum cost/distance to the instance. The trade-off beta is set to infinite so 1/beta is zero.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Noam Slonim and Nir Friedman and Naftali Tishby");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "2002");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Unsupervised document classification using sequential information maximization");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "Proceedings of the 25th International ACM SIGIR Conference on Research and Development in Information Retrieval");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "129-136");
        return technicalInformation;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NO_CLASS);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        return capabilities;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nsIB\n===\n");
        stringBuffer.append("\nNumber of clusters: " + this.m_numCluster + "\n");
        for (int i = 0; i < this.m_numCluster; ++i) {
            stringBuffer.append("\nCluster: " + i + " Size : " + this.bestT.size(i) + " Prior probability: " + Utils.doubleToString(this.bestT.Pt[i], 4) + "\n\n");
            for (int j = 0; j < this.m_numAttributes; ++j) {
                stringBuffer.append("Attribute: " + this.m_data.attribute(j).name() + "\n");
                stringBuffer.append("Probability given the cluster = " + Utils.doubleToString(this.bestT.Py_t.get(j, i), 4) + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5538 $");
    }

    public static void main(String[] stringArray) {
        sIB.runClusterer(new sIB(), stringArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Partition
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = 4957194978951259946L;
        private int[] Pt_x;
        private double[] Pt;
        private double L;
        private int counter;
        private Matrix Py_t;

        public Partition() {
            this.Pt_x = new int[sIB.this.m_numInstances];
            for (int i = 0; i < sIB.this.m_numInstances; ++i) {
                this.Pt_x[i] = -1;
            }
            this.Pt = new double[sIB.this.m_numCluster];
            this.Py_t = new Matrix(sIB.this.m_numAttributes, sIB.this.m_numCluster);
            this.counter = 0;
        }

        private ArrayList<Integer> find(int n) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i = 0; i < this.Pt_x.length; ++i) {
                if (this.Pt_x[i] != n) continue;
                arrayList.add(i);
            }
            return arrayList;
        }

        private int size(int n) {
            int n2 = 0;
            for (int i = 0; i < this.Pt_x.length; ++i) {
                if (this.Pt_x[i] != n) continue;
                ++n2;
            }
            return n2;
        }

        private void copy(Partition partition) {
            if (partition == null) {
                partition = new Partition();
            }
            System.arraycopy(this.Pt_x, 0, partition.Pt_x, 0, this.Pt_x.length);
            System.arraycopy(this.Pt, 0, partition.Pt, 0, this.Pt.length);
            partition.L = this.L;
            partition.counter = this.counter;
            double[][] dArray = this.Py_t.getArray();
            double[][] dArray2 = partition.Py_t.getArray();
            for (int i = 0; i < dArray.length; ++i) {
                System.arraycopy(dArray[i], 0, dArray2[i], 0, dArray[0].length);
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("score (L) : " + Utils.doubleToString(this.L, 4) + "\n");
            stringBuffer.append("number of changes : " + this.counter + "\n");
            for (int i = 0; i < sIB.this.m_numCluster; ++i) {
                stringBuffer.append("\nCluster " + i + "\n");
                stringBuffer.append("size : " + this.size(i) + "\n");
                stringBuffer.append("prior prob : " + Utils.doubleToString(this.Pt[i], 4) + "\n");
            }
            return stringBuffer.toString();
        }

        @Override
        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5538 $");
        }
    }

    private class Input
    implements Serializable,
    RevisionHandler {
        static final long serialVersionUID = -2464453171263384037L;
        private double[] Px;
        private double[] Py;
        private Matrix Pyx;
        private Matrix Py_x;
        private double Ixy;
        private double Hy;
        private double Hx;
        private double sumVals;

        private Input() {
        }

        public String getRevision() {
            return RevisionUtils.extract("$Revision: 5538 $");
        }

        static /* synthetic */ double[] access$1002(Input input, double[] dArray) {
            input.Px = dArray;
            return dArray;
        }

        static /* synthetic */ double[] access$1102(Input input, double[] dArray) {
            input.Py = dArray;
            return dArray;
        }
    }
}

