/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers.forOPTICSAndDBScan.Utils;

import java.util.ArrayList;
import weka.clusterers.forOPTICSAndDBScan.Utils.PriorityQueueElement;
import weka.core.RevisionHandler;
import weka.core.RevisionUtils;

public class PriorityQueue
implements RevisionHandler {
    private ArrayList queue = new ArrayList();

    public void add(double d, Object object) {
        this.queue.add(new PriorityQueueElement(d, object));
        this.heapValueUpwards();
    }

    public double getPriority(int n) {
        return ((PriorityQueueElement)this.queue.get(n)).getPriority();
    }

    private void heapValueUpwards() {
        int n = this.size();
        int n2 = n / 2;
        PriorityQueueElement priorityQueueElement = (PriorityQueueElement)this.queue.get(n - 1);
        while (n2 > 0 && this.getPriority(n2 - 1) < priorityQueueElement.getPriority()) {
            this.queue.set(n - 1, this.queue.get(n2 - 1));
            n = n2;
            n2 = n / 2;
        }
        this.queue.set(n - 1, priorityQueueElement);
    }

    private void heapValueDownwards() {
        int n = 1;
        int n2 = 2 * n;
        PriorityQueueElement priorityQueueElement = (PriorityQueueElement)this.queue.get(n - 1);
        if (n2 < this.size() && this.getPriority(n2) > this.getPriority(n2 - 1)) {
            ++n2;
        }
        while (n2 <= this.size() && this.getPriority(n2 - 1) > priorityQueueElement.getPriority()) {
            this.queue.set(n - 1, this.queue.get(n2 - 1));
            n = n2;
            if ((n2 = 2 * n) >= this.size() || !(this.getPriority(n2) > this.getPriority(n2 - 1))) continue;
            ++n2;
        }
        this.queue.set(n - 1, priorityQueueElement);
    }

    public int size() {
        return this.queue.size();
    }

    public boolean hasNext() {
        return this.size() != 0;
    }

    public PriorityQueueElement next() {
        PriorityQueueElement priorityQueueElement = (PriorityQueueElement)this.queue.get(0);
        this.queue.set(0, this.queue.get(this.size() - 1));
        this.queue.remove(this.size() - 1);
        if (this.hasNext()) {
            this.heapValueDownwards();
        }
        return priorityQueueElement;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.3 $");
    }
}

