/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.functions.supportVector.CachedKernel;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;

public class RBFKernel
extends CachedKernel {
    static final long serialVersionUID = 5247117544316387852L;
    protected double[] m_kernelPrecalc;
    protected double m_gamma = 0.01;

    public RBFKernel() {
    }

    public RBFKernel(Instances instances, int n, double d) throws Exception {
        this.setCacheSize(n);
        this.setGamma(d);
        this.buildKernel(instances);
    }

    public String globalInfo() {
        return "The RBF kernel. K(x, y) = e^-(gamma * <x-y, x-y>^2)";
    }

    public Enumeration listOptions() {
        Vector vector = new Vector();
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        vector.addElement(new Option("\tThe Gamma parameter.\n\t(default: 0.01)", "G", 1, "-G <num>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('G', stringArray);
        if (string.length() != 0) {
            this.setGamma(Double.parseDouble(string));
        } else {
            this.setGamma(0.01);
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        vector.add("-G");
        vector.add("" + this.getGamma());
        return vector.toArray(new String[vector.size()]);
    }

    protected double evaluate(int n, int n2, Instance instance) throws Exception {
        if (n == n2) {
            return 1.0;
        }
        double d = n == -1 ? this.dotProd(instance, instance) : this.m_kernelPrecalc[n];
        Instance instance2 = this.m_data.instance(n2);
        double d2 = Math.exp(this.m_gamma * (2.0 * this.dotProd(instance, instance2) - d - this.m_kernelPrecalc[n2]));
        return d2;
    }

    public void setGamma(double d) {
        this.m_gamma = d;
    }

    public double getGamma() {
        return this.m_gamma;
    }

    public String gammaTipText() {
        return "The Gamma value.";
    }

    protected void initVars(Instances instances) {
        super.initVars(instances);
        this.m_kernelPrecalc = new double[instances.numInstances()];
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.disableAll();
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enableAllClasses();
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return capabilities;
    }

    public void buildKernel(Instances instances) throws Exception {
        if (!this.getChecksTurnedOff()) {
            this.getCapabilities().testWithFail(instances);
        }
        this.initVars(instances);
        for (int i = 0; i < instances.numInstances(); ++i) {
            this.m_kernelPrecalc[i] = this.dotProd(instances.instance(i), instances.instance(i));
        }
    }

    public String toString() {
        return "RBF kernel: K(x,y) = e^-(" + this.getGamma() + "* <x-y,x-y>^2)";
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 5518 $");
    }
}

