/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import weka.gui.Logger;

public class LogPanel
extends JPanel
implements Logger {
    private HashMap<String, Integer> m_tableIndexes = new HashMap();
    private HashMap<String, Timer> m_timers = new HashMap();
    private final DefaultTableModel m_tableModel;
    private JTable m_table;
    private JTabbedPane m_tabs = new JTabbedPane();
    private weka.gui.LogPanel m_logPanel = new weka.gui.LogPanel(null, false, true, false);

    public LogPanel() {
        Object[] objectArray = new String[]{"Component", "Parameters", "Time", "Status"};
        this.m_tableModel = new DefaultTableModel(objectArray, 0);
        this.m_table = new JTable(){

            public Class getColumnClass(int n) {
                return this.getValueAt(0, n).getClass();
            }

            public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
                Component component = super.prepareRenderer(tableCellRenderer, n, n2);
                if (!component.getBackground().equals(this.getSelectionBackground())) {
                    String string = (String)this.getModel().getValueAt(n, 3);
                    Color color = null;
                    if (string.startsWith("ERROR")) {
                        color = Color.RED;
                    } else if (string.startsWith("WARNING")) {
                        color = Color.YELLOW;
                    } else if (string.startsWith("INTERRUPTED")) {
                        color = Color.MAGENTA;
                    }
                    component.setBackground(color);
                }
                return component;
            }
        };
        this.m_table.setModel(this.m_tableModel);
        this.m_table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.m_table.getColumnModel().getColumn(1).setPreferredWidth(150);
        this.m_table.getColumnModel().getColumn(2).setPreferredWidth(2);
        this.m_table.getColumnModel().getColumn(3).setPreferredWidth(500);
        this.m_table.setShowVerticalLines(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JScrollPane(this.m_table), "Center");
        this.m_tabs.addTab("Status", jPanel);
        this.m_tabs.addTab("Log", this.m_logPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_tabs, "Center");
    }

    public void clearStatus() {
        Iterator<Timer> iterator = this.m_timers.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().stop();
        }
        this.m_timers.clear();
        this.m_tableIndexes.clear();
        while (this.m_tableModel.getRowCount() > 0) {
            this.m_tableModel.removeRow(0);
        }
    }

    public JTable getStatusTable() {
        return this.m_table;
    }

    public synchronized void logMessage(String string) {
        this.m_logPanel.logMessage(string);
    }

    public synchronized void statusMessage(String string) {
        boolean bl = string.indexOf(124) > 0;
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        if (!bl) {
            string2 = "Unknown";
            string3 = "Unknown";
            string5 = string;
        } else {
            string3 = string.substring(0, string.indexOf(124));
            string = string.substring(string.indexOf(124) + 1, string.length());
            string2 = string3.indexOf(36) > 0 ? string3.substring(0, string3.indexOf(36)) : string3;
            if (string.indexOf(124) > 0) {
                string4 = string.substring(0, string.indexOf(124));
                string5 = string.substring(string.indexOf(124) + 1, string.length());
            } else {
                string5 = string;
            }
        }
        if (this.m_tableIndexes.containsKey(string3)) {
            final Integer n = this.m_tableIndexes.get(string3);
            if (string5.equalsIgnoreCase("remove") || string5.equalsIgnoreCase("remove.")) {
                this.m_tableIndexes.remove(string3);
                this.m_timers.get(string3).stop();
                this.m_timers.remove(string3);
                for (String string6 : this.m_tableIndexes.keySet()) {
                    int n2 = this.m_tableIndexes.get(string6);
                    if (n2 <= n) continue;
                    this.m_tableIndexes.put(string6, --n2);
                }
                if (!SwingUtilities.isEventDispatchThread()) {
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                LogPanel.this.m_tableModel.removeRow(n);
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else {
                    this.m_tableModel.removeRow(n);
                }
            } else {
                final String string7 = string2;
                final String string8 = string5;
                final String string9 = string4;
                if (!SwingUtilities.isEventDispatchThread()) {
                    try {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                if (!string8.startsWith("INTERRUPTED") || !((String)LogPanel.this.m_tableModel.getValueAt(n, 3)).startsWith("ERROR")) {
                                    LogPanel.this.m_tableModel.setValueAt(string7, n, 0);
                                    LogPanel.this.m_tableModel.setValueAt(string9, n, 1);
                                    LogPanel.this.m_tableModel.setValueAt(LogPanel.this.m_table.getValueAt(n, 2), n, 2);
                                    LogPanel.this.m_tableModel.setValueAt(string8, n, 3);
                                }
                            }
                        });
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (!string8.startsWith("INTERRUPTED") || !((String)this.m_tableModel.getValueAt(n, 3)).startsWith("ERROR")) {
                    this.m_tableModel.setValueAt(string7, n, 0);
                    this.m_tableModel.setValueAt(string9, n, 1);
                    this.m_tableModel.setValueAt(this.m_table.getValueAt(n, 2), n, 2);
                    this.m_tableModel.setValueAt(string8, n, 3);
                }
                if (string5.startsWith("ERROR") || string5.startsWith("INTERRUPTED") || string5.equalsIgnoreCase("finished") || string5.equalsIgnoreCase("finished.") || string5.equalsIgnoreCase("done") || string5.equalsIgnoreCase("done.")) {
                    this.m_timers.get(string3).stop();
                } else if (!this.m_timers.get(string3).isRunning()) {
                    this.installTimer(string3);
                }
            }
        } else if (!string5.equalsIgnoreCase("Remove") && !string5.equalsIgnoreCase("Remove.")) {
            int n = this.m_tableIndexes.keySet().size();
            this.m_tableIndexes.put(string3, n);
            final Object[] objectArray = new Object[]{string2, string4, "-", string5};
            String string10 = string3;
            try {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            LogPanel.this.m_tableModel.addRow(objectArray);
                        }
                    });
                } else {
                    this.m_tableModel.addRow(objectArray);
                }
                this.installTimer(string10);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    private void installTimer(final String string) {
        final long l = System.currentTimeMillis();
        Timer timer = new Timer(1000, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent actionEvent) {
                LogPanel logPanel = LogPanel.this;
                synchronized (logPanel) {
                    if (LogPanel.this.m_tableIndexes.containsKey(string)) {
                        final Integer n = (Integer)LogPanel.this.m_tableIndexes.get(string);
                        long l7 = System.currentTimeMillis() - l;
                        long l2 = l7 / 1000L;
                        long l3 = l2 / 60L;
                        final long l4 = l3 / 60L;
                        l2 -= l3 * 60L;
                        final long l5 = l2;
                        final long l6 = l3 -= l4 * 60L;
                        if (!SwingUtilities.isEventDispatchThread()) {
                            try {
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        LogPanel.this.m_tableModel.setValueAt("" + l4 + ":" + l6 + ":" + l5, n, 2);
                                    }
                                });
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        } else {
                            LogPanel.this.m_tableModel.setValueAt("" + l4 + ":" + l6 + ":" + l5, n, 2);
                        }
                    }
                }
            }
        });
        this.m_timers.put(string, timer);
        timer.start();
    }

    public static void main(String[] stringArray) {
        try {
            final JFrame jFrame = new JFrame("Status/Log Panel");
            jFrame.getContentPane().setLayout(new BorderLayout());
            LogPanel logPanel = new LogPanel();
            jFrame.getContentPane().add((Component)logPanel, "Center");
            jFrame.getContentPane().add((Component)logPanel, "Center");
            jFrame.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    jFrame.dispose();
                    System.exit(0);
                }
            });
            jFrame.pack();
            jFrame.setVisible(true);
            logPanel.statusMessage("Step 1|Some options here|A status message");
            logPanel.statusMessage("Step 2$hashkey|Status message: no options");
            Thread.sleep(3000L);
            logPanel.statusMessage("Step 2$hashkey|Funky Chickens!!!");
            Thread.sleep(3000L);
            logPanel.statusMessage("Step 1|Some options here|finished");
            Thread.sleep(3000L);
            logPanel.statusMessage("Step 2$hashkey|ERROR! More Funky Chickens!!!");
            Thread.sleep(3000L);
            logPanel.statusMessage("Step 2$hashkey|WARNING - now a warning...");
            Thread.sleep(3000L);
            logPanel.statusMessage("Step 2$hashkey|Back to normal.");
            Thread.sleep(3000L);
            logPanel.statusMessage("Step 2$hashkey|INTERRUPTED.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

