/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.bayes.net.search.ci;

import weka.classifiers.bayes.BayesNet;
import weka.classifiers.bayes.net.ParentSet;
import weka.classifiers.bayes.net.search.local.LocalScoreSearchAlgorithm;
import weka.core.Instances;
import weka.core.RevisionUtils;

public class CISearchAlgorithm
extends LocalScoreSearchAlgorithm {
    static final long serialVersionUID = 3165802334119704560L;
    BayesNet m_BayesNet;
    Instances m_instances;

    public String globalInfo() {
        return "The CISearchAlgorithm class supports Bayes net structure search algorithms that are based on conditional independence test (as opposed to for example score based of cross validation based search algorithms).";
    }

    protected boolean isConditionalIndependent(int n, int n2, int[] nArray, int n3) {
        ParentSet parentSet = this.m_BayesNet.getParentSet(n);
        while (parentSet.getNrOfParents() > 0) {
            parentSet.deleteLastParent(this.m_instances);
        }
        for (int i = 0; i < n3; ++i) {
            parentSet.addParent(nArray[i], this.m_instances);
        }
        double d = this.calcNodeScore(n);
        double d2 = this.calcScoreWithExtraParent(n, n2);
        return d2 <= d;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.7 $");
    }
}

