/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.boundaryvisualizer;

import java.io.Serializable;
import java.util.Random;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.boundaryvisualizer.DataGenerator;

public class KDDataGenerator
implements DataGenerator,
Serializable {
    private static final long serialVersionUID = -958573275606402792L;
    private Instances m_instances;
    private double[] m_standardDeviations;
    private double[] m_globalMeansOrModes;
    private double m_minStdDev = 1.0E-5;
    private double m_laplaceConst = 1.0;
    private int m_seed = 1;
    private Random m_random;
    private boolean[] m_weightingDimensions;
    private double[] m_weightingValues;
    private static double m_normConst = Math.sqrt(Math.PI * 2);
    private int m_kernelBandwidth = 3;
    private double[][] m_kernelParams;
    protected double[] m_Min;
    protected double[] m_Max;

    public void buildGenerator(Instances instances) throws Exception {
        this.m_random = new Random(this.m_seed);
        this.m_instances = instances;
        this.m_standardDeviations = new double[this.m_instances.numAttributes()];
        this.m_globalMeansOrModes = new double[this.m_instances.numAttributes()];
        if (this.m_weightingDimensions == null) {
            this.m_weightingDimensions = new boolean[this.m_instances.numAttributes()];
        }
        for (int i = 0; i < this.m_instances.numAttributes(); ++i) {
            if (i == this.m_instances.classIndex()) continue;
            this.m_globalMeansOrModes[i] = this.m_instances.meanOrMode(i);
        }
        this.m_kernelParams = new double[this.m_instances.numInstances()][this.m_instances.numAttributes()];
        this.computeParams();
    }

    public double[] getWeights() {
        double[] dArray = new double[this.m_instances.numInstances()];
        for (int i = 0; i < this.m_instances.numInstances(); ++i) {
            double d = 1.0;
            for (int j = 0; j < this.m_instances.numAttributes(); ++j) {
                if (!this.m_weightingDimensions[j]) continue;
                double d2 = 0.0;
                d2 = !this.m_instances.instance(i).isMissing(j) ? this.m_instances.instance(i).value(j) : this.m_globalMeansOrModes[j];
                double d3 = 1.0;
                d3 = this.normalDens(this.m_weightingValues[j], d2, this.m_kernelParams[i][j]);
                d *= d3;
            }
            dArray[i] = d;
        }
        return dArray;
    }

    private double[] computeCumulativeDistribution(double[] dArray) {
        double[] dArray2 = new double[dArray.length];
        double d = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            dArray2[i] = d += dArray[i];
        }
        return dArray2;
    }

    public double[][] generateInstances(int[] nArray) throws Exception {
        double[][] dArrayArray = new double[this.m_instances.numInstances()][];
        for (int i = 0; i < nArray.length; ++i) {
            dArrayArray[nArray[i]] = new double[this.m_instances.numAttributes()];
            for (int j = 0; j < this.m_instances.numAttributes(); ++j) {
                double d;
                if (this.m_weightingDimensions[j] || j == this.m_instances.classIndex()) continue;
                if (this.m_instances.attribute(j).isNumeric()) {
                    double d2 = 0.0;
                    d = this.m_random.nextGaussian();
                    d2 = !this.m_instances.instance(nArray[i]).isMissing(j) ? this.m_instances.instance(nArray[i]).value(j) : this.m_globalMeansOrModes[j];
                    d *= this.m_kernelParams[nArray[i]][j];
                    dArrayArray[nArray[i]][j] = d += d2;
                    continue;
                }
                double[] dArray = new double[this.m_instances.attribute(j).numValues()];
                for (int k = 0; k < dArray.length; ++k) {
                    dArray[k] = this.m_laplaceConst;
                }
                if (!this.m_instances.instance(nArray[i]).isMissing(j)) {
                    int n = (int)this.m_instances.instance(nArray[i]).value(j);
                    dArray[n] = dArray[n] + 1.0;
                } else {
                    int n = (int)this.m_globalMeansOrModes[j];
                    dArray[n] = dArray[n] + 1.0;
                }
                Utils.normalize(dArray);
                double[] dArray2 = this.computeCumulativeDistribution(dArray);
                d = this.m_random.nextDouble();
                int n = 0;
                for (int k = 0; k < dArray2.length; ++k) {
                    if (!(d <= dArray2[k])) continue;
                    n = k;
                    break;
                }
                dArrayArray[nArray[i]][j] = n;
            }
        }
        return dArrayArray;
    }

    private double normalDens(double d, double d2, double d3) {
        double d4 = d - d2;
        return 1.0 / (m_normConst * d3) * Math.exp(-(d4 * d4 / (2.0 * d3 * d3)));
    }

    public void setWeightingDimensions(boolean[] blArray) {
        this.m_weightingDimensions = blArray;
    }

    public void setWeightingValues(double[] dArray) {
        this.m_weightingValues = dArray;
    }

    public int getNumGeneratingModels() {
        if (this.m_instances != null) {
            return this.m_instances.numInstances();
        }
        return 0;
    }

    public void setKernelBandwidth(int n) {
        this.m_kernelBandwidth = n;
    }

    public int getKernelBandwidth() {
        return this.m_kernelBandwidth;
    }

    public void setSeed(int n) {
        this.m_seed = n;
        this.m_random = new Random(this.m_seed);
    }

    private double distance(Instance instance, Instance instance2) {
        double d = 0.0;
        for (int i = 0; i < this.m_instances.numAttributes(); ++i) {
            double d2;
            if (i == this.m_instances.classIndex()) continue;
            double d3 = this.m_globalMeansOrModes[i];
            double d4 = this.m_globalMeansOrModes[i];
            switch (this.m_instances.attribute(i).type()) {
                case 0: {
                    if (!instance.isMissing(i)) {
                        d3 = instance.value(i);
                    }
                    if (!instance2.isMissing(i)) {
                        d4 = instance2.value(i);
                    }
                    d2 = this.norm(d3, i) - this.norm(d4, i);
                    break;
                }
                default: {
                    d2 = 0.0;
                }
            }
            d += d2 * d2;
        }
        return Math.sqrt(d);
    }

    private double norm(double d, int n) {
        if (Double.isNaN(this.m_Min[n]) || Utils.eq(this.m_Max[n], this.m_Min[n])) {
            return 0.0;
        }
        return (d - this.m_Min[n]) / (this.m_Max[n] - this.m_Min[n]);
    }

    private void updateMinMax(Instance instance) {
        for (int i = 0; i < this.m_instances.numAttributes(); ++i) {
            if (instance.isMissing(i)) continue;
            if (Double.isNaN(this.m_Min[i])) {
                this.m_Min[i] = instance.value(i);
                this.m_Max[i] = instance.value(i);
                continue;
            }
            if (instance.value(i) < this.m_Min[i]) {
                this.m_Min[i] = instance.value(i);
                continue;
            }
            if (!(instance.value(i) > this.m_Max[i])) continue;
            this.m_Max[i] = instance.value(i);
        }
    }

    private void computeParams() throws Exception {
        int n;
        this.m_Min = new double[this.m_instances.numAttributes()];
        this.m_Max = new double[this.m_instances.numAttributes()];
        for (n = 0; n < this.m_instances.numAttributes(); ++n) {
            this.m_Max[n] = Double.NaN;
            this.m_Min[n] = Double.NaN;
        }
        for (n = 0; n < this.m_instances.numInstances(); ++n) {
            this.updateMinMax(this.m_instances.instance(n));
        }
        double[] dArray = new double[this.m_instances.numInstances()];
        for (int i = 0; i < this.m_instances.numInstances(); ++i) {
            int n2;
            int n3;
            Instance instance = this.m_instances.instance(i);
            for (int j = 0; j < this.m_instances.numInstances(); ++j) {
                dArray[j] = this.distance(instance, this.m_instances.instance(j));
            }
            int[] nArray = Utils.sort(dArray);
            double d = dArray[nArray[n3 = this.m_kernelBandwidth]];
            if (d <= 0.0) {
                for (n2 = n3 + 1; n2 < nArray.length; ++n2) {
                    if (!(dArray[nArray[n2]] > d)) continue;
                    d = dArray[nArray[n2]];
                    break;
                }
                if (d <= 0.0) {
                    throw new Exception("All training instances coincide with test instance!");
                }
            }
            for (n2 = 0; n2 < this.m_instances.numAttributes(); ++n2) {
                if (!(this.m_Max[n2] - this.m_Min[n2] > 0.0)) continue;
                this.m_kernelParams[i][n2] = d * (this.m_Max[n2] - this.m_Min[n2]);
            }
        }
    }
}

