/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.beans;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.Beans;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JComponent;
import weka.gui.beans.MetaBean;
import weka.gui.beans.Visible;

public class BeanInstance
implements Serializable {
    private static final long serialVersionUID = -7575653109025406342L;
    private static Vector COMPONENTS = new Vector();
    public static final int IDLE = 0;
    public static final int BEAN_EXECUTING = 1;
    private Object m_bean;
    private int m_x;
    private int m_y;

    public static void reset(JComponent jComponent) {
        BeanInstance.removeAllBeansFromContainer(jComponent);
        COMPONENTS = new Vector();
    }

    public static void removeAllBeansFromContainer(JComponent jComponent) {
        if (jComponent != null) {
            if (COMPONENTS != null) {
                for (int i = 0; i < COMPONENTS.size(); ++i) {
                    BeanInstance beanInstance = (BeanInstance)COMPONENTS.elementAt(i);
                    Object object = beanInstance.getBean();
                    if (!Beans.isInstanceOf(object, JComponent.class)) continue;
                    jComponent.remove((JComponent)object);
                }
            }
            jComponent.revalidate();
        }
    }

    public static void addAllBeansToContainer(JComponent jComponent) {
        if (jComponent != null) {
            if (COMPONENTS != null) {
                for (int i = 0; i < COMPONENTS.size(); ++i) {
                    BeanInstance beanInstance = (BeanInstance)COMPONENTS.elementAt(i);
                    Object object = beanInstance.getBean();
                    if (!Beans.isInstanceOf(object, JComponent.class)) continue;
                    jComponent.add((JComponent)object);
                }
            }
            jComponent.revalidate();
        }
    }

    public static Vector getBeanInstances() {
        return COMPONENTS;
    }

    public static void setBeanInstances(Vector vector, JComponent jComponent) {
        BeanInstance.reset(jComponent);
        if (jComponent != null) {
            for (int i = 0; i < vector.size(); ++i) {
                Object object = ((BeanInstance)vector.elementAt(i)).getBean();
                if (!Beans.isInstanceOf(object, JComponent.class)) continue;
                jComponent.add((JComponent)object);
            }
            jComponent.revalidate();
            jComponent.repaint();
        }
        COMPONENTS = vector;
    }

    public static void paintLabels(Graphics graphics) {
        graphics.setFont(new Font("Monospaced", 0, 10));
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getAscent();
        for (int i = 0; i < COMPONENTS.size(); ++i) {
            BeanInstance beanInstance = (BeanInstance)COMPONENTS.elementAt(i);
            if (!(beanInstance.getBean() instanceof Visible)) continue;
            int n2 = beanInstance.getX();
            int n3 = beanInstance.getY();
            int n4 = ((JComponent)beanInstance.getBean()).getWidth();
            int n5 = ((JComponent)beanInstance.getBean()).getHeight();
            String string = ((Visible)beanInstance.getBean()).getVisual().getText();
            int n6 = fontMetrics.stringWidth(string);
            if (n6 < n4) {
                graphics.drawString(string, n2 + n4 / 2 - n6 / 2, n3 + n5 + n + 2);
                continue;
            }
            int n7 = string.length() / 2;
            int n8 = string.length();
            int n9 = -1;
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) >= 'a' || Math.abs(n7 - j) >= n8) continue;
                n8 = Math.abs(n7 - j);
                n9 = j;
            }
            if (n9 != -1) {
                String string2 = string.substring(0, n9);
                String string3 = string.substring(n9, string.length());
                if (string2.length() > 1 && string3.length() > 1) {
                    graphics.drawString(string2, n2 + n4 / 2 - fontMetrics.stringWidth(string2) / 2, n3 + n5 + n * 1 + 2);
                    graphics.drawString(string3, n2 + n4 / 2 - fontMetrics.stringWidth(string3) / 2, n3 + n5 + n * 2 + 2);
                    continue;
                }
                graphics.drawString(string, n2 + n4 / 2 - fontMetrics.stringWidth(string) / 2, n3 + n5 + n * 1 + 2);
                continue;
            }
            graphics.drawString(string, n2 + n4 / 2 - fontMetrics.stringWidth(string) / 2, n3 + n5 + n * 1 + 2);
        }
    }

    public static BeanInstance findInstance(Point point) {
        Rectangle rectangle = new Rectangle();
        for (int i = 0; i < COMPONENTS.size(); ++i) {
            BeanInstance beanInstance = (BeanInstance)COMPONENTS.elementAt(i);
            JComponent jComponent = (JComponent)beanInstance.getBean();
            rectangle = jComponent.getBounds(rectangle);
            if (!rectangle.contains(point)) continue;
            return beanInstance;
        }
        return null;
    }

    public static Vector findInstances(Rectangle rectangle) {
        Graphics graphics = null;
        FontMetrics fontMetrics = null;
        int n = (int)rectangle.getX();
        int n2 = (int)rectangle.getY();
        int n3 = (int)rectangle.getMaxX();
        int n4 = (int)rectangle.getMaxY();
        int n5 = Integer.MAX_VALUE;
        int n6 = Integer.MAX_VALUE;
        int n7 = Integer.MIN_VALUE;
        int n8 = Integer.MIN_VALUE;
        Vector<BeanInstance> vector = new Vector<BeanInstance>();
        for (int i = 0; i < COMPONENTS.size(); ++i) {
            int n9;
            int n10;
            BeanInstance beanInstance = (BeanInstance)COMPONENTS.elementAt(i);
            int n11 = beanInstance.getX() + beanInstance.getWidth() / 2;
            if (!rectangle.contains(n11, n10 = beanInstance.getY() + beanInstance.getHeight() / 2)) continue;
            vector.addElement(beanInstance);
            int n12 = 0;
            if (graphics == null) {
                graphics = ((JComponent)beanInstance.getBean()).getGraphics();
                graphics.setFont(new Font("Monospaced", 0, 10));
                fontMetrics = graphics.getFontMetrics();
                n12 = fontMetrics.getAscent();
            }
            String string = "";
            if (beanInstance.getBean() instanceof Visible) {
                string = ((Visible)beanInstance.getBean()).getVisual().getText();
            }
            int n13 = (n9 = fontMetrics.stringWidth(string)) > beanInstance.getWidth() ? 2 : 1;
            int n14 = 0;
            int n15 = 0;
            if (n11 - n9 / 2 - 2 < beanInstance.getX()) {
                n15 = n11 - n9 / 2 - 2;
                n14 = n11 + n9 / 2 + 2;
            } else {
                n15 = beanInstance.getX() - 2;
                n14 = beanInstance.getX() + beanInstance.getWidth() + 2;
            }
            if (n15 < n5) {
                n5 = n15;
            }
            if (n14 > n7) {
                n7 = n14;
            }
            if (beanInstance.getY() - 2 < n6) {
                n6 = beanInstance.getY() - 2;
            }
            if (beanInstance.getY() + beanInstance.getHeight() + 2 <= n8) continue;
            n8 = beanInstance.getY() + beanInstance.getHeight() + 2;
        }
        rectangle.setBounds(n5, n6, n7 - n5, n8 - n6);
        return vector;
    }

    public BeanInstance(JComponent jComponent, Object object, int n, int n2) {
        this.m_bean = object;
        this.m_x = n;
        this.m_y = n2;
        this.addBean(jComponent);
    }

    public BeanInstance(JComponent jComponent, String string, int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
        try {
            this.m_bean = Beans.instantiate(null, string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        this.addBean(jComponent);
    }

    public void removeBean(JComponent jComponent) {
        for (int i = 0; i < COMPONENTS.size(); ++i) {
            if ((BeanInstance)COMPONENTS.elementAt(i) != this) continue;
            System.err.println("Removing bean");
            COMPONENTS.removeElementAt(i);
        }
        if (jComponent != null) {
            jComponent.remove((JComponent)this.m_bean);
            jComponent.revalidate();
            jComponent.repaint();
        }
    }

    public void addBean(JComponent jComponent) {
        if (COMPONENTS.contains(this)) {
            return;
        }
        if (!Beans.isInstanceOf(this.m_bean, JComponent.class)) {
            System.err.println("Component is invisible!");
            return;
        }
        COMPONENTS.addElement(this);
        JComponent jComponent2 = (JComponent)this.m_bean;
        Dimension dimension = jComponent2.getPreferredSize();
        int n = (int)(dimension.getWidth() / 2.0);
        int n2 = (int)(dimension.getHeight() / 2.0);
        this.m_x -= n;
        this.m_y -= n2;
        jComponent2.setLocation(this.m_x, this.m_y);
        jComponent2.validate();
        if (jComponent != null) {
            jComponent.add(jComponent2);
            jComponent.revalidate();
        }
    }

    public Object getBean() {
        return this.m_bean;
    }

    public int getX() {
        return this.m_x;
    }

    public int getY() {
        return this.m_y;
    }

    public int getWidth() {
        return ((JComponent)this.m_bean).getWidth();
    }

    public int getHeight() {
        return ((JComponent)this.m_bean).getHeight();
    }

    public void setXY(int n, int n2) {
        this.setX(n);
        this.setY(n2);
        if (this.getBean() instanceof MetaBean) {
            ((MetaBean)this.getBean()).shiftBeans(this, false);
        }
    }

    public void setX(int n) {
        this.m_x = n;
        ((JComponent)this.m_bean).setLocation(this.m_x, this.m_y);
        ((JComponent)this.m_bean).validate();
    }

    public void setY(int n) {
        this.m_y = n;
        ((JComponent)this.m_bean).setLocation(this.m_x, this.m_y);
        ((JComponent)this.m_bean).validate();
    }
}

