/*
 * Decompiled with CFR 0.152.
 */
package weka.core.parser.JFlex;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Vector;
import weka.core.parser.JFlex.ErrorMessages;
import weka.core.parser.JFlex.GeneratorException;
import weka.core.parser.JFlex.Out;

public class Skeleton {
    private static final int size = 21;
    private static final String NL = System.getProperty("line.separator");
    public static String[] line;
    private int pos;
    private PrintWriter out;

    public Skeleton(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public void emitNext() {
        this.out.print(line[this.pos++]);
    }

    public static void makePrivate() {
        for (int i = 0; i < line.length; ++i) {
            Skeleton.line[i] = Skeleton.replace(" public ", " private ", line[i]);
        }
    }

    public static void readSkelFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("Skeleton file must not be null");
        }
        if (!file.isFile() || !file.canRead()) {
            Out.error(ErrorMessages.CANNOT_READ_SKEL, file.toString());
            throw new GeneratorException();
        }
        Out.println(ErrorMessages.READING_SKEL, file.toString());
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            Skeleton.readSkel(bufferedReader);
        }
        catch (IOException iOException) {
            Out.error(ErrorMessages.SKEL_IO_ERROR);
            throw new GeneratorException();
        }
    }

    public static void readSkel(BufferedReader bufferedReader) throws IOException {
        String string;
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("---")) {
                vector.addElement(stringBuffer.toString());
                stringBuffer.setLength(0);
                continue;
            }
            stringBuffer.append(string);
            stringBuffer.append(NL);
        }
        if (stringBuffer.length() > 0) {
            vector.addElement(stringBuffer.toString());
        }
        if (vector.size() != 21) {
            Out.error(ErrorMessages.WRONG_SKELETON);
            throw new GeneratorException();
        }
        line = new String[21];
        for (int i = 0; i < 21; ++i) {
            Skeleton.line[i] = (String)vector.elementAt(i);
        }
    }

    public static String replace(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string3.length());
        int n = 0;
        int n2 = string3.indexOf(string);
        while (n2 >= n) {
            stringBuffer.append(string3.substring(n, n2));
            stringBuffer.append(string2);
            n = n2 + string.length();
            n2 = string3.indexOf(string, n);
        }
        stringBuffer.append(string3.substring(n, string3.length()));
        return stringBuffer.toString();
    }

    public static void readDefault() {
        ClassLoader classLoader = Skeleton.class.getClassLoader();
        URL uRL = classLoader.getResource("weka/core/parser/JFlex/skeleton.default");
        if (uRL == null) {
            Out.error(ErrorMessages.SKEL_IO_ERROR_DEFAULT);
            throw new GeneratorException();
        }
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream());
            Skeleton.readSkel(new BufferedReader(inputStreamReader));
        }
        catch (IOException iOException) {
            Out.error(ErrorMessages.SKEL_IO_ERROR_DEFAULT);
            throw new GeneratorException();
        }
    }

    static {
        Skeleton.readDefault();
    }
}

