/*
 * Decompiled with CFR 0.152.
 */
package weka.core;

import weka.core.Instances;
import weka.core.NormalizableDistance;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;

public class ManhattanDistance
extends NormalizableDistance
implements TechnicalInformationHandler {
    private static final long serialVersionUID = 6783782554224000243L;

    public ManhattanDistance() {
    }

    public ManhattanDistance(Instances instances) {
        super(instances);
    }

    public String globalInfo() {
        return "Implements the Manhattan distance (or Taxicab geometry). The distance between two points is the sum of the (absolute) differences of their coordinates.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.MISC);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Wikipedia");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Taxicab geometry");
        technicalInformation.setValue(TechnicalInformation.Field.URL, "http://en.wikipedia.org/wiki/Taxicab_geometry");
        return technicalInformation;
    }

    protected double updateDistance(double d, double d2) {
        double d3 = d;
        return d3 += Math.abs(d2);
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.2 $");
    }
}

