/*
 * Decompiled with CFR 0.152.
 */
package weka.clusterers;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.rules.DecisionTableHashKey;
import weka.clusterers.NumberOfClustersRequestable;
import weka.clusterers.RandomizableClusterer;
import weka.core.Attribute;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.RevisionUtils;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class SimpleKMeans
extends RandomizableClusterer
implements NumberOfClustersRequestable,
WeightedInstancesHandler {
    static final long serialVersionUID = -3235809600124455376L;
    private ReplaceMissingValues m_ReplaceMissingFilter;
    private int m_NumClusters = 2;
    private Instances m_ClusterCentroids;
    private Instances m_ClusterStdDevs;
    private int[][][] m_ClusterNominalCounts;
    private int[][] m_ClusterMissingCounts;
    private double[] m_FullMeansOrModes;
    private double[] m_FullStdDevs;
    private int[][] m_FullNominalCounts;
    private int[] m_FullMissingCounts;
    private boolean m_displayStdDevs;
    private boolean m_dontReplaceMissing = false;
    private int[] m_ClusterSizes;
    private double[] m_Min;
    private double[] m_Max;
    private int m_Iterations = 0;
    private double[] m_squaredErrors;

    public SimpleKMeans() {
        this.m_SeedDefault = 10;
        this.setSeed(this.m_SeedDefault);
    }

    public String globalInfo() {
        return "Cluster data using the k means algorithm";
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        return capabilities;
    }

    public void buildClusterer(Instances instances) throws Exception {
        int n;
        Object object;
        int n2;
        int n3;
        this.getCapabilities().testWithFail(instances);
        this.m_Iterations = 0;
        this.m_ReplaceMissingFilter = new ReplaceMissingValues();
        Instances instances2 = new Instances(instances);
        instances2.setClassIndex(-1);
        if (!this.m_dontReplaceMissing) {
            this.m_ReplaceMissingFilter.setInputFormat(instances2);
            instances2 = Filter.useFilter(instances2, this.m_ReplaceMissingFilter);
        }
        this.m_FullMeansOrModes = new double[instances2.numAttributes()];
        this.m_FullMissingCounts = new int[instances2.numAttributes()];
        if (this.m_displayStdDevs) {
            this.m_FullStdDevs = new double[instances2.numAttributes()];
        }
        this.m_FullNominalCounts = new int[instances2.numAttributes()][0];
        for (n3 = 0; n3 < instances2.numAttributes(); ++n3) {
            this.m_FullMissingCounts[n3] = instances2.attributeStats((int)n3).missingCount;
            this.m_FullMeansOrModes[n3] = instances2.meanOrMode(n3);
            if (instances2.attribute(n3).isNumeric()) {
                if (this.m_displayStdDevs) {
                    this.m_FullStdDevs[n3] = Math.sqrt(instances2.variance(n3));
                }
                if (this.m_FullMissingCounts[n3] != instances2.numInstances()) continue;
                this.m_FullMeansOrModes[n3] = Double.NaN;
                continue;
            }
            this.m_FullNominalCounts[n3] = instances2.attributeStats((int)n3).nominalCounts;
            if (this.m_FullMissingCounts[n3] <= this.m_FullNominalCounts[n3][Utils.maxIndex(this.m_FullNominalCounts[n3])]) continue;
            this.m_FullMeansOrModes[n3] = -1.0;
        }
        this.m_Min = new double[instances2.numAttributes()];
        this.m_Max = new double[instances2.numAttributes()];
        for (n3 = 0; n3 < instances2.numAttributes(); ++n3) {
            this.m_Max[n3] = Double.NaN;
            this.m_Min[n3] = Double.NaN;
        }
        this.m_ClusterCentroids = new Instances(instances2, this.m_NumClusters);
        int[] nArray = new int[instances2.numInstances()];
        for (int i = 0; i < instances2.numInstances(); ++i) {
            this.updateMinMax(instances2.instance(i));
        }
        Random random = new Random(this.getSeed());
        HashMap hashMap = new HashMap();
        DecisionTableHashKey decisionTableHashKey = null;
        for (n2 = instances2.numInstances() - 1; n2 >= 0; --n2) {
            int n4 = random.nextInt(n2 + 1);
            decisionTableHashKey = new DecisionTableHashKey(instances2.instance(n4), instances2.numAttributes(), true);
            if (!hashMap.containsKey(decisionTableHashKey)) {
                this.m_ClusterCentroids.add(instances2.instance(n4));
                hashMap.put(decisionTableHashKey, null);
            }
            instances2.swap(n2, n4);
            if (this.m_ClusterCentroids.numInstances() == this.m_NumClusters) break;
        }
        this.m_NumClusters = this.m_ClusterCentroids.numInstances();
        boolean bl = false;
        Instances[] instancesArray = new Instances[this.m_NumClusters];
        this.m_squaredErrors = new double[this.m_NumClusters];
        this.m_ClusterNominalCounts = new int[this.m_NumClusters][instances2.numAttributes()][0];
        this.m_ClusterMissingCounts = new int[this.m_NumClusters][instances2.numAttributes()];
        while (!bl) {
            int n5 = 0;
            ++this.m_Iterations;
            bl = true;
            for (n2 = 0; n2 < instances2.numInstances(); ++n2) {
                object = instances2.instance(n2);
                n = this.clusterProcessedInstance((Instance)object, true);
                if (n != nArray[n2]) {
                    bl = false;
                }
                nArray[n2] = n;
            }
            this.m_ClusterCentroids = new Instances(instances2, this.m_NumClusters);
            for (n2 = 0; n2 < this.m_NumClusters; ++n2) {
                instancesArray[n2] = new Instances(instances2, 0);
            }
            for (n2 = 0; n2 < instances2.numInstances(); ++n2) {
                instancesArray[nArray[n2]].add(instances2.instance(n2));
            }
            for (n2 = 0; n2 < this.m_NumClusters; ++n2) {
                object = new double[instances2.numAttributes()];
                if (instancesArray[n2].numInstances() == 0) {
                    ++n5;
                    continue;
                }
                for (n = 0; n < instances2.numAttributes(); ++n) {
                    object[n] = (Instances)instancesArray[n2].meanOrMode(n);
                    this.m_ClusterMissingCounts[n2][n] = instancesArray[n2].attributeStats((int)n).missingCount;
                    this.m_ClusterNominalCounts[n2][n] = instancesArray[n2].attributeStats((int)n).nominalCounts;
                    if (instancesArray[n2].attribute(n).isNominal()) {
                        if (this.m_ClusterMissingCounts[n2][n] <= this.m_ClusterNominalCounts[n2][n][Utils.maxIndex(this.m_ClusterNominalCounts[n2][n])]) continue;
                        object[n] = (Instances)Instance.missingValue();
                        continue;
                    }
                    if (this.m_ClusterMissingCounts[n2][n] != instancesArray[n2].numInstances()) continue;
                    object[n] = (Instances)Instance.missingValue();
                }
                this.m_ClusterCentroids.add(new Instance(1.0, (double[])object));
            }
            if (n5 > 0) {
                this.m_NumClusters -= n5;
                if (bl) {
                    object = new Instances[this.m_NumClusters];
                    n = 0;
                    for (int i = 0; i < instancesArray.length; ++i) {
                        if (instancesArray[i].numInstances() <= 0) continue;
                        object[n++] = instancesArray[i];
                    }
                    instancesArray = object;
                } else {
                    instancesArray = new Instances[this.m_NumClusters];
                }
            }
            if (bl) continue;
            this.m_squaredErrors = new double[this.m_NumClusters];
            this.m_ClusterNominalCounts = new int[this.m_NumClusters][instances2.numAttributes()][0];
        }
        if (this.m_displayStdDevs) {
            this.m_ClusterStdDevs = new Instances(instances2, this.m_NumClusters);
        }
        this.m_ClusterSizes = new int[this.m_NumClusters];
        for (n2 = 0; n2 < this.m_NumClusters; ++n2) {
            if (this.m_displayStdDevs) {
                object = new double[instances2.numAttributes()];
                for (n = 0; n < instances2.numAttributes(); ++n) {
                    object[n] = instances2.attribute(n).isNumeric() ? (Object)Math.sqrt(instancesArray[n2].variance(n)) : (Object)Instance.missingValue();
                }
                this.m_ClusterStdDevs.add(new Instance(1.0, (double[])object));
            }
            this.m_ClusterSizes[n2] = instancesArray[n2].numInstances();
        }
    }

    private int clusterProcessedInstance(Instance instance, boolean bl) {
        double d = 2.147483647E9;
        int n = 0;
        for (int i = 0; i < this.m_NumClusters; ++i) {
            double d2 = this.distance(instance, this.m_ClusterCentroids.instance(i));
            if (!(d2 < d)) continue;
            d = d2;
            n = i;
        }
        if (bl) {
            int n2 = n;
            this.m_squaredErrors[n2] = this.m_squaredErrors[n2] + d;
        }
        return n;
    }

    public int clusterInstance(Instance instance) throws Exception {
        Instance instance2 = null;
        if (!this.m_dontReplaceMissing) {
            this.m_ReplaceMissingFilter.input(instance);
            this.m_ReplaceMissingFilter.batchFinished();
            instance2 = this.m_ReplaceMissingFilter.output();
        } else {
            instance2 = instance;
        }
        return this.clusterProcessedInstance(instance2, false);
    }

    private double distance(Instance instance, Instance instance2) {
        double d = 0.0;
        int n = 0;
        int n2 = 0;
        while (n < instance.numValues() || n2 < instance2.numValues()) {
            double d2;
            int n3;
            int n4 = n >= instance.numValues() ? this.m_ClusterCentroids.numAttributes() : instance.index(n);
            if (n4 == (n3 = n2 >= instance2.numValues() ? this.m_ClusterCentroids.numAttributes() : instance2.index(n2))) {
                d2 = this.difference(n4, instance.valueSparse(n), instance2.valueSparse(n2));
                ++n;
                ++n2;
            } else if (n4 > n3) {
                d2 = this.difference(n3, 0.0, instance2.valueSparse(n2));
                ++n2;
            } else {
                d2 = this.difference(n4, instance.valueSparse(n), 0.0);
                ++n;
            }
            d += d2 * d2;
        }
        return d;
    }

    private double difference(int n, double d, double d2) {
        switch (this.m_ClusterCentroids.attribute(n).type()) {
            case 1: {
                if (Instance.isMissingValue(d) || Instance.isMissingValue(d2) || (int)d != (int)d2) {
                    return 1.0;
                }
                return 0.0;
            }
            case 0: {
                if (Instance.isMissingValue(d) || Instance.isMissingValue(d2)) {
                    if (Instance.isMissingValue(d) && Instance.isMissingValue(d2)) {
                        return 1.0;
                    }
                    double d3 = Instance.isMissingValue(d2) ? this.norm(d, n) : this.norm(d2, n);
                    if (d3 < 0.5) {
                        d3 = 1.0 - d3;
                    }
                    return d3;
                }
                return this.norm(d, n) - this.norm(d2, n);
            }
        }
        return 0.0;
    }

    private double norm(double d, int n) {
        if (Double.isNaN(this.m_Min[n]) || Utils.eq(this.m_Max[n], this.m_Min[n])) {
            return 0.0;
        }
        return (d - this.m_Min[n]) / (this.m_Max[n] - this.m_Min[n]);
    }

    private void updateMinMax(Instance instance) {
        for (int i = 0; i < this.m_ClusterCentroids.numAttributes(); ++i) {
            if (instance.isMissing(i)) continue;
            if (Double.isNaN(this.m_Min[i])) {
                this.m_Min[i] = instance.value(i);
                this.m_Max[i] = instance.value(i);
                continue;
            }
            if (instance.value(i) < this.m_Min[i]) {
                this.m_Min[i] = instance.value(i);
                continue;
            }
            if (!(instance.value(i) > this.m_Max[i])) continue;
            this.m_Max[i] = instance.value(i);
        }
    }

    public int numberOfClusters() throws Exception {
        return this.m_NumClusters;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tnumber of clusters.\n\t(default 2).", "N", 1, "-N <num>"));
        vector.addElement(new Option("\tDisplay std. deviations for centroids.\n", "V", 0, "-V"));
        vector.addElement(new Option("\tReplace missing values with mean/mode.\n", "M", 0, "-M"));
        Enumeration enumeration = super.listOptions();
        while (enumeration.hasMoreElements()) {
            vector.addElement((Option)enumeration.nextElement());
        }
        return vector.elements();
    }

    public String numClustersTipText() {
        return "set number of clusters";
    }

    public void setNumClusters(int n) throws Exception {
        if (n <= 0) {
            throw new Exception("Number of clusters must be > 0");
        }
        this.m_NumClusters = n;
    }

    public int getNumClusters() {
        return this.m_NumClusters;
    }

    public String displayStdDevsTipText() {
        return "Display std deviations of numeric attributes and counts of nominal attributes.";
    }

    public void setDisplayStdDevs(boolean bl) {
        this.m_displayStdDevs = bl;
    }

    public boolean getDisplayStdDevs() {
        return this.m_displayStdDevs;
    }

    public String dontReplaceMissingValuesTipText() {
        return "Replace missing values globally with mean/mode.";
    }

    public void setDontReplaceMissingValues(boolean bl) {
        this.m_dontReplaceMissing = bl;
    }

    public boolean getDontReplaceMissingValues() {
        return this.m_dontReplaceMissing;
    }

    public void setOptions(String[] stringArray) throws Exception {
        this.m_displayStdDevs = Utils.getFlag("V", stringArray);
        this.m_dontReplaceMissing = Utils.getFlag("M", stringArray);
        String string = Utils.getOption('N', stringArray);
        if (string.length() != 0) {
            this.setNumClusters(Integer.parseInt(string));
        }
        super.setOptions(stringArray);
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (this.m_displayStdDevs) {
            vector.add("-V");
        }
        if (this.m_dontReplaceMissing) {
            vector.add("-M");
        }
        vector.add("-N");
        vector.add("" + this.getNumClusters());
        String[] stringArray = super.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public String toString() {
        int n;
        String string;
        int n2;
        if (this.m_ClusterCentroids == null) {
            return "No clusterer built yet!";
        }
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        for (n2 = 0; n2 < this.m_NumClusters; ++n2) {
            for (int i = 0; i < this.m_ClusterCentroids.numAttributes(); ++i) {
                if (this.m_ClusterCentroids.attribute(i).name().length() > n4) {
                    n4 = this.m_ClusterCentroids.attribute(i).name().length();
                }
                if (!this.m_ClusterCentroids.attribute(i).isNumeric()) continue;
                bl = true;
                double d = Math.log(Math.abs(this.m_ClusterCentroids.instance(n2).value(i))) / Math.log(10.0);
                if (d < 0.0) {
                    d = 1.0;
                }
                if ((int)(d += 6.0) <= n3) continue;
                n3 = (int)d;
            }
        }
        for (n2 = 0; n2 < this.m_ClusterCentroids.numAttributes(); ++n2) {
            int n5;
            if (!this.m_ClusterCentroids.attribute(n2).isNominal()) continue;
            Attribute attribute = this.m_ClusterCentroids.attribute(n2);
            for (n5 = 0; n5 < this.m_ClusterCentroids.numInstances(); ++n5) {
                string = attribute.value((int)this.m_ClusterCentroids.instance(n5).value(n2));
                if (string.length() <= n3) continue;
                n3 = string.length();
            }
            for (n5 = 0; n5 < attribute.numValues(); ++n5) {
                string = attribute.value(n5) + " ";
                if (string.length() <= n4) continue;
                n4 = string.length();
            }
        }
        if (this.m_displayStdDevs) {
            for (n2 = 0; n2 < this.m_ClusterCentroids.numAttributes(); ++n2) {
                if (!this.m_ClusterCentroids.attribute(n2).isNominal()) continue;
                int n6 = Utils.maxIndex(this.m_FullNominalCounts[n2]);
                int n7 = 6;
                string = "" + this.m_FullNominalCounts[n2][n6];
                if (string.length() + n7 <= n3) continue;
                n3 = string.length() + 1;
            }
        }
        for (n2 = 0; n2 < this.m_ClusterSizes.length; ++n2) {
            String string2 = "(" + this.m_ClusterSizes[n2] + ")";
            if (string2.length() <= n3) continue;
            n3 = string2.length();
        }
        if (this.m_displayStdDevs && n4 < "missing".length()) {
            n4 = "missing".length();
        }
        String string3 = "+/-";
        n4 += 2;
        if (this.m_displayStdDevs && bl) {
            n3 += string3.length();
        }
        if (n4 < "Attribute".length() + 2) {
            n4 = "Attribute".length() + 2;
        }
        if (n3 < "Full Data".length()) {
            n3 = "Full Data".length() + 1;
        }
        if (n3 < "missing".length()) {
            n3 = "missing".length() + 1;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nkMeans\n======\n");
        stringBuffer.append("\nNumber of iterations: " + this.m_Iterations + "\n");
        stringBuffer.append("Within cluster sum of squared errors: " + Utils.sum(this.m_squaredErrors));
        if (!this.m_dontReplaceMissing) {
            stringBuffer.append("\nMissing values globally replaced with mean/mode");
        }
        stringBuffer.append("\n\nCluster centroids:\n");
        stringBuffer.append(this.pad("Cluster#", " ", n4 + (n3 * 2 + 2) - "Cluster#".length(), true));
        stringBuffer.append("\n");
        stringBuffer.append(this.pad("Attribute", " ", n4 - "Attribute".length(), false));
        stringBuffer.append(this.pad("Full Data", " ", n3 + 1 - "Full Data".length(), true));
        for (int i = 0; i < this.m_NumClusters; ++i) {
            string = "" + i;
            stringBuffer.append(this.pad(string, " ", n3 + 1 - string.length(), true));
        }
        stringBuffer.append("\n");
        String string4 = "(" + Utils.sum(this.m_ClusterSizes) + ")";
        stringBuffer.append(this.pad(string4, " ", n4 + n3 + 1 - string4.length(), true));
        for (n = 0; n < this.m_NumClusters; ++n) {
            string4 = "(" + this.m_ClusterSizes[n] + ")";
            stringBuffer.append(this.pad(string4, " ", n3 + 1 - string4.length(), true));
        }
        stringBuffer.append("\n");
        stringBuffer.append(this.pad("", "=", n4 + (n3 * (this.m_ClusterCentroids.numInstances() + 1) + this.m_ClusterCentroids.numInstances() + 1), true));
        stringBuffer.append("\n");
        for (n = 0; n < this.m_ClusterCentroids.numAttributes(); ++n) {
            String string5;
            String string6 = this.m_ClusterCentroids.attribute(n).name();
            stringBuffer.append(string6);
            for (int i = 0; i < n4 - string6.length(); ++i) {
                stringBuffer.append(" ");
            }
            if (this.m_ClusterCentroids.attribute(n).isNominal()) {
                if (this.m_FullMeansOrModes[n] == -1.0) {
                    string5 = this.pad("missing", " ", n3 + 1 - "missing".length(), true);
                } else {
                    String string7 = this.m_ClusterCentroids.attribute(n).value((int)this.m_FullMeansOrModes[n]);
                    string5 = this.pad(string7, " ", n3 + 1 - string7.length(), true);
                }
            } else if (Double.isNaN(this.m_FullMeansOrModes[n])) {
                string5 = this.pad("missing", " ", n3 + 1 - "missing".length(), true);
            } else {
                String string8 = Utils.doubleToString(this.m_FullMeansOrModes[n], n3, 4).trim();
                string5 = this.pad(string8, " ", n3 + 1 - string8.length(), true);
            }
            stringBuffer.append(string5);
            for (int i = 0; i < this.m_NumClusters; ++i) {
                if (this.m_ClusterCentroids.attribute(n).isNominal()) {
                    if (this.m_ClusterCentroids.instance(i).isMissing(n)) {
                        string5 = this.pad("missing", " ", n3 + 1 - "missing".length(), true);
                    } else {
                        String string9 = this.m_ClusterCentroids.attribute(n).value((int)this.m_ClusterCentroids.instance(i).value(n));
                        string5 = this.pad(string9, " ", n3 + 1 - string9.length(), true);
                    }
                } else if (this.m_ClusterCentroids.instance(i).isMissing(n)) {
                    string5 = this.pad("missing", " ", n3 + 1 - "missing".length(), true);
                } else {
                    String string10 = Utils.doubleToString(this.m_ClusterCentroids.instance(i).value(n), n3, 4).trim();
                    string5 = this.pad(string10, " ", n3 + 1 - string10.length(), true);
                }
                stringBuffer.append(string5);
            }
            stringBuffer.append("\n");
            if (!this.m_displayStdDevs) continue;
            String string11 = "";
            if (this.m_ClusterCentroids.attribute(n).isNominal()) {
                int n8;
                int n9;
                Attribute attribute = this.m_ClusterCentroids.attribute(n);
                for (n9 = 0; n9 < attribute.numValues(); ++n9) {
                    String string12 = "  " + attribute.value(n9);
                    stringBuffer.append(this.pad(string12, " ", n4 + 1 - string12.length(), false));
                    int n10 = this.m_FullNominalCounts[n][n9];
                    n8 = (int)((double)this.m_FullNominalCounts[n][n9] / (double)Utils.sum(this.m_ClusterSizes) * 100.0);
                    String string13 = "" + n8 + "%)";
                    string13 = this.pad(string13, " ", 5 - string13.length(), true);
                    string11 = "" + n10 + " (" + string13;
                    string11 = this.pad(string11, " ", n3 + 1 - string11.length(), true);
                    stringBuffer.append(string11);
                    for (int i = 0; i < this.m_NumClusters; ++i) {
                        n10 = this.m_ClusterNominalCounts[i][n][n9];
                        n8 = (int)((double)this.m_ClusterNominalCounts[i][n][n9] / (double)this.m_ClusterSizes[i] * 100.0);
                        string13 = "" + n8 + "%)";
                        string13 = this.pad(string13, " ", 5 - string13.length(), true);
                        string11 = "" + n10 + " (" + string13;
                        string11 = this.pad(string11, " ", n3 + 1 - string11.length(), true);
                        stringBuffer.append(string11);
                    }
                    stringBuffer.append("\n");
                }
                if (this.m_FullMissingCounts[n] > 0) {
                    stringBuffer.append(this.pad("  missing", " ", n4 + 1 - "  missing".length(), false));
                    n9 = this.m_FullMissingCounts[n];
                    int n11 = (int)((double)this.m_FullMissingCounts[n] / (double)Utils.sum(this.m_ClusterSizes) * 100.0);
                    String string14 = "" + n11 + "%)";
                    string14 = this.pad(string14, " ", 5 - string14.length(), true);
                    string11 = "" + n9 + " (" + string14;
                    string11 = this.pad(string11, " ", n3 + 1 - string11.length(), true);
                    stringBuffer.append(string11);
                    for (n8 = 0; n8 < this.m_NumClusters; ++n8) {
                        n9 = this.m_ClusterMissingCounts[n8][n];
                        n11 = (int)((double)this.m_ClusterMissingCounts[n8][n] / (double)this.m_ClusterSizes[n8] * 100.0);
                        string14 = "" + n11 + "%)";
                        string14 = this.pad(string14, " ", 5 - string14.length(), true);
                        string11 = "" + n9 + " (" + string14;
                        string11 = this.pad(string11, " ", n3 + 1 - string11.length(), true);
                        stringBuffer.append(string11);
                    }
                    stringBuffer.append("\n");
                }
                stringBuffer.append("\n");
                continue;
            }
            if (Double.isNaN(this.m_FullMeansOrModes[n])) {
                string11 = this.pad("--", " ", n4 + n3 + 1 - 2, true);
            } else {
                String string15 = string3 + Utils.doubleToString(this.m_FullStdDevs[n], n3, 4).trim();
                string11 = this.pad(string15, " ", n3 + n4 + 1 - string15.length(), true);
            }
            stringBuffer.append(string11);
            for (int i = 0; i < this.m_NumClusters; ++i) {
                if (this.m_ClusterCentroids.instance(i).isMissing(n)) {
                    string11 = this.pad("--", " ", n3 + 1 - 2, true);
                } else {
                    String string16 = string3 + Utils.doubleToString(this.m_ClusterStdDevs.instance(i).value(n), n3, 4).trim();
                    string11 = this.pad(string16, " ", n3 + 1 - string16.length(), true);
                }
                stringBuffer.append(string11);
            }
            stringBuffer.append("\n\n");
        }
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }

    private String pad(String string, String string2, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string2);
            }
            stringBuffer.append(string);
        } else {
            stringBuffer.append(string);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(string2);
            }
        }
        return stringBuffer.toString();
    }

    public Instances getClusterCentroids() {
        return this.m_ClusterCentroids;
    }

    public Instances getClusterStandardDevs() {
        return this.m_ClusterStdDevs;
    }

    public int[][][] getClusterNominalCounts() {
        return this.m_ClusterNominalCounts;
    }

    public double getSquaredError() {
        return Utils.sum(this.m_squaredErrors);
    }

    public int[] getClusterSizes() {
        return this.m_ClusterSizes;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.39 $");
    }

    public static void main(String[] stringArray) {
        SimpleKMeans.runClusterer(new SimpleKMeans(), stringArray);
    }
}

