/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Enumeration;
import java.util.Random;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.TechnicalInformation;
import weka.core.TechnicalInformationHandler;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class VotedPerceptron
extends Classifier
implements OptionHandler,
TechnicalInformationHandler {
    static final long serialVersionUID = -1072429260104568698L;
    private int m_MaxK = 10000;
    private int m_NumIterations = 1;
    private double m_Exponent = 1.0;
    private int m_K = 0;
    private int[] m_Additions = null;
    private boolean[] m_IsAddition = null;
    private int[] m_Weights = null;
    private Instances m_Train = null;
    private int m_Seed = 1;
    private NominalToBinary m_NominalToBinary;
    private ReplaceMissingValues m_ReplaceMissingValues;

    public String globalInfo() {
        return "Implementation of the voted perceptron algorithm by Freund and Schapire. Globally replaces all missing values, and transforms nominal attributes into binary ones.\n\nFor more information, see:\n\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        TechnicalInformation technicalInformation = new TechnicalInformation(TechnicalInformation.Type.INPROCEEDINGS);
        technicalInformation.setValue(TechnicalInformation.Field.AUTHOR, "Y. Freund and R. E. Schapire");
        technicalInformation.setValue(TechnicalInformation.Field.TITLE, "Large margin classification using the perceptron algorithm");
        technicalInformation.setValue(TechnicalInformation.Field.BOOKTITLE, "11th Annual Conference on Computational Learning Theory");
        technicalInformation.setValue(TechnicalInformation.Field.YEAR, "1998");
        technicalInformation.setValue(TechnicalInformation.Field.PAGES, "209-217");
        technicalInformation.setValue(TechnicalInformation.Field.PUBLISHER, "ACM Press");
        technicalInformation.setValue(TechnicalInformation.Field.ADDRESS, "New York, NY");
        return technicalInformation;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(4);
        vector.addElement(new Option("\tThe number of iterations to be performed.\n\t(default 1)", "I", 1, "-I <int>"));
        vector.addElement(new Option("\tThe exponent for the polynomial kernel.\n\t(default 1)", "E", 1, "-E <double>"));
        vector.addElement(new Option("\tThe seed for the random number generation.\n\t(default 1)", "S", 1, "-S <int>"));
        vector.addElement(new Option("\tThe maximum number of alterations allowed.\n\t(default 10000)", "M", 1, "-M <int>"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('I', stringArray);
        this.m_NumIterations = string.length() != 0 ? Integer.parseInt(string) : 1;
        String string2 = Utils.getOption('E', stringArray);
        this.m_Exponent = string2.length() != 0 ? new Double(string2) : 1.0;
        String string3 = Utils.getOption('S', stringArray);
        this.m_Seed = string3.length() != 0 ? Integer.parseInt(string3) : 1;
        String string4 = Utils.getOption('M', stringArray);
        this.m_MaxK = string4.length() != 0 ? Integer.parseInt(string4) : 10000;
    }

    public String[] getOptions() {
        String[] stringArray = new String[8];
        int n = 0;
        stringArray[n++] = "-I";
        stringArray[n++] = "" + this.m_NumIterations;
        stringArray[n++] = "-E";
        stringArray[n++] = "" + this.m_Exponent;
        stringArray[n++] = "-S";
        stringArray[n++] = "" + this.m_Seed;
        stringArray[n++] = "-M";
        stringArray[n++] = "" + this.m_MaxK;
        while (n < stringArray.length) {
            stringArray[n++] = "";
        }
        return stringArray;
    }

    public Capabilities getCapabilities() {
        Capabilities capabilities = super.getCapabilities();
        capabilities.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        capabilities.enable(Capabilities.Capability.MISSING_VALUES);
        capabilities.enable(Capabilities.Capability.BINARY_CLASS);
        capabilities.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        capabilities.setMinimumNumberInstances(0);
        return capabilities;
    }

    public void buildClassifier(Instances instances) throws Exception {
        this.getCapabilities().testWithFail(instances);
        instances = new Instances(instances);
        instances.deleteWithMissingClass();
        this.m_Train = new Instances(instances);
        this.m_ReplaceMissingValues = new ReplaceMissingValues();
        this.m_ReplaceMissingValues.setInputFormat(this.m_Train);
        this.m_Train = Filter.useFilter(this.m_Train, this.m_ReplaceMissingValues);
        this.m_NominalToBinary = new NominalToBinary();
        this.m_NominalToBinary.setInputFormat(this.m_Train);
        this.m_Train = Filter.useFilter(this.m_Train, this.m_NominalToBinary);
        this.m_Train.randomize(new Random(this.m_Seed));
        this.m_Additions = new int[this.m_MaxK + 1];
        this.m_IsAddition = new boolean[this.m_MaxK + 1];
        this.m_Weights = new int[this.m_MaxK + 1];
        this.m_K = 0;
        block0: for (int i = 0; i < this.m_NumIterations; ++i) {
            for (int j = 0; j < this.m_Train.numInstances(); ++j) {
                int n;
                Instance instance = this.m_Train.instance(j);
                if (instance.classIsMissing()) continue;
                int n2 = this.makePrediction(this.m_K, instance);
                if (n2 == (n = (int)instance.classValue())) {
                    int n3 = this.m_K;
                    this.m_Weights[n3] = this.m_Weights[n3] + 1;
                } else {
                    this.m_IsAddition[this.m_K] = n == 1;
                    this.m_Additions[this.m_K] = j;
                    int n4 = ++this.m_K;
                    this.m_Weights[n4] = this.m_Weights[n4] + 1;
                }
                if (this.m_K == this.m_MaxK) break block0;
            }
        }
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        this.m_ReplaceMissingValues.input(instance);
        this.m_ReplaceMissingValues.batchFinished();
        instance = this.m_ReplaceMissingValues.output();
        this.m_NominalToBinary.input(instance);
        this.m_NominalToBinary.batchFinished();
        instance = this.m_NominalToBinary.output();
        double d = 0.0;
        double d2 = 0.0;
        if (this.m_K > 0) {
            for (int i = 0; i <= this.m_K; ++i) {
                d = d2 < 0.0 ? (d -= (double)this.m_Weights[i]) : (d += (double)this.m_Weights[i]);
                if (this.m_IsAddition[i]) {
                    d2 += this.innerProduct(this.m_Train.instance(this.m_Additions[i]), instance);
                    continue;
                }
                d2 -= this.innerProduct(this.m_Train.instance(this.m_Additions[i]), instance);
            }
        }
        double[] dArray = new double[2];
        dArray[1] = 1.0 / (1.0 + Math.exp(-d));
        dArray[0] = 1.0 - dArray[1];
        return dArray;
    }

    public String toString() {
        return "VotedPerceptron: Number of perceptrons=" + this.m_K;
    }

    public String maxKTipText() {
        return "The maximum number of alterations to the perceptron.";
    }

    public int getMaxK() {
        return this.m_MaxK;
    }

    public void setMaxK(int n) {
        this.m_MaxK = n;
    }

    public String numIterationsTipText() {
        return "Number of iterations to be performed.";
    }

    public int getNumIterations() {
        return this.m_NumIterations;
    }

    public void setNumIterations(int n) {
        this.m_NumIterations = n;
    }

    public String exponentTipText() {
        return "Exponent for the polynomial kernel.";
    }

    public double getExponent() {
        return this.m_Exponent;
    }

    public void setExponent(double d) {
        this.m_Exponent = d;
    }

    public String seedTipText() {
        return "Seed for the random number generator.";
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setSeed(int n) {
        this.m_Seed = n;
    }

    private double innerProduct(Instance instance, Instance instance2) throws Exception {
        double d = 0.0;
        int n = instance.numValues();
        int n2 = instance2.numValues();
        int n3 = this.m_Train.classIndex();
        int n4 = 0;
        int n5 = 0;
        while (n4 < n && n5 < n2) {
            int n6;
            int n7 = instance.index(n4);
            if (n7 == (n6 = instance2.index(n5))) {
                if (n7 != n3) {
                    d += instance.valueSparse(n4) * instance2.valueSparse(n5);
                }
                ++n4;
                ++n5;
                continue;
            }
            if (n7 > n6) {
                ++n5;
                continue;
            }
            ++n4;
        }
        d += 1.0;
        if (this.m_Exponent != 1.0) {
            return Math.pow(d, this.m_Exponent);
        }
        return d;
    }

    private int makePrediction(int n, Instance instance) throws Exception {
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            if (this.m_IsAddition[i]) {
                d += this.innerProduct(this.m_Train.instance(this.m_Additions[i]), instance);
                continue;
            }
            d -= this.innerProduct(this.m_Train.instance(this.m_Additions[i]), instance);
        }
        if (d < 0.0) {
            return 0;
        }
        return 1;
    }

    public String getRevision() {
        return RevisionUtils.extract("$Revision: 1.23 $");
    }

    public static void main(String[] stringArray) {
        VotedPerceptron.runClassifier(new VotedPerceptron(), stringArray);
    }
}

