/*
 * Decompiled with CFR 0.152.
 */
package weka.datagenerators;

import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Randomizable;
import weka.core.RevisionHandler;
import weka.core.Utils;

public abstract class DataGenerator
implements OptionHandler,
Randomizable,
Serializable,
RevisionHandler {
    private static final long serialVersionUID = -3698585946221802578L;
    protected boolean m_Debug = false;
    protected Instances m_DatasetFormat = null;
    protected String m_RelationName = "";
    protected int m_NumExamplesAct;
    protected transient StringWriter m_DefaultOutput = new StringWriter();
    protected transient PrintWriter m_Output = new PrintWriter(this.m_DefaultOutput);
    protected int m_Seed;
    protected Random m_Random = null;
    protected boolean m_CreatingRelationName = false;
    protected static HashSet m_OptionBlacklist = new HashSet();

    public DataGenerator() {
        DataGenerator.clearBlacklist();
        this.setNumExamplesAct(this.defaultNumExamplesAct());
        this.setSeed(this.defaultSeed());
    }

    protected Vector enumToVector(Enumeration enumeration) {
        Vector vector = new Vector();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        return vector;
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>();
        vector.addElement(new Option("\tPrints this help.", "h", 1, "-h"));
        vector.addElement(new Option("\tThe name of the output file, otherwise the generated data is\n\tprinted to stdout.", "o", 1, "-o <file>"));
        vector.addElement(new Option("\tThe name of the relation.", "r", 1, "-r <name>"));
        vector.addElement(new Option("\tWhether to print debug informations.", "d", 0, "-d"));
        vector.addElement(new Option("\tThe seed for random function (default " + this.defaultSeed() + ")", "S", 1, "-S"));
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('r', stringArray = this.removeBlacklist(stringArray));
        if (string.length() != 0) {
            this.setRelationName(Utils.unquote(string));
        } else {
            this.setRelationName("");
        }
        string = Utils.getOption('o', stringArray);
        if (string.length() != 0) {
            this.setOutput(new PrintWriter(new FileOutputStream(string)));
        } else if (this.getOutput() == null) {
            throw new Exception("No Output defined!");
        }
        this.setDebug(Utils.getFlag('d', stringArray));
        string = Utils.getOption('S', stringArray);
        if (string.length() != 0) {
            this.setSeed(Integer.parseInt(string));
        } else {
            this.setSeed(this.defaultSeed());
        }
    }

    public String[] getOptions() {
        Vector<String> vector = new Vector<String>();
        if (!this.m_CreatingRelationName) {
            vector.add("-r");
            vector.add(Utils.quote(this.getRelationNameToUse()));
        }
        if (this.getDebug()) {
            vector.add("-d");
        }
        vector.add("-S");
        vector.add("" + this.getSeed());
        return vector.toArray(new String[vector.size()]);
    }

    public Instances defineDataFormat() throws Exception {
        if (this.getRelationName().length() == 0) {
            this.setRelationName(this.defaultRelationName());
        }
        return this.m_DatasetFormat;
    }

    public abstract Instance generateExample() throws Exception;

    public abstract Instances generateExamples() throws Exception;

    public abstract String generateStart() throws Exception;

    public abstract String generateFinished() throws Exception;

    public abstract boolean getSingleModeFlag() throws Exception;

    public void setDebug(boolean bl) {
        this.m_Debug = bl;
    }

    public boolean getDebug() {
        return this.m_Debug;
    }

    public String debugTipText() {
        return "Whether the generator is run in debug mode or not.";
    }

    public void setRelationName(String string) {
        this.m_RelationName = string;
    }

    protected String defaultRelationName() {
        this.m_CreatingRelationName = true;
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        String[] stringArray = this.getOptions();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].trim();
            if (i > 0) {
                stringBuffer.append("_");
            }
            stringBuffer.append(string.replaceAll(" ", "_"));
        }
        this.m_CreatingRelationName = false;
        return stringBuffer.toString();
    }

    protected String getRelationNameToUse() {
        String string = this.getRelationName();
        if (string.length() == 0) {
            string = this.defaultRelationName();
        }
        return string;
    }

    public String getRelationName() {
        return this.m_RelationName;
    }

    public String relationNameTipText() {
        return "The relation name of the generated data (if empty, a generic one will be supplied).";
    }

    protected int defaultNumExamplesAct() {
        return 0;
    }

    protected void setNumExamplesAct(int n) {
        this.m_NumExamplesAct = n;
    }

    protected int getNumExamplesAct() {
        return this.m_NumExamplesAct;
    }

    protected String numExamplesActTipText() {
        return "The actual number of examples to generate.";
    }

    public void setOutput(PrintWriter printWriter) {
        this.m_Output = printWriter;
        this.m_DefaultOutput = null;
    }

    public PrintWriter getOutput() {
        return this.m_Output;
    }

    public StringWriter defaultOutput() {
        return this.m_DefaultOutput;
    }

    public String outputTipText() {
        return "The output writer to use for printing the generated data.";
    }

    public void setDatasetFormat(Instances instances) {
        this.m_DatasetFormat = new Instances(instances, 0);
    }

    public Instances getDatasetFormat() {
        if (this.m_DatasetFormat != null) {
            return new Instances(this.m_DatasetFormat, 0);
        }
        return null;
    }

    public String formatTipText() {
        return "The data format to use.";
    }

    protected int defaultSeed() {
        return 1;
    }

    public int getSeed() {
        return this.m_Seed;
    }

    public void setSeed(int n) {
        this.m_Seed = n;
        this.m_Random = new Random(n);
    }

    public String seedTipText() {
        return "The seed value for the random number generator.";
    }

    public Random getRandom() {
        if (this.m_Random == null) {
            this.m_Random = new Random(this.getSeed());
        }
        return this.m_Random;
    }

    public void setRandom(Random random) {
        this.m_Random = random;
    }

    public String randomTipText() {
        return "The random number generator to use.";
    }

    protected String toStringFormat() {
        if (this.m_DatasetFormat == null) {
            return "";
        }
        return this.m_DatasetFormat.toString();
    }

    protected static void clearBlacklist() {
        m_OptionBlacklist.clear();
    }

    protected static void addToBlacklist(String string) {
        m_OptionBlacklist.add(string);
    }

    protected static boolean isOnBlacklist(String string) {
        return m_OptionBlacklist.contains(string);
    }

    protected String[] removeBlacklist(String[] stringArray) {
        Option option;
        Enumeration enumeration = this.listOptions();
        Hashtable<String, Option> hashtable = new Hashtable<String, Option>();
        while (enumeration.hasMoreElements()) {
            option = (Option)enumeration.nextElement();
            if (!DataGenerator.isOnBlacklist(option.name())) continue;
            hashtable.put(option.name(), option);
        }
        enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            option = (Option)hashtable.get(enumeration.nextElement());
            try {
                if (option.numArguments() == 0) {
                    Utils.getFlag(option.name(), stringArray);
                    continue;
                }
                Utils.getOption(option.name(), stringArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return stringArray;
    }

    protected static String makeOptionString(DataGenerator dataGenerator) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nData Generator options:\n\n");
        Enumeration enumeration = dataGenerator.listOptions();
        while (enumeration.hasMoreElements()) {
            Option option = (Option)enumeration.nextElement();
            if (DataGenerator.isOnBlacklist(option.name())) continue;
            stringBuffer.append(option.synopsis() + "\n" + option.description() + "\n");
        }
        return stringBuffer.toString();
    }

    public static void makeData(DataGenerator dataGenerator, String[] stringArray) throws Exception {
        Object object;
        boolean bl;
        int n;
        boolean bl2 = Utils.getFlag('h', stringArray);
        if (!bl2) {
            try {
                stringArray = dataGenerator.removeBlacklist(stringArray);
                dataGenerator.setOptions(stringArray);
                Vector<String> vector = new Vector<String>();
                for (n = 0; n < stringArray.length; ++n) {
                    if (stringArray[n].length() == 0) continue;
                    vector.add(stringArray[n]);
                }
                if (vector.size() > 0) {
                    System.out.print("Unknown options:");
                    for (n = 0; n < vector.size(); ++n) {
                        System.out.print(" " + vector.get(n));
                    }
                    System.out.println();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl2 = true;
            }
        }
        if (bl2) {
            System.out.println(DataGenerator.makeOptionString(dataGenerator));
            return;
        }
        dataGenerator.setDatasetFormat(dataGenerator.defineDataFormat());
        PrintWriter printWriter = dataGenerator.getOutput();
        printWriter.println("%");
        printWriter.println("% Commandline");
        printWriter.println("%");
        printWriter.println("% " + dataGenerator.getClass().getName() + " " + Utils.joinOptions(dataGenerator.getOptions()));
        printWriter.println("%");
        String string = dataGenerator.generateStart();
        if (string.length() > 0) {
            printWriter.println("%");
            printWriter.println("% Prologue");
            printWriter.println("%");
            printWriter.println(string.trim());
            printWriter.println("%");
        }
        if (bl = dataGenerator.getSingleModeFlag()) {
            printWriter.println(dataGenerator.toStringFormat());
            for (n = 0; n < dataGenerator.getNumExamplesAct(); ++n) {
                object = dataGenerator.generateExample();
                printWriter.println(object);
            }
        } else {
            object = dataGenerator.generateExamples();
            printWriter.println(object);
        }
        if (((String)(object = dataGenerator.generateFinished())).length() > 0) {
            printWriter.println("%");
            printWriter.println("% Epilogue");
            printWriter.println("%");
            printWriter.println(((String)object).trim());
            printWriter.println("%");
        }
        printWriter.flush();
        printWriter.close();
        if (dataGenerator.defaultOutput() != null) {
            System.out.println(dataGenerator.defaultOutput().toString());
        }
    }

    protected static void runDataGenerator(DataGenerator dataGenerator, String[] stringArray) {
        try {
            DataGenerator.makeData(dataGenerator, stringArray);
        }
        catch (Exception exception) {
            if (exception.getMessage() != null && exception.getMessage().indexOf("Data Generator options") == -1) {
                exception.printStackTrace();
            }
            System.err.println(exception.getMessage());
        }
    }
}

