/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import weka.core.Utils;
import weka.experiment.ResultMatrix;
import weka.experiment.ResultMatrixPlainText;

public class ResultMatrixHTML
extends ResultMatrix {
    private static final long serialVersionUID = 6672380422544799990L;

    public ResultMatrixHTML() {
        this(1, 1);
    }

    public ResultMatrixHTML(int n, int n2) {
        super(n, n2);
    }

    public ResultMatrixHTML(ResultMatrix resultMatrix) {
        super(resultMatrix);
    }

    public String getDisplayName() {
        return "HTML";
    }

    public void clear() {
        super.clear();
        this.setRowNameWidth(25);
        this.setPrintColNames(false);
        this.setEnumerateColNames(true);
    }

    public String toStringHeader() {
        return new ResultMatrixPlainText(this).toStringHeader();
    }

    public String toStringMatrix() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        String[][] stringArray = this.toArray();
        stringBuffer.append("<table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">\n");
        stringBuffer.append("   <tr>");
        for (n = 0; n < stringArray[0].length; ++n) {
            if (this.isRowName(n)) {
                stringBuffer.append("<td><b>" + stringArray[0][n] + "</b></td>");
                continue;
            }
            if (!this.isMean(n)) continue;
            int n2 = n == 1 ? 1 : 2;
            if (this.getShowStdDev()) {
                ++n2;
            }
            stringBuffer.append("<td align=\"center\" colspan=\"" + n2 + "\">");
            stringBuffer.append("<b>" + stringArray[0][n] + "</b>");
            stringBuffer.append("</td>");
        }
        stringBuffer.append("</tr>\n");
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append("   <tr>");
            for (n = 0; n < stringArray[i].length; ++n) {
                if (this.isRowName(n)) {
                    stringBuffer.append("<td>");
                } else if (this.isMean(n) || this.isStdDev(n)) {
                    stringBuffer.append("<td align=\"right\">");
                } else if (this.isSignificance(n)) {
                    stringBuffer.append("<td align=\"center\">");
                } else {
                    stringBuffer.append("<td>");
                }
                if (stringArray[i][n].trim().equals("")) {
                    stringBuffer.append("&nbsp;");
                } else if (this.isStdDev(n)) {
                    stringBuffer.append("&plusmn;&nbsp;" + stringArray[i][n]);
                } else {
                    stringBuffer.append(stringArray[i][n]);
                }
                stringBuffer.append("</td>");
            }
            stringBuffer.append("</tr>\n");
        }
        stringBuffer.append("</table>\n");
        return stringBuffer.toString();
    }

    public String toStringKey() {
        String string = "<table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">\n   <tr><td colspan=\"2\"><b>Key</b></td></tr>\n";
        for (int i = 0; i < this.getColCount(); ++i) {
            if (this.getColHidden(i)) continue;
            string = string + "   <tr><td><b>(" + (i + 1) + ")</b></td>" + "<td>" + this.removeFilterName(this.m_ColNames[i]) + "</td>" + "</tr>\n";
        }
        string = string + "</table>\n";
        return string;
    }

    public String toStringSummary() {
        int n;
        if (this.m_NonSigWins == null) {
            return "-summary data not set-";
        }
        String string = "<table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">\n";
        String string2 = "   <tr>";
        int n2 = 1 + Math.max((int)(Math.log(this.getColCount()) / Math.log(10.0)), (int)(Math.log(this.getRowCount()) / Math.log(10.0)));
        for (n = 0; n < this.getColCount(); ++n) {
            if (this.getColHidden(n)) continue;
            string2 = string2 + "<td align=\"center\"><b>" + this.getSummaryTitle(n) + "</b></td>";
        }
        string = string + string2 + "<td><b>(No. of datasets where [col] &gt;&gt; [row])</b></td></tr>\n";
        for (n = 0; n < this.getColCount(); ++n) {
            if (this.getColHidden(n)) continue;
            string = string + "   <tr>";
            for (int i = 0; i < this.getColCount(); ++i) {
                if (this.getColHidden(i)) continue;
                String string3 = i == n ? Utils.padLeft("-", n2 * 2 + 3) : Utils.padLeft("" + this.m_NonSigWins[n][i] + " (" + this.m_Wins[n][i] + ")", n2 * 2 + 3);
                string = string + "<td>" + string3.replaceAll(" ", "&nbsp;") + "</td>";
            }
            string = string + "<td><b>" + this.getSummaryTitle(n) + "</b> = " + this.removeFilterName(this.m_ColNames[n]) + "</td></tr>\n";
        }
        string = string + "</table>\n";
        return string;
    }

    public String toStringRanking() {
        if (this.m_RankingWins == null) {
            return "-ranking data not set-";
        }
        int n = Math.max(this.m_RankingWins[Utils.maxIndex(this.m_RankingWins)], this.m_RankingLosses[Utils.maxIndex(this.m_RankingLosses)]);
        int n2 = Math.max(2 + (int)(Math.log(n) / Math.log(10.0)), ">-<".length());
        String string = "<table border=\"1\" cellpadding=\"3\" cellspacing=\"0\">\n";
        string = string + "   <tr><td align=\"center\"><b>&gt;-&lt;</b></td><td align=\"center\"><b>&gt;</b></td><td align=\"center\"><b>&lt;</b></td><td><b>Resultset</b></td></tr>\n";
        int[] nArray = Utils.sort(this.m_RankingDiff);
        for (int i = this.getColCount() - 1; i >= 0; --i) {
            int n3 = nArray[i];
            if (this.getColHidden(n3)) continue;
            string = string + "   <tr><td align=\"right\">" + this.m_RankingDiff[n3] + "</td>" + "<td align=\"right\">" + this.m_RankingWins[n3] + "</td>" + "<td align=\"right\">" + this.m_RankingLosses[n3] + "</td>" + "<td>" + this.removeFilterName(this.m_ColNames[n3]) + "</td>" + "<tr>\n";
        }
        string = string + "</table>\n";
        return string;
    }

    public static void main(String[] stringArray) {
        ResultMatrixHTML resultMatrixHTML = new ResultMatrixHTML(3, 3);
        resultMatrixHTML.addHeader("header1", "value1");
        resultMatrixHTML.addHeader("header2", "value2");
        resultMatrixHTML.addHeader("header2", "value3");
        for (int i = 0; i < resultMatrixHTML.getRowCount(); ++i) {
            for (int j = 0; j < resultMatrixHTML.getColCount(); ++j) {
                resultMatrixHTML.setMean(j, i, (i + 1) * j);
                resultMatrixHTML.setStdDev(j, i, (double)(i + 1) * (double)j / 100.0);
                if (i != j) continue;
                if (i % 2 == 1) {
                    resultMatrixHTML.setSignificance(j, i, 1);
                    continue;
                }
                resultMatrixHTML.setSignificance(j, i, 2);
            }
        }
        System.out.println("\n\n--> " + ((ResultMatrix)resultMatrixHTML).getDisplayName());
        System.out.println("\n1. complete\n");
        System.out.println(((ResultMatrix)resultMatrixHTML).toStringHeader() + "\n");
        System.out.println(((ResultMatrix)resultMatrixHTML).toStringMatrix() + "\n");
        System.out.println(((ResultMatrix)resultMatrixHTML).toStringKey());
        System.out.println("\n2. complete with std deviations\n");
        resultMatrixHTML.setShowStdDev(true);
        System.out.println(((ResultMatrix)resultMatrixHTML).toStringMatrix());
        System.out.println("\n3. cols numbered\n");
        resultMatrixHTML.setPrintColNames(false);
        System.out.println(((ResultMatrix)resultMatrixHTML).toStringMatrix());
        System.out.println("\n4. second col missing\n");
        resultMatrixHTML.setColHidden(1, true);
        System.out.println(((ResultMatrix)resultMatrixHTML).toStringMatrix());
        System.out.println("\n5. last row missing, rows numbered too\n");
        resultMatrixHTML.setRowHidden(2, true);
        resultMatrixHTML.setPrintRowNames(false);
        System.out.println(((ResultMatrix)resultMatrixHTML).toStringMatrix());
        System.out.println("\n6. mean prec to 3\n");
        resultMatrixHTML.setMeanPrec(3);
        resultMatrixHTML.setPrintRowNames(false);
        System.out.println(((ResultMatrix)resultMatrixHTML).toStringMatrix());
    }
}

