/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.meta.nestedDichotomies;

import java.util.Hashtable;
import java.util.Random;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.RandomizableSingleClassifierEnhancer;
import weka.classifiers.meta.FilteredClassifier;
import weka.classifiers.rules.ZeroR;
import weka.classifiers.trees.J48;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Range;
import weka.core.UnsupportedClassTypeException;
import weka.core.Utils;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.MakeIndicator;
import weka.filters.unsupervised.instance.RemoveWithValues;

public class DataNearBalancedND
extends RandomizableSingleClassifierEnhancer {
    protected FilteredClassifier m_FilteredClassifier;
    protected Hashtable m_classifiers = new Hashtable();
    protected DataNearBalancedND m_FirstSuccessor = null;
    protected DataNearBalancedND m_SecondSuccessor = null;
    protected Range m_Range = null;
    protected boolean m_hashtablegiven = false;

    public DataNearBalancedND() {
        this.m_Classifier = new J48();
    }

    protected String defaultClassifierString() {
        return "weka.classifiers.trees.J48";
    }

    public void setHashtable(Hashtable hashtable) {
        this.m_hashtablegiven = true;
        this.m_classifiers = hashtable;
    }

    private void generateClassifierForNode(Instances instances, Range range, Random random, Classifier classifier, Hashtable hashtable, double[] dArray) throws Exception {
        Instances instances2;
        RemoveWithValues removeWithValues;
        int n;
        int n2;
        int[] nArray = range.getSelection();
        for (int i = nArray.length - 1; i > 0; --i) {
            int n3 = random.nextInt(i + 1);
            n2 = nArray[n3];
            nArray[n3] = nArray[i];
            nArray[i] = n2;
        }
        double d = 0.0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            d += dArray[nArray[n2]];
        }
        double d2 = d / 2.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n4 = 0;
        int n5 = nArray.length - 1;
        do {
            if (n4 == n5) {
                if (random.nextBoolean()) {
                    d3 += dArray[nArray[n4++]];
                    continue;
                }
                d4 += dArray[nArray[n5--]];
                continue;
            }
            d3 += dArray[nArray[n4++]];
            d4 += dArray[nArray[n5--]];
        } while (Utils.sm(d3, d2) && Utils.sm(d4, d2));
        int n6 = 0;
        int n7 = 0;
        n6 = !Utils.sm(d3, d2) ? n4 : n5 + 1;
        n7 = nArray.length - n6;
        int[] nArray2 = new int[n6];
        int[] nArray3 = new int[n7];
        System.arraycopy(nArray, 0, nArray2, 0, n6);
        System.arraycopy(nArray, n6, nArray3, 0, n7);
        int[] nArray4 = Utils.sort(nArray2);
        int[] nArray5 = Utils.sort(nArray3);
        int[] nArray6 = new int[n6];
        int[] nArray7 = new int[n7];
        for (n = 0; n < nArray4.length; ++n) {
            nArray6[n] = nArray2[nArray4[n]];
        }
        nArray2 = nArray6;
        for (n = 0; n < nArray5.length; ++n) {
            nArray7[n] = nArray3[nArray5[n]];
        }
        nArray3 = nArray7;
        if (nArray2[0] > nArray3[0]) {
            int[] nArray8 = nArray3;
            nArray3 = nArray2;
            nArray2 = nArray8;
            int n8 = n7;
            n7 = n6;
            n6 = n8;
        }
        this.m_Range = new Range(Range.indicesToRangeList(nArray2));
        this.m_Range.setUpper(instances.numClasses() - 1);
        Range range2 = new Range(Range.indicesToRangeList(nArray3));
        range2.setUpper(instances.numClasses() - 1);
        MakeIndicator makeIndicator = new MakeIndicator();
        makeIndicator.setAttributeIndex("" + (instances.classIndex() + 1));
        makeIndicator.setValueIndices(this.m_Range.getRanges());
        makeIndicator.setNumeric(false);
        makeIndicator.setInputFormat(instances);
        this.m_FilteredClassifier = new FilteredClassifier();
        if (instances.numInstances() > 0) {
            this.m_FilteredClassifier.setClassifier(Classifier.makeCopies(classifier, 1)[0]);
        } else {
            this.m_FilteredClassifier.setClassifier(new ZeroR());
        }
        this.m_FilteredClassifier.setFilter(makeIndicator);
        this.m_classifiers = hashtable;
        if (!this.m_classifiers.containsKey(this.getString(nArray2) + "|" + this.getString(nArray3))) {
            this.m_FilteredClassifier.buildClassifier(instances);
            this.m_classifiers.put(this.getString(nArray2) + "|" + this.getString(nArray3), this.m_FilteredClassifier);
        } else {
            this.m_FilteredClassifier = (FilteredClassifier)this.m_classifiers.get(this.getString(nArray2) + "|" + this.getString(nArray3));
        }
        this.m_FirstSuccessor = new DataNearBalancedND();
        if (n6 == 1) {
            this.m_FirstSuccessor.m_Range = this.m_Range;
        } else {
            removeWithValues = new RemoveWithValues();
            removeWithValues.setInvertSelection(true);
            removeWithValues.setNominalIndices(this.m_Range.getRanges());
            removeWithValues.setAttributeIndex("" + (instances.classIndex() + 1));
            removeWithValues.setInputFormat(instances);
            instances2 = Filter.useFilter(instances, removeWithValues);
            this.m_FirstSuccessor.generateClassifierForNode(instances2, this.m_Range, random, classifier, this.m_classifiers, dArray);
        }
        this.m_SecondSuccessor = new DataNearBalancedND();
        if (n7 == 1) {
            this.m_SecondSuccessor.m_Range = range2;
        } else {
            removeWithValues = new RemoveWithValues();
            removeWithValues.setInvertSelection(true);
            removeWithValues.setNominalIndices(range2.getRanges());
            removeWithValues.setAttributeIndex("" + (instances.classIndex() + 1));
            removeWithValues.setInputFormat(instances);
            instances2 = Filter.useFilter(instances, removeWithValues);
            this.m_SecondSuccessor = new DataNearBalancedND();
            this.m_SecondSuccessor.generateClassifierForNode(instances2, range2, random, classifier, this.m_classifiers, dArray);
        }
    }

    public void buildClassifier(Instances instances) throws Exception {
        if (!instances.classAttribute().isNominal()) {
            throw new UnsupportedClassTypeException("DataNearBalancedND: class must be nominal!");
        }
        instances.deleteWithMissingClass();
        if (instances.numInstances() == 0) {
            throw new Exception("No instances in training file!");
        }
        Random random = instances.getRandomNumberGenerator(this.m_Seed);
        if (!this.m_hashtablegiven) {
            this.m_classifiers = new Hashtable();
        }
        boolean[] blArray = new boolean[instances.numClasses()];
        for (int i = 0; i < instances.numInstances(); ++i) {
            blArray[(int)instances.instance((int)i).classValue()] = true;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < blArray.length; ++i) {
            if (!blArray[i]) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(i + 1);
        }
        double[] dArray = new double[instances.numClasses()];
        for (int i = 0; i < instances.numInstances(); ++i) {
            int n = (int)instances.instance(i).classValue();
            dArray[n] = dArray[n] + instances.instance(i).weight();
        }
        Range range = new Range(stringBuffer.toString());
        range.setUpper(instances.numClasses() - 1);
        this.generateClassifierForNode(instances, range, random, this.m_Classifier, this.m_classifiers, dArray);
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        int n;
        double[] dArray = new double[instance.numClasses()];
        if (this.m_FirstSuccessor == null) {
            for (int i = 0; i < instance.numClasses(); ++i) {
                if (!this.m_Range.isInRange(i)) continue;
                dArray[i] = 1.0;
            }
            return dArray;
        }
        double[] dArray2 = this.m_FirstSuccessor.distributionForInstance(instance);
        double[] dArray3 = this.m_SecondSuccessor.distributionForInstance(instance);
        double[] dArray4 = this.m_FilteredClassifier.distributionForInstance(instance);
        for (n = 0; n < instance.numClasses(); ++n) {
            if (dArray2[n] > 0.0 && dArray3[n] > 0.0) {
                System.err.println("Panik!!");
            }
            dArray[n] = this.m_Range.isInRange(n) ? dArray4[1] * dArray2[n] : dArray4[0] * dArray3[n];
        }
        if (!Utils.eq(Utils.sum(dArray), 1.0)) {
            System.err.println(Utils.sum(dArray));
            for (n = 0; n < dArray4.length; ++n) {
                System.err.print(dArray4[n] + " ");
            }
            System.err.println();
            for (n = 0; n < dArray.length; ++n) {
                System.err.print(dArray[n] + " ");
            }
            System.err.println();
            System.err.println(instance);
            System.err.println(this.m_FilteredClassifier);
            System.err.println("bad");
        }
        return dArray;
    }

    public String getString(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(nArray[i]);
        }
        return stringBuffer.toString();
    }

    public String globalInfo() {
        return "A meta classifier for handling multi-class datasets with 2-class classifiers by building a random data-balanced tree structure. For more info, check\n\nLin Dong, Eibe Frank, and Stefan Kramer (2005). Ensembles of Balanced Nested Dichotomies for Multi-Class Problems. PKDD, Porto. Springer-Verlag\n\nand\n\nEibe Frank and Stefan Kramer (2004). Ensembles of Nested Dichotomies for Multi-class Problems. Proceedings of the International Conference on Machine Learning, Banff. Morgan Kaufmann.";
    }

    public String toString() {
        if (this.m_classifiers == null) {
            return "DataNearBalancedND: No model built yet.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DataNearBalancedND");
        this.treeToString(stringBuffer, 0);
        return stringBuffer.toString();
    }

    private int treeToString(StringBuffer stringBuffer, int n) {
        stringBuffer.append("\n\nNode number: " + ++n + "\n\n");
        if (this.m_FilteredClassifier != null) {
            stringBuffer.append(this.m_FilteredClassifier);
        } else {
            stringBuffer.append("null");
        }
        if (this.m_FirstSuccessor != null) {
            n = this.m_FirstSuccessor.treeToString(stringBuffer, n);
            n = this.m_SecondSuccessor.treeToString(stringBuffer, n);
        }
        return n;
    }

    public static void main(String[] stringArray) {
        try {
            DataNearBalancedND dataNearBalancedND = new DataNearBalancedND();
            System.out.println(Evaluation.evaluateModel(dataNearBalancedND, stringArray));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
    }
}

