/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions.supportVector;

import weka.classifiers.functions.supportVector.CachedKernel;
import weka.core.Instance;
import weka.core.Instances;

public class PolyKernel
extends CachedKernel {
    private boolean m_lowerOrder = false;
    private double m_exponent = 1.0;

    public PolyKernel(Instances instances, int n, double d, boolean bl) {
        super(instances, n);
        this.m_exponent = d;
        this.m_lowerOrder = bl;
        this.m_data = instances;
    }

    protected double evaluate(int n, int n2, Instance instance) throws Exception {
        double d = n == n2 ? this.dotProd(instance, instance) : this.dotProd(instance, this.m_data.instance(n2));
        if (this.m_lowerOrder) {
            d += 1.0;
        }
        if (this.m_exponent != 1.0) {
            d = Math.pow(d, this.m_exponent);
        }
        return d;
    }
}

