/*
 * Decompiled with CFR 0.152.
 */
package weka.gui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;

public class SplashWindow
extends Window {
    private static SplashWindow m_instance;
    private Image image;
    private boolean paintCalled = false;
    static /* synthetic */ Class array$Ljava$lang$String;

    private SplashWindow(Frame frame, Image image) {
        super(frame);
        this.image = image;
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int n = image.getWidth(this);
        int n2 = image.getHeight(this);
        this.setSize(n, n2);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - n) / 2, (dimension.height - n2) / 2);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseClicked(MouseEvent mouseEvent) {
                SplashWindow splashWindow = SplashWindow.this;
                synchronized (splashWindow) {
                    SplashWindow.this.paintCalled = true;
                    SplashWindow.this.notifyAll();
                }
                SplashWindow.this.dispose();
            }
        };
        this.addMouseListener(mouseAdapter);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        graphics.drawImage(this.image, 0, 0, this);
        if (!this.paintCalled) {
            this.paintCalled = true;
            SplashWindow splashWindow = this;
            synchronized (splashWindow) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void splash(Image image) {
        if (m_instance == null && image != null) {
            Frame frame = new Frame();
            m_instance = new SplashWindow(frame, image);
            m_instance.show();
            if (!EventQueue.isDispatchThread() && Runtime.getRuntime().availableProcessors() == 1) {
                SplashWindow splashWindow = m_instance;
                synchronized (splashWindow) {
                    while (!SplashWindow.m_instance.paintCalled) {
                        try {
                            m_instance.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
    }

    public static void splash(URL uRL) {
        if (uRL != null) {
            SplashWindow.splash(Toolkit.getDefaultToolkit().createImage(uRL));
        }
    }

    public static void disposeSplash() {
        if (m_instance != null) {
            m_instance.getOwner().dispose();
            m_instance = null;
        }
    }

    public static void invokeMethod(String string, String string2, String[] stringArray) {
        try {
            Class.forName(string).getMethod(string2, array$Ljava$lang$String == null ? (array$Ljava$lang$String = SplashWindow.class$("[Ljava.lang.String;")) : array$Ljava$lang$String).invoke(null, new Object[]{stringArray});
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Failed to invoke method: " + string2);
            internalError.initCause(exception);
            throw internalError;
        }
    }

    public static void invokeMain(String string, String[] stringArray) {
        try {
            Class.forName(string).getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = SplashWindow.class$("[Ljava.lang.String;")) : array$Ljava$lang$String).invoke(null, new Object[]{stringArray});
        }
        catch (Exception exception) {
            InternalError internalError = new InternalError("Failed to invoke main method");
            internalError.initCause(exception);
            throw internalError;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

