/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.graphvisualizer;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import weka.core.FastVector;
import weka.gui.graphvisualizer.BIFFormatException;
import weka.gui.graphvisualizer.GraphConstants;
import weka.gui.graphvisualizer.GraphEdge;
import weka.gui.graphvisualizer.GraphNode;

public class BIFParser
implements GraphConstants {
    protected FastVector m_nodes;
    protected FastVector m_edges;
    protected String graphName;
    protected String inString;
    protected InputStream inStream;

    public BIFParser(String string, FastVector fastVector, FastVector fastVector2) {
        this.m_nodes = fastVector;
        this.m_edges = fastVector2;
        this.inString = string;
    }

    public BIFParser(InputStream inputStream, FastVector fastVector, FastVector fastVector2) {
        this.m_nodes = fastVector;
        this.m_edges = fastVector2;
        this.inStream = inputStream;
    }

    public String parse() throws Exception {
        int n;
        Object object;
        Object object2;
        int n2;
        Object object3;
        Object object4;
        int n3;
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        if (this.inStream != null) {
            document = documentBuilder.parse(this.inStream);
        } else if (this.inString != null) {
            document = documentBuilder.parse(new InputSource(new StringReader(this.inString)));
        } else {
            throw new Exception("No input given");
        }
        NodeList nodeList = document.getElementsByTagName("NETWORK");
        if (nodeList.getLength() == 0) {
            throw new BIFFormatException("NETWORK tag not found");
        }
        NodeList nodeList2 = ((Element)nodeList.item(0)).getElementsByTagName("NAME");
        this.graphName = nodeList2.item(0).getFirstChild().getNodeValue();
        nodeList = document.getElementsByTagName("VARIABLE");
        for (n3 = 0; n3 < nodeList.getLength(); ++n3) {
            nodeList2 = ((Element)nodeList.item(n3)).getElementsByTagName("NAME");
            if (nodeList2.getLength() > 1) {
                throw new BIFFormatException("More than one name tags found for variable no. " + (n3 + 1));
            }
            object4 = nodeList2.item(0).getFirstChild().getNodeValue();
            object3 = new GraphNode((String)object4, (String)object4, 3);
            this.m_nodes.addElement(object3);
            nodeList2 = ((Element)nodeList.item(n3)).getElementsByTagName("PROPERTY");
            for (n2 = 0; n2 < nodeList2.getLength(); ++n2) {
                if (!nodeList2.item(n2).getFirstChild().getNodeValue().startsWith("position")) continue;
                object2 = nodeList2.item(n2).getFirstChild().getNodeValue();
                object3.x = Integer.parseInt(((String)object2).substring(((String)object2).indexOf(40) + 1, ((String)object2).indexOf(44)).trim());
                object3.y = Integer.parseInt(((String)object2).substring(((String)object2).indexOf(44) + 1, ((String)object2).indexOf(41)).trim());
                break;
            }
            nodeList2 = ((Element)nodeList.item(n3)).getElementsByTagName("OUTCOME");
            object3.outcomes = new String[nodeList2.getLength()];
            for (n2 = 0; n2 < nodeList2.getLength(); ++n2) {
                object3.outcomes[n2] = nodeList2.item(n2).getFirstChild().getNodeValue();
            }
        }
        nodeList = document.getElementsByTagName("DEFINITION");
        for (n3 = 0; n3 < nodeList.getLength(); ++n3) {
            int n4;
            nodeList2 = ((Element)nodeList.item(n3)).getElementsByTagName("FOR");
            object4 = nodeList2.item(0).getFirstChild().getNodeValue();
            object3 = (GraphNode)this.m_nodes.elementAt(0);
            for (n2 = 1; n2 < this.m_nodes.size() && !object3.ID.equals(object4); ++n2) {
                object3 = (GraphNode)this.m_nodes.elementAt(n2);
            }
            nodeList2 = ((Element)nodeList.item(n3)).getElementsByTagName("GIVEN");
            n2 = 1;
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                object4 = nodeList2.item(i).getFirstChild().getNodeValue();
                object = (GraphNode)this.m_nodes.elementAt(0);
                for (n4 = 1; n4 < this.m_nodes.size() && !((GraphNode)object).ID.equals(object4); ++n4) {
                    object = (GraphNode)this.m_nodes.elementAt(n4);
                }
                this.m_edges.addElement(new GraphEdge(this.m_nodes.indexOf(object), this.m_nodes.indexOf(object3), 1));
                n2 *= ((GraphNode)object).outcomes.length;
            }
            nodeList2 = ((Element)nodeList.item(n3)).getElementsByTagName("TABLE");
            if (nodeList2.getLength() > 1) {
                throw new BIFFormatException("More than one Probability Table for " + object3.ID);
            }
            object2 = nodeList2.item(0).getFirstChild().getNodeValue();
            object = new StringTokenizer((String)object2, " \n\t");
            if (n2 * object3.outcomes.length > ((StringTokenizer)object).countTokens()) {
                throw new BIFFormatException("Probability Table for " + object3.ID + " contains more values than it should");
            }
            if (n2 * object3.outcomes.length < ((StringTokenizer)object).countTokens()) {
                throw new BIFFormatException("Probability Table for " + object3.ID + " contains less values than it should");
            }
            object3.probs = new double[n2][object3.outcomes.length];
            for (n4 = 0; n4 < n2; ++n4) {
                for (n = 0; n < object3.outcomes.length; ++n) {
                    object3.probs[n4][n] = Double.parseDouble(((StringTokenizer)object).nextToken());
                    continue;
                }
            }
        }
        object4 = new int[this.m_nodes.size()];
        object3 = new int[this.m_nodes.size()];
        for (n2 = 0; n2 < this.m_edges.size(); ++n2) {
            object2 = (GraphEdge)this.m_edges.elementAt(n2);
            int n5 = ((GraphEdge)object2).src;
            object4[n5] = object4[n5] + 1;
            int n6 = ((GraphEdge)object2).dest;
            object3[n6] = object3[n6] + 1;
        }
        for (n2 = 0; n2 < this.m_edges.size(); ++n2) {
            object2 = (GraphEdge)this.m_edges.elementAt(n2);
            object = (GraphNode)this.m_nodes.elementAt(((GraphEdge)object2).src);
            GraphNode graphNode = (GraphNode)this.m_nodes.elementAt(((GraphEdge)object2).dest);
            if (((GraphNode)object).edges == null) {
                ((GraphNode)object).edges = new int[object4[((GraphEdge)object2).src]][2];
                for (n = 0; n < ((GraphNode)object).edges.length; ++n) {
                    ((GraphNode)object).edges[n][0] = -1;
                }
            }
            if (graphNode.prnts == null) {
                graphNode.prnts = new int[object3[((GraphEdge)object2).dest]];
                for (n = 0; n < graphNode.prnts.length; ++n) {
                    graphNode.prnts[n] = -1;
                }
            }
            n = 0;
            while (((GraphNode)object).edges[n][0] != -1) {
                ++n;
            }
            ((GraphNode)object).edges[n][0] = ((GraphEdge)object2).dest;
            ((GraphNode)object).edges[n][1] = ((GraphEdge)object2).type;
            n = 0;
            while (graphNode.prnts[n] != -1) {
                ++n;
            }
            graphNode.prnts[n] = ((GraphEdge)object2).src;
        }
        return this.graphName;
    }

    public static void writeXMLBIF03(String string, String string2, FastVector fastVector, FastVector fastVector2) {
        try {
            int n;
            GraphNode graphNode;
            int n2;
            FileWriter fileWriter = new FileWriter(string);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<?xml version=\"1.0\"?>\n");
            stringBuffer.append("<!-- DTD for the XMLBIF 0.3 format -->\n");
            stringBuffer.append("<!DOCTYPE BIF [\n");
            stringBuffer.append("\t<!ELEMENT BIF ( NETWORK )*>\n");
            stringBuffer.append("\t      <!ATTLIST BIF VERSION CDATA #REQUIRED>\n");
            stringBuffer.append("\t<!ELEMENT NETWORK ( NAME, ( PROPERTY | VARIABLE | DEFINITION )* )>\n");
            stringBuffer.append("\t<!ELEMENT NAME (#PCDATA)>\n");
            stringBuffer.append("\t<!ELEMENT VARIABLE ( NAME, ( OUTCOME |  PROPERTY )* ) >\n");
            stringBuffer.append("\t      <!ATTLIST VARIABLE TYPE (nature|decision|utility) \"nature\">\n");
            stringBuffer.append("\t<!ELEMENT OUTCOME (#PCDATA)>\n");
            stringBuffer.append("\t<!ELEMENT DEFINITION ( FOR | GIVEN | TABLE | PROPERTY )* >\n");
            stringBuffer.append("\t<!ELEMENT FOR (#PCDATA)>\n");
            stringBuffer.append("\t<!ELEMENT GIVEN (#PCDATA)>\n");
            stringBuffer.append("\t<!ELEMENT TABLE (#PCDATA)>\n");
            stringBuffer.append("\t<!ELEMENT PROPERTY (#PCDATA)>\n");
            stringBuffer.append("]>\n");
            stringBuffer.append("\n");
            stringBuffer.append("\n");
            stringBuffer.append("<BIF VERSION=\"0.3\">\n");
            stringBuffer.append("<NETWORK>\n");
            stringBuffer.append("<NAME>" + BIFParser.XMLNormalize(string2) + "</NAME>\n");
            for (n2 = 0; n2 < fastVector.size(); ++n2) {
                graphNode = (GraphNode)fastVector.elementAt(n2);
                if (graphNode.nodeType != 3) continue;
                stringBuffer.append("<VARIABLE TYPE=\"nature\">\n");
                stringBuffer.append("\t<NAME>" + BIFParser.XMLNormalize(graphNode.ID) + "</NAME>\n");
                if (graphNode.outcomes != null) {
                    for (n = 0; n < graphNode.outcomes.length; ++n) {
                        stringBuffer.append("\t<OUTCOME>" + BIFParser.XMLNormalize(graphNode.outcomes[n]) + "</OUTCOME>\n");
                    }
                } else {
                    stringBuffer.append("\t<OUTCOME>true</OUTCOME>\n");
                }
                stringBuffer.append("\t<PROPERTY>position = (" + graphNode.x + "," + graphNode.y + ")</PROPERTY>\n");
                stringBuffer.append("</VARIABLE>\n");
            }
            for (n2 = 0; n2 < fastVector.size(); ++n2) {
                int n3;
                graphNode = (GraphNode)fastVector.elementAt(n2);
                if (graphNode.nodeType != 3) continue;
                stringBuffer.append("<DEFINITION>\n");
                stringBuffer.append("<FOR>" + BIFParser.XMLNormalize(graphNode.ID) + "</FOR>\n");
                n = 1;
                if (graphNode.prnts != null) {
                    for (n3 = 0; n3 < graphNode.prnts.length; ++n3) {
                        GraphNode graphNode2 = (GraphNode)fastVector.elementAt(graphNode.prnts[n3]);
                        stringBuffer.append("\t<GIVEN>" + BIFParser.XMLNormalize(graphNode2.ID) + "</GIVEN>\n");
                        if (graphNode2.outcomes == null) continue;
                        n *= graphNode2.outcomes.length;
                    }
                }
                stringBuffer.append("<TABLE>\n");
                for (n3 = 0; n3 < n; ++n3) {
                    if (graphNode.outcomes != null) {
                        for (int i = 0; i < graphNode.outcomes.length; ++i) {
                            stringBuffer.append(graphNode.probs[n3][i] + " ");
                        }
                    } else {
                        stringBuffer.append("1");
                    }
                    stringBuffer.append('\n');
                }
                stringBuffer.append("</TABLE>\n");
                stringBuffer.append("</DEFINITION>\n");
            }
            stringBuffer.append("</NETWORK>\n");
            stringBuffer.append("</BIF>\n");
            fileWriter.write(stringBuffer.toString());
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static String XMLNormalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        block7: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block7;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block7;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
        }
        return stringBuffer.toString();
    }
}

