/*
 * Decompiled with CFR 0.152.
 */
package weka.experiment;

import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.Classifier;
import weka.classifiers.Evaluation;
import weka.classifiers.rules.ZeroR;
import weka.core.AdditionalMeasureProducer;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.Summarizable;
import weka.core.Utils;
import weka.experiment.SplitEvaluator;

public class RegressionSplitEvaluator
implements SplitEvaluator,
OptionHandler,
AdditionalMeasureProducer {
    protected Classifier m_Template = new ZeroR();
    protected Classifier m_Classifier;
    protected String[] m_AdditionalMeasures = null;
    protected boolean[] m_doesProduce = null;
    protected String m_result = null;
    protected String m_ClassifierOptions = "";
    protected String m_ClassifierVersion = "";
    private static final int KEY_SIZE = 3;
    private static final int RESULT_SIZE = 15;

    public RegressionSplitEvaluator() {
        this.updateOptions();
    }

    public String globalInfo() {
        return "A SplitEvaluator that produces results for a classification scheme on a numeric class attribute.";
    }

    public Enumeration listOptions() {
        Vector<Option> vector = new Vector<Option>(1);
        vector.addElement(new Option("\tThe full class name of the classifier.\n\teg: weka.classifiers.bayes.NaiveBayes", "W", 1, "-W <class name>"));
        if (this.m_Template != null && this.m_Template instanceof OptionHandler) {
            vector.addElement(new Option("", "", 0, "\nOptions specific to classifier " + this.m_Template.getClass().getName() + ":"));
            Enumeration enumeration = this.m_Template.listOptions();
            while (enumeration.hasMoreElements()) {
                vector.addElement((Option)enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public void setOptions(String[] stringArray) throws Exception {
        String string = Utils.getOption('W', stringArray);
        if (string.length() == 0) {
            throw new Exception("A classifier must be specified with the -W option.");
        }
        this.setClassifier(Classifier.forName(string, null));
        if (this.getClassifier() instanceof OptionHandler) {
            this.getClassifier().setOptions(Utils.partitionOptions(stringArray));
            this.updateOptions();
        }
    }

    public String[] getOptions() {
        String[] stringArray = new String[]{};
        if (this.m_Template != null && this.m_Template instanceof OptionHandler) {
            stringArray = this.m_Template.getOptions();
        }
        String[] stringArray2 = new String[stringArray.length + 3];
        int n = 0;
        if (this.getClassifier() != null) {
            stringArray2[n++] = "-W";
            stringArray2[n++] = this.getClassifier().getClass().getName();
        }
        stringArray2[n++] = "--";
        System.arraycopy(stringArray, 0, stringArray2, n, stringArray.length);
        n += stringArray.length;
        while (n < stringArray2.length) {
            stringArray2[n++] = "";
        }
        return stringArray2;
    }

    public void setAdditionalMeasures(String[] stringArray) {
        this.m_AdditionalMeasures = stringArray;
        if (this.m_AdditionalMeasures != null && this.m_AdditionalMeasures.length > 0) {
            this.m_doesProduce = new boolean[this.m_AdditionalMeasures.length];
            if (this.m_Template instanceof AdditionalMeasureProducer) {
                Enumeration enumeration = ((AdditionalMeasureProducer)((Object)this.m_Template)).enumerateMeasures();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    for (int i = 0; i < this.m_AdditionalMeasures.length; ++i) {
                        if (string.compareToIgnoreCase(this.m_AdditionalMeasures[i]) != 0) continue;
                        this.m_doesProduce[i] = true;
                    }
                }
            }
        } else {
            this.m_doesProduce = null;
        }
    }

    public Enumeration enumerateMeasures() {
        Vector<String> vector = new Vector<String>();
        if (this.m_Template instanceof AdditionalMeasureProducer) {
            Enumeration enumeration = ((AdditionalMeasureProducer)((Object)this.m_Template)).enumerateMeasures();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                vector.addElement(string);
            }
        }
        return vector.elements();
    }

    public double getMeasure(String string) {
        if (this.m_Template instanceof AdditionalMeasureProducer) {
            if (this.m_Classifier == null) {
                throw new IllegalArgumentException("ClassifierSplitEvaluator: Can't return result for measure, classifier has not been built yet.");
            }
            return ((AdditionalMeasureProducer)((Object)this.m_Classifier)).getMeasure(string);
        }
        throw new IllegalArgumentException("ClassifierSplitEvaluator: Can't return value for : " + string + ". " + this.m_Template.getClass().getName() + " " + "is not an AdditionalMeasureProducer");
    }

    public Object[] getKeyTypes() {
        Object[] objectArray = new Object[]{"", "", ""};
        return objectArray;
    }

    public String[] getKeyNames() {
        String[] stringArray = new String[]{"Scheme", "Scheme_options", "Scheme_version_ID"};
        return stringArray;
    }

    public Object[] getKey() {
        Object[] objectArray = new Object[]{this.m_Template.getClass().getName(), this.m_ClassifierOptions, this.m_ClassifierVersion};
        return objectArray;
    }

    public Object[] getResultTypes() {
        int n = this.m_AdditionalMeasures != null ? this.m_AdditionalMeasures.length : 0;
        Object[] objectArray = new Object[15 + n];
        Double d = new Double(0.0);
        int n2 = 0;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = d;
        objectArray[n2++] = "";
        for (int i = 0; i < n; ++i) {
            objectArray[n2++] = d;
        }
        if (n2 != 15 + n) {
            throw new Error("ResultTypes didn't fit RESULT_SIZE");
        }
        return objectArray;
    }

    public String[] getResultNames() {
        int n = this.m_AdditionalMeasures != null ? this.m_AdditionalMeasures.length : 0;
        String[] stringArray = new String[15 + n];
        int n2 = 0;
        stringArray[n2++] = "Number_of_instances";
        stringArray[n2++] = "Mean_absolute_error";
        stringArray[n2++] = "Root_mean_squared_error";
        stringArray[n2++] = "Relative_absolute_error";
        stringArray[n2++] = "Root_relative_squared_error";
        stringArray[n2++] = "Correlation_coefficient";
        stringArray[n2++] = "SF_prior_entropy";
        stringArray[n2++] = "SF_scheme_entropy";
        stringArray[n2++] = "SF_entropy_gain";
        stringArray[n2++] = "SF_mean_prior_entropy";
        stringArray[n2++] = "SF_mean_scheme_entropy";
        stringArray[n2++] = "SF_mean_entropy_gain";
        stringArray[n2++] = "Time_training";
        stringArray[n2++] = "Time_testing";
        stringArray[n2++] = "Summary";
        for (int i = 0; i < n; ++i) {
            stringArray[n2++] = this.m_AdditionalMeasures[i];
        }
        if (n2 != 15 + n) {
            throw new Error("ResultNames didn't fit RESULT_SIZE");
        }
        return stringArray;
    }

    public Object[] getResult(Instances instances, Instances instances2) throws Exception {
        if (instances.classAttribute().type() != 0) {
            throw new Exception("Class attribute is not numeric!");
        }
        if (this.m_Template == null) {
            throw new Exception("No classifier has been specified");
        }
        int n = this.m_AdditionalMeasures != null ? this.m_AdditionalMeasures.length : 0;
        Object[] objectArray = new Object[15 + n];
        Evaluation evaluation = new Evaluation(instances);
        this.m_Classifier = Classifier.makeCopy(this.m_Template);
        long l = System.currentTimeMillis();
        this.m_Classifier.buildClassifier(instances);
        long l2 = System.currentTimeMillis() - l;
        long l3 = System.currentTimeMillis();
        evaluation.evaluateModel(this.m_Classifier, instances2);
        long l4 = System.currentTimeMillis() - l3;
        this.m_result = evaluation.toSummaryString();
        int n2 = 0;
        objectArray[n2++] = new Double(evaluation.numInstances());
        objectArray[n2++] = new Double(evaluation.meanAbsoluteError());
        objectArray[n2++] = new Double(evaluation.rootMeanSquaredError());
        objectArray[n2++] = new Double(evaluation.relativeAbsoluteError());
        objectArray[n2++] = new Double(evaluation.rootRelativeSquaredError());
        objectArray[n2++] = new Double(evaluation.correlationCoefficient());
        objectArray[n2++] = new Double(evaluation.SFPriorEntropy());
        objectArray[n2++] = new Double(evaluation.SFSchemeEntropy());
        objectArray[n2++] = new Double(evaluation.SFEntropyGain());
        objectArray[n2++] = new Double(evaluation.SFMeanPriorEntropy());
        objectArray[n2++] = new Double(evaluation.SFMeanSchemeEntropy());
        objectArray[n2++] = new Double(evaluation.SFMeanEntropyGain());
        objectArray[n2++] = new Double((double)l2 / 1000.0);
        objectArray[n2++] = new Double((double)l4 / 1000.0);
        objectArray[n2++] = this.m_Classifier instanceof Summarizable ? ((Summarizable)((Object)this.m_Classifier)).toSummaryString() : null;
        for (int i = 0; i < n; ++i) {
            if (this.m_doesProduce[i]) {
                try {
                    double d = ((AdditionalMeasureProducer)((Object)this.m_Classifier)).getMeasure(this.m_AdditionalMeasures[i]);
                    if (!Instance.isMissingValue(d)) {
                        Double d2 = new Double(d);
                        objectArray[n2++] = d2;
                        continue;
                    }
                    objectArray[n2++] = null;
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
                continue;
            }
            objectArray[n2++] = null;
        }
        if (n2 != 15 + n) {
            throw new Error("Results didn't fit RESULT_SIZE");
        }
        return objectArray;
    }

    public String classifierTipText() {
        return "The classifier to use.";
    }

    public Classifier getClassifier() {
        return this.m_Template;
    }

    public void setClassifier(Classifier classifier) {
        this.m_Template = classifier;
        this.updateOptions();
        System.err.println("RegressionSplitEvaluator: In set classifier");
    }

    protected void updateOptions() {
        this.m_ClassifierOptions = this.m_Template instanceof OptionHandler ? Utils.joinOptions(this.m_Template.getOptions()) : "";
        if (this.m_Template instanceof Serializable) {
            ObjectStreamClass objectStreamClass = ObjectStreamClass.lookup(this.m_Template.getClass());
            this.m_ClassifierVersion = "" + objectStreamClass.getSerialVersionUID();
        } else {
            this.m_ClassifierVersion = "";
        }
    }

    public void setClassifierName(String string) throws Exception {
        try {
            this.setClassifier((Classifier)Class.forName(string).newInstance());
        }
        catch (Exception exception) {
            throw new Exception("Can't find Classifier with class name: " + string);
        }
    }

    public String getRawResultOutput() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.m_Classifier == null) {
            return "<null> classifier";
        }
        stringBuffer.append(this.toString());
        stringBuffer.append("Classifier model: \n" + this.m_Classifier.toString() + '\n');
        if (this.m_result != null) {
            stringBuffer.append(this.m_result);
            if (this.m_doesProduce != null) {
                for (int i = 0; i < this.m_doesProduce.length; ++i) {
                    if (!this.m_doesProduce[i]) continue;
                    try {
                        double d = ((AdditionalMeasureProducer)((Object)this.m_Classifier)).getMeasure(this.m_AdditionalMeasures[i]);
                        if (!Instance.isMissingValue(d)) {
                            Double d2 = new Double(d);
                            stringBuffer.append(this.m_AdditionalMeasures[i] + " : " + d2 + '\n');
                            continue;
                        }
                        stringBuffer.append(this.m_AdditionalMeasures[i] + " : " + '?' + '\n');
                        continue;
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                    }
                }
            }
        }
        return stringBuffer.toString();
    }

    public String toString() {
        String string = "RegressionSplitEvaluator: ";
        if (this.m_Template == null) {
            return string + "<null> classifier";
        }
        return string + this.m_Template.getClass().getName() + " " + this.m_ClassifierOptions + "(version " + this.m_ClassifierVersion + ")";
    }
}

