% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohort.CI.R
\name{cohort.CI}
\alias{cohort.CI}
\title{Bootstrapped confidence intervals - Cohort}
\usage{
cohort.CI(transMatrix,initCount,nMonths,nStates,sim)
}
\arguments{
\item{transMatrix}{list of 12 average monthly credit transitions.}

\item{initCount}{list of 12 average monthly initial counts (start vector).}

\item{nMonths}{number of months in the horizon}

\item{nStates}{number of rating categories.}

\item{sim}{number of simulations}
}
\value{
Returns the default probabilites values for the \emph{n} ratings at the 2.5, 5, 25, 50, 75, 95, 97.5 percentiles.
}
\description{
estimate confidence intervals for the transition probabilities using a bootstrapping procedure for cohort method.
}
\details{
The general idea of bootstrapping is to use resampling methods to estimate features of the sampling distribution of
an estimator, especially in situations where 'asymptotic approximations' may provide poor results. In the case of a
\emph{parametric} bootstrap method one samples from the estimated distribution derived using maximum likelihood estimation.
In summary,

\enumerate{
\item Estimate the distribution from the observed sample using maximum likelihood
\item Draw samples from the estimated distribution
\item Calculate the parameter of interest from each of the samples
\item Construct an empirical distribution for the parameter of interest
\item Select percentiles from the empirical distribution
}

One can contrast this method with a \emph{nonparametric bootstrap} in which one samples with replacement from the
empirical cumulative distribution function of the observed sample. Since there are grades with zero observed default
rates, resampling directly from the observed data will not produce meaningful confidence intervals in for credit transition
matrices where historically there are a limited number of defaults in higher credit quality buckets.

The parametric bootstrap method modeled here generates 12-month paths for each obligor represented in the portfolio and
estimates the 12 monthly transition matrices to get a single observation. Annual paths (histories) are simulated using
the estimated monthly transition matrices. A consequence of this approach, is that it is computationally intensive, but once
the bootstrapped distributions of the PD values have been completed, it is simple to identify the percentiles of interest
for calculation of confidence intervals
}
\examples{

sim <- 1000                                 #number of simulation
nMonths <- 12                               #number of month in horizon (default=12)
nStates <- 8                                #number of ratings categories
initCount <- c(5,10,15,20,20,20,15,5)       #start vector (vector of initial counts)
\dontrun{
tolerance <-cohort.CI(transMat,initCount,nMonths,nStates,sim)
}
}
\references{
Hanson, S. and Schuermann, T. 2005 Confidence Intervals for Probabilities of Default,
Federal Reserve Bank of New York

Jafry, Y. and Schuermann, T. 2003 Metrics for Comparing Credit Migration Matrices,
Wharton Financial Institutions Working Paper 03-08.

Loffler, G., P. N. Posch. 2007 Credit Risk Modeling Using Excel and VBA.
West Sussex, England, Wiley Finance
}
\author{
Abdoulaye (Ab) N'Diaye
}
