\name{cross_validate}
\alias{cross_validate}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
used for cross-validation of various algorithms.
}
\description{
Performs n-fold cross-validation of specified algorithm.
}
\usage{
cross_validate(corpus, nfold, algorithm = c("SVM", "SLDA", "BOOSTING", 
"BAGGING", "RF", "GLMNET", "TREE", "NNET", "MAXENT"), seed = NA, 
method = "C-classification", cross = 0, cost = 100, kernel = "radial", 
maxitboost = 100, maxitglm = 500, size = 1, maxitnnet = 1000, MaxNWts = 10000, 
rang = 0.1, decay = 5e-04, ntree = 200, l1_regularizer = 0, l2_regularizer = 0, 
use_sgd = FALSE, set_heldout = 0, verbose = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{corpus}{
Class of type \code{\link{matrix_container-class}} generated by the \code{\link{create_corpus}} function.
}
  \item{nfold}{
Number of folds to perform for cross-validation.
}
  \item{algorithm}{
A string specifying which algorithm to use. Use \code{\link{print_algorithms}} to see a list of options. 
}
  \item{seed}{
Random seed number used to replicate cross-validation results. 
}
  \item{method}{
Method parameter for SVM implentation. See \pkg{e1071} documentation for more details.
}
  \item{cross}{
Cross parameter for SVM implentation. See \pkg{e1071} documentation for more details.
}
  \item{cost}{
Cost parameter for SVM implentation. See \pkg{e1071} documentation for more details.
}
  \item{kernel}{
Kernel parameter for SVM implentation. See \pkg{e1071} documentation for more details.
}
  \item{maxitboost}{
Maximum iterations parameter for boosting implentation. See \pkg{caTools} documentation for more details.
}
  \item{maxitglm}{
Maximum iterations parameter for glmnet implentation. See \pkg{glmnet} documentation for more details.
}
  \item{size}{
Size parameter for neural networks implentation. See \pkg{nnet} documentation for more details.
}
  \item{maxitnnet}{
Maximum iterations for neural networks implentation. See \pkg{nnet} documentation for more details.
}
  \item{MaxNWts}{
Maximum number of weights parameter for neural networks implentation. See \pkg{nnet} documentation for more details.
}
  \item{rang}{
Range parameter for neural networks implentation. See \pkg{nnet} documentation for more details.
}
  \item{decay}{
Decay parameter for neural networks implentation. See \pkg{nnet} documentation for more details.
}
  \item{ntree}{
Number of trees parameter for RandomForests implentation. See \pkg{randomForest} documentation for more details.
}
  \item{l1_regularizer}{
An \code{numeric} turning on L1 regularization and setting the regularization parameter. A value of 0 will disable L1 regularization. See \pkg{maxent} documentation for more details.
}
  \item{l2_regularizer}{
An \code{numeric} turning on L2 regularization and setting the regularization parameter. A value of 0 will disable L2 regularization. See \pkg{maxent} documentation for more details.
}
  \item{use_sgd}{
A \code{logical} indicating that SGD parameter estimation should be used. Defaults to \code{FALSE}. See \pkg{maxent} documentation for more details.
}
  \item{set_heldout}{
An \code{integer} specifying the number of documents to hold out. Sets a held-out subset of your data to test against and prevent overfitting. See \pkg{maxent} documentation for more details.
}
  \item{verbose}{
A \code{logical} specifying whether to provide descriptive output about the training process. Defaults to \code{FALSE}, or no output. See \pkg{maxent} documentation for more details.
}
}

\author{
Loren Collingwood <lorenc2@uw.edu>, Timothy P. Jurka <tpjurka@ucdavis.edu>
}

\examples{
library(RTextTools)
data <- read_data(system.file("data/NYTimes.csv.gz",package="RTextTools"),type="csv")
data <- data[sample(1:3100,size=100,replace=FALSE),]
matrix <- create_matrix(cbind(data$Title,data$Subject), language="english", 
removeNumbers=TRUE, stemWords=FALSE, weighting=weightTfIdf)
corpus <- create_corpus(matrix,data$Topic.Code,trainSize=1:75, testSize=76:100, 
virgin=FALSE)
svm <- cross_validate(corpus,2,algorithm="SVM")
maxent <- cross_validate(corpus,2,algorithm="MAXENT")
}
\keyword{method}
