% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RTestCollection.R
\docType{methods}
\name{getRTMInMatrixShape}
\alias{getRTMInMatrixShape}
\alias{getRTMInMatrixShape,RTestCollection-method}
\title{Get RTM for all executed test cases in a matrix shape}
\usage{
\S4method{getRTMInMatrixShape}{RTestCollection}(object, test.TCs = NULL,
  type = "function", ...)
}
\arguments{
\item{object}{(\code{object}) The \code{\link{RTestCollection-class}} object.}

\item{test.TCs}{(\code{character}) Vector with the TCs to be executed or NULL if all 
all TCs of the collection should be tested.}

\item{type}{(\code{character}) Type of the returned matrix, either 'function'  or
'risk'.}

\item{...}{Additional arguments passed to \code{getRTM}.}
}
\value{
(\code{data.frame}) The RTM as \code{data.frame} table object.
}
\description{
This method returns the requirement traceability matrix (RTM) in matrix representation for all 
imported test cases of the test case collection. Thereby, the matrix can be created for the
relationship function to test case or risk to test case.
}
\seealso{
\code{\link{RTestCollection-class}}
}
\author{
Matthias Pfeifer \email{matthias.pfeifer@roche.com}
}
