% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RTSA_plot.R
\name{plot.RTSA}
\alias{plot.RTSA}
\title{Plot RTSA object. Returns the R version of the original TSA plot.}
\usage{
\method{plot}{RTSA}(x, model = "random", type = "classic", theme = "classic", ...)
}
\arguments{
\item{x}{RTSA object}

\item{model}{Whether a fixed- or random-effects meta-analysis should be used. Defaults to random.}

\item{type}{Should Z-scores (classic) or outcome values (outcome) be plotted.}

\item{theme}{Whether the theme is traditional TSA (classic) or modern (modern)}

\item{...}{Other arguments to plot.RTSA}
}
\value{
Plot. Either a plot for two sided testing or one-sided
}
\description{
Plot RTSA object. Returns the R version of the original TSA plot.
}
\examples{
data(perioOxy)
outRTSA <- RTSA(type = "analysis", data = perioOxy, outcome = "RR", mc = 0.8,
 side = 2, alpha = 0.05, beta = 0.2, fixed = FALSE, es_alpha = "esOF", design = NULL)
plot(x = outRTSA)

}
