% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swapIRS.R
\name{swapIRS}
\alias{swapIRS}
\title{Interest Rate Swap}
\usage{
swapIRS(
  trade.date = lubridate::today(),
  eff.date = lubridate::today() + 2,
  mat.date = lubridate::today() + 2 + lubridate::years(2),
  notional = 1e+06,
  PayRec = "Rec",
  fixed.rate = 0.05,
  float.curve = usSwapCurves,
  reset.freq = 3,
  disc.curve = usSwapCurves,
  convention = c("act", 360),
  bus.calendar = "NY",
  output = "price"
)
}
\arguments{
\item{trade.date}{Date object. Defaults to today(). \code{Date}}

\item{eff.date}{Date object. Defaults to today() + 2 days. \code{Date}}

\item{mat.date}{Date object. Defaults to today() + 2 years. \code{Date}}

\item{notional}{Numeric value of notional. Defaults to 1,000,000. \code{numeric}}

\item{PayRec}{"Pay" or "Rec" fixed. \code{character}}

\item{fixed.rate}{Numeric fixed interest rate. Defaults to 0.05. \code{Date}}

\item{float.curve}{List of interest rate curves. Defaults to data("usSwapCurves"). \code{list}}

\item{reset.freq}{Numeric where 1 = "monthly", 3 = quarterly, 6 = Semi annual 12 = yearly. \code{character}}

\item{disc.curve}{List of interest rate curves. Defaults to data("usSwapCurves"). \code{list}}

\item{convention}{Vector of convention e.g. c("act",360) c(30,360),... \code{character}}

\item{bus.calendar}{Banking day calendar. Not implemented.}

\item{output}{"price" for swap price or "all" for price, cash flow data frame, duration. \code{character}}
}
\value{
List of swap price, cash flow data frame, duration. \code{list}
}
\description{
Computes the mark to market of an IRS
}
\examples{
data("usSwapCurves")
swapIRS(
  trade.date = as.Date("2020-01-04"), eff.date = as.Date("2020-01-06"),
  mat.date = as.Date("2022-01-06"), notional = 1000000,
  PayRec = "Rec", fixed.rate = 0.05, float.curve = usSwapCurves, reset.freq = 3,
  disc.curve = usSwapCurves, convention = c("act", 360),
  bus.calendar = "NY", output = "all"
)
}
\author{
Philippe Cote
}
