% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morningstar.R
\name{getPrices}
\alias{getPrices}
\title{Morningstar Commodities API multiple calls}
\usage{
getPrices(
  feed = "CME_NymexFutures_EOD",
  contracts = c("CL9Z", "CL0F", "CL0M"),
  from = "2019-01-01",
  iuser = "x@xyz.com",
  ipassword = "pass"
)
}
\arguments{
\item{feed}{Morningstar Feed Table. \code{character}}

\item{contracts}{Symbols vector. \code{character}}

\item{from}{From date yyyy-mm-dd. \code{character}}

\item{iuser}{Morningstar user name as character - sourced locally in examples. \code{character}}

\item{ipassword}{Morningstar user password as character - sourced locally in examples. \code{character}}
}
\value{
wide data frame. \code{tibble}
}
\description{
Multiple Morningstar API calls using getPrice functions.
Refer to \code{getPrices()} for list of currently supported data feeds.
}
\examples{
\dontrun{
getPrices(
  feed = "CME_NymexFutures_EOD", contracts = c("@CL0Z", "@CL1F", "@CL21H", "@CL21Z"),
  from = "2020-01-01", iuser = username, ipassword = password
)
}

}
\author{
Philippe Cote
}
