#' Genomic data linked to saline lagoons.
#'
#' A dataset containing genomic data of 544 genomes that matched 16s rRNA data from saline lagoons of the Monegros desert area.
#'
#' @format A data frame with 544 rows and 14 variables:
#' \describe{
#'   \item{genome}{Genome IMG code}
#'   \item{Genome_Size}{Genome size}
#'   \item{GC_perc}{GC percentage}
#'   \item{Coding_base_perc}{Conding base percentage}
#'   \item{CDS_perc}{CDS percentage}
#'   \item{RNA_perc}{RNA percentage}
#'   \item{rRNA_count}{rRNA count}
#'   \item{Transporter_perc}{Transporter proteins percentage}
#'   \item{Signal_peptide_perc}{Signal peptide percentage}
#'   \item{Transmembrane_perc}{Transmembrane proteins percentage}
#'   \item{Gene_Count}{Gene count}
#'   \item{min_env}{Minimum environmental value where the organism has been observed}
#'   \item{max_env}{Minimum environmental value where the organism has been observed}
#'   \item{rel_abundance}{Relative abundance of the organism on the metacommunity}
#'
#'   ...
#' }
#' @source {Triadó-Margarit, X., Capitán, J.A., Menéndez-Serra, M. et al. A Randomized Trait Community Clustering approach to unveil consistent environmental thresholds in community assembly. ISME J 13, 2681–2689 (2019).}
"group_information"
