% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{can.plot}
\alias{can.plot}
\title{Plotting canton-level maps of Switzerland}
\usage{
can.plot(bfs_id, data, year, add_geodata_path = ".", endofyear = FALSE,
  cantons = NULL, lakes = "all", boundaries = "c",
  boundaries_size = 0.2, boundaries_color = "white", extrema = "global",
  continuous = TRUE, color_continuous = c("#fee5d9", "#a50f15"),
  color_discrete = c("seq", "1"), color_na = "gray90", title = NULL,
  subtitle = NULL, caption = NULL, legend_title = NULL,
  legend_position = "bottom", save = FALSE, filename = "can_plot.png",
  dpi = 300, width = NA, heigth = NA, units = "cm")
}
\arguments{
\item{bfs_id}{a numeric vector with canton identification numbers as used by the Swiss Federal
Statistical Office corresponding to \code{data}.  For templates, see \code{\link{can.template}}.}

\item{data}{a vector of data at canton-level.}

\item{year}{numeric. Indicates what map version to plot. Available with package: \code{2016}. For additional
geodata, see: \code{map.load}.}

\item{add_geodata_path}{a character string with the path to the folder where additional geodata is saved.}

\item{endofyear}{if \code{TRUE}, administrative boundaries as by December 31 of \code{year} are
plotted. Available: \code{year > 2010}.}

\item{cantons}{input either numeric (canton identification numbers) or character (canton abbreviations)
vector to plot district of selected cantons.}

\item{lakes}{input either numeric (lake identification numbers) or character (lakes names) vector to
plot selected lakes. If \code{"none"}, no lakes are plotted.
If \code{"all"}, all available lakes are plotted.}

\item{boundaries}{character vector naming the boundaries to map.\itemize{
\item "c": canton boundaries
\item "n": national boundaries}}

\item{boundaries_size}{numeric vector that specifies the size of the corresponding element in \code{boundaries}.}

\item{boundaries_color}{character vector that specifies the color of the corresponding element
in \code{boundaries}.}

\item{extrema}{if \code{local}, data of municipalities that are not selected by \code{cantons} is not
considered in the color scaling process.}

\item{continuous}{set to \code{FALSE}, if \code{data} is non-continuous.}

\item{color_continuous}{character vector with 2 elements to specifiy the plot color if \code{continuous =
TRUE}. \code{color_continuous = c(low, high)} resulting in a two color gradient from color
\code{low} to color \code{high}.}

\item{color_discrete}{character vector with 2 elements to specifiy the plot color if \code{continuous = FALSE}.
  \code{color_discrete = c(type, palette)} resulting in a color scheme from
  \href{http://colorbrewer2.org}{ColorBrewer} that are particularly well suited to display discrete
  values on a map.\itemize{
\item \code{type}: one of seq (sequential), div (diverging) or qual (qualitative)
\item \code{palette}: index into the list of palettes of appropriate \code{type}; character needed!}}

\item{color_na}{color of missing values.}

\item{title, subtitle, caption, legend_title}{text for titles or caption below the plot.}

\item{legend_position}{the position of the legend ("none", "left", "right", "bottom", "top")}

\item{save}{if \code{TRUE}, the plot will be saved to disk.}

\item{filename}{file name to create on disk incl. image file format (".jpeg", ".png", ".tiff", etc.).}

\item{dpi}{plot resolution. Applies only to raster output types.}

\item{width, heigth, units}{plot size in units ("in", "cm", or "mm"). If not supplied, uses the size of current graphics device.}
}
\description{
\code{can.plot} offers the possbility to visualise Swiss canton-level data on a map.
    It uses the geodata that is made publicly available by the
    \href{https://www.bfs.admin.ch/bfs/en/home.html}{Swiss Federal Statistical Office}.  Geodata
    is available for the period between \code{2001} to \code{2017}.  The argument \code{cantons} makes
    it easy to plot customised maps. The function \code{\link{can.template}} provides templates
    for data collection.
}
\examples{
 # Generating sample data:
 dt <- can.template(2016)
 for(i in 1:nrow(dt)){dt$values[i] <- sample(c(300:700), 1)/1000}

 # Plotting sample data:
 can.plot(dt$bfs_nr, dt$values, 2016)
}
