% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EditFunction.R
\name{EditFunction}
\alias{EditFunction}
\title{GUI: Function Editor}
\usage{
EditFunction(cols, index = NULL, fun = NULL, value.length = NULL,
  value.class = NULL, win.title = "Edit Function", parent = NULL)
}
\arguments{
\item{cols}{list.
y}

\item{index}{integer.
An element index number in \code{cols}.}

\item{fun}{character.
Existing function, only used if \code{index = NULL}}

\item{value.length}{integer.
Required length for the evaluated function.}

\item{value.class}{character.
Required class for the evaluated function.}

\item{win.title}{character.
String to display as the title of the dialog box.}

\item{parent}{tkwin.
\acronym{GUI} parent window}
}
\value{
Returns an object of class list with the following components:
  \item{fun}{user defined function (when evaluated, this string must be parseable).}
  \item{class}{object class for the evaluated function.}
  \item{summary}{default summary for the evaluated function.}
  \item{sample}{first non-missing value for the evaluated function.}
}
\description{
A graphical user interface (\acronym{GUI}) for defining functions in the \R language.
}
\details{
This \acronym{GUI} is appropriate for deriving new variables in a pre-existing data frame or query building.
}
\examples{
\dontrun{
  d <- list(x = 1:10, y = 10:1)
  Data("data.raw", d)
  cols <- list()
  cols[[1]] <- list(id = "X", index = 1, fun = "\\"X\\"")
  cols[[2]] <- list(id = "Y", index = 2, fun = "\\"Y\\"")
  cols[[3]] <- list(id = "New Variable", fun = "\\"X\\" + \\"Y\\"")
  EditFunction(cols, index = 3)
}

}
\seealso{
\code{\link{EvalFunction}}
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{misc}
