% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07_api_sysreqs.R
\name{sysreqs_install}
\alias{sysreqs_install}
\title{Updates system to satisfy detected requirements.}
\usage{
sysreqs_install(prj = NULL)
}
\arguments{
\item{prj}{project object to handle sys requirements for. If not passed the
loaded project will be used  or the default whichever exists. Will init
default project from the working directory if no default project exists.
(type: rsuite_project, default: NULL)}
}
\description{
Collects system requirements with \code{\link{sysreqs_collect}}
and builds/installs them.
}
\examples{
# create exemplary project base folder
prj_base <- tempfile("example_")
dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

# start project
prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

# add dependency to XML
write("library(XML)",
      file = file.path(prj$path, "R", "master.R"),
      append = TRUE)

\donttest{
  # check if requirements of XML are satisfied
  sysreqs_install(prj)
}

}
\seealso{
Other in SYSREQS: \code{\link{sysreqs_check}},
  \code{\link{sysreqs_collect}}
}
\concept{in SYSREQS}
