% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_api_pkgzip.R
\name{pkgzip_build_bioc_package}
\alias{pkgzip_build_bioc_package}
\title{Builds PKGZIP out of a package on Bioconductor}
\usage{
pkgzip_build_bioc_package(repo, ..., prj = NULL,
  pkg_type = .Platform$pkgType, path = getwd(), with_deps = FALSE,
  filter_repo = NULL, skip_build_steps = NULL, keep_sources = FALSE)
}
\arguments{
\item{repo}{repository address in format [username:password@][release/]repo[#revision]. See
\code{devtools::install_bioc} for more information.}

\item{...}{Bioconductor specific parameters passed to \code{devtools::install_bioc}.}

\item{prj}{project object to use. If not passed will init project from
working directory. (type: rsuite_project, default: NULL)}

\item{pkg_type}{type of packages to build (type: character, default: platform default)}

\item{path}{folder path to put output zip into. The folder must exist.
(type: character: default: \code{getwd()})}

\item{with_deps}{If TRUE will include dependencies pkgs dependencies into final zip.
(type: logical, default: FALSE)}

\item{filter_repo}{repository address to not include dependencies available in.
If NULL will not filter dependencies. Will be omitted if with_deps is FALSE.
(type: character(1), default: NULL)}

\item{skip_build_steps}{character vector with steps to skip while building
   project packages. Can contain following entries:
\describe{
  \item{specs}{Process packages specifics}
  \item{docs}{Try build documentation with roxygen}
  \item{imps}{Perform imports validation}
  \item{tests}{Run package tests}
  \item{rcpp_attribs}{Run rppAttribs on the package}
  \item{vignettes}{Build package vignettes}
}
(type: character(N), default: NULL).}

\item{keep_sources}{if TRUE downloaded package sources will not be removed
after building. (type: logical, default: FALSE)}
}
\value{
created pkgzip file path (invisible).
}
\description{
Loads package from the Bioconductor repository, packages it into package file and builds
a PKGZIP out of it. It uses the project to detect repositories to look for dependencies
and to detect rversion if required.
}
\details{
Logs all messages onto rsuite logger. Use \code{logging::setLevel} to control logs
verbosity.
}
\examples{
\donttest{
  # create exemplary project base folder
  prj_base <- tempfile("example_")
  dir.create(prj_base, recursive = TRUE, showWarnings = FALSE)

  # start project
  prj <- prj_start("my_project", skip_rc = TRUE, path = prj_base)

  # build PKGZIP with logging package from cran repository
  pkgzip_fpath <- pkgzip_build_bioc_package("BiocGenerics", prj = prj, path = tempdir())

  # list content of pkgzip created
  unzip(pkgzip_fpath, list = TRUE)
}

}
\seealso{
Other in PKGZIP building: \code{\link{pkgzip_build_ext_packages}},
  \code{\link{pkgzip_build_github_package}},
  \code{\link{pkgzip_build_package_files}},
  \code{\link{pkgzip_build_prj_packages}}
}
