% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/27_repo_manager.R
\name{repo_manager_init}
\alias{repo_manager_init}
\title{Initializes managed repository structure.}
\usage{
repo_manager_init(repo_manager, types)
}
\arguments{
\item{repo_manager}{repo manager object}

\item{types}{package types for which repository should be initialized.
If missing all project supported package types will be initialized (type: character)}
}
\value{
TRUE if initialized repository for at least one type, FALSE if
  the structure was fully initialized already. (type:logical, invisible)
}
\description{
Initializes managed repository structure.
}
\examples{
# create you own Repo adapter
repo_adapter_create_own <- function() {
  result <- repo_adapter_create_base("Own")
  class(result) <- c("repo_adapter_own", class(result))
  return(result)
}

#' create own repo manager
#' @export
repo_adapter_create_manager.repo_adapter_own <- function(repo_adapter, ...) {
  repo_manager <- list() # create you own repo manager
  class(repo_manager) <- c("repo_manager_own", "rsuite_repo_manager")
  return(repo_manager)
}

#' @export
repo_manager_init.repo_manager_own <- function(repo_manager, types) {
  was_inited_already <- TRUE
  # ... if repository structure was not initialized initialize it  ...
  return(invisible(was_inited_already))
}

}
\seealso{
Other in extending RSuite with Repo adapter: \code{\link{repo_adapter_create_base}},
  \code{\link{repo_adapter_create_manager}},
  \code{\link{repo_adapter_get_info}},
  \code{\link{repo_adapter_get_path}},
  \code{\link{repo_manager_destroy}},
  \code{\link{repo_manager_get_info}},
  \code{\link{repo_manager_remove}},
  \code{\link{repo_manager_upload}}
}
