% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encodeQA.R
\name{encodeQA}
\alias{encodeQA}
\title{Encode QA Conditions to Integers}
\usage{
encodeQA(
  fill = "no",
  terrainOcclusion = "no",
  radSaturation = "na",
  cloudMask = "all",
  cloud = "all",
  cloudShadow = "all",
  snow = "all",
  cirrus = "all",
  droppedPixel = "no",
  water = "all",
  droppedFrame = "no",
  sensor = "OLI",
  legacy = "collection1"
)
}
\arguments{
\item{fill}{Designated fill. Options: \code{c("yes", "no", "all")}.}

\item{terrainOcclusion}{Terrain induced occlusion. Options: \code{c("yes", "no", "all")}.}

\item{radSaturation}{Number of bands that contain radiometric saturation. Options: \code{c("na", "low", "med", "high", "all")} for no bands, 1-2 bands, 3-4 bands, 5 or more bands contain saturation.}

\item{cloudMask}{Cloud mask. Options: \code{c("yes", "no", "all")}.}

\item{cloud}{Cloud confidence. Options: \code{c("na", "low", "med", "high", "all")}.}

\item{cloudShadow}{Cloud shadow confidence. Options: \code{c("yes", "no", "all")}.}

\item{snow}{Snow / ice confidence.  Options: \code{c("na", "low", "med", "high", "all")}.}

\item{cirrus}{Cirrus confidence.  Options: \code{c("na", "low", "med", "high", "all")}.}

\item{droppedPixel}{Dropped pixel. Options: \code{c("yes", "no", "all")}.}

\item{water}{Water confidence. Options: \code{c("na", "low", "med", "high", "all")}.}

\item{droppedFrame}{Dropped frame. Options: \code{c("yes", "no", "all")}.}

\item{sensor}{Sensor to encode. Options: \code{c("OLI", "TIRS", "ETM+", "TM", "MSS")}.}

\item{legacy}{Encoding systematic Options: \code{c("collection1", "pre_collection")}. Default is "collection1" for the Landsat Collection 1 8-bit quality designations. Use "pre_collection" for imagery downloaded before the Collection 1 quality designations were introduced}
}
\value{
Returns the Integer value for the QA values
}
\description{
Intended for use with Landsat 16-bit QA bands. Converts pixel quality flags from human readable to integer, which can then be used to 
subset a QA image. Please be aware of the default settings which differ for different parameters. 
Depending on, which \code{sensor} and \code{legacy} is selected, some quality parameters are not used, since the sequences of available bitwise quality designations differ per sensor and collection.
}
\note{
Only currently populated bits are available as arguments.
}
\examples{
encodeQA(snow = "low", cirrus = c("med", "high"), cloud = "high")
}
\references{
\url{https://www.usgs.gov/landsat-missions/landsat-collection-1-level-1-quality-assessment-band} for Collection 1 quality designations (\code{legacy = "collection1"})
}
