% Generated by roxygen2 (4.0.2): do not edit by hand
\name{GetRealTimeReport}
\alias{GetRealTimeReport}
\title{Get Real-Time report}
\usage{
GetRealTimeReport(reportsuite.ids, metrics, elements = c(),
  date.granularity = 5, date.from = "1 hour ago", date.to = "now",
  sort.algorithm = "mostpopular", floor.sensitivity = 0.25,
  first.rank.period = 0, algorithm.argument = "linear",
  everything.else = TRUE, selected = c())
}
\arguments{
\item{reportsuite.ids}{Report Suite}

\item{metrics}{Report metric}

\item{elements}{Report breakdowns}

\item{date.granularity}{Report Granularity. Defaults to 5 minutes}

\item{date.from}{Report starting time. Defaults to "1 hour ago"}

\item{date.to}{Report end time. Defaults to "now"}

\item{sort.algorithm}{Sorting algorithm. Defaults to "mostpopular"}

\item{floor.sensitivity}{Floor sensitivity. Defaults to .25}

\item{first.rank.period}{First Ranking Period. Defaults to 0}

\item{algorithm.argument}{Ranking algorithm. Defaults to "linear"}

\item{everything.else}{Provide counts for elements not returned as 'top'}

\item{selected}{Selected items for a given element (only works for a single element)}
}
\value{
Data frame
}
\description{
Function to access the Adobe Analytics Real-Time API v1.4. This API
provides the ability for reporting up to the most recent minute. This API is best
used at 15-30 second intervals (or longer).
}
\details{
The Real-Time API uses a concept of "relative dates". To get a feeling for
what's possible for submitting to date.from and date.to parameters, see link at:

http://php.net/manual/en/datetime.formats.relative.php
}
\examples{
\dontrun{

custom_report <- GetRealTimeReport('')

}
}

