% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LeastSquaresClassifier.R
\name{LeastSquaresClassifier}
\alias{LeastSquaresClassifier}
\title{Least Squares Classifier}
\usage{
LeastSquaresClassifier(X, y, lambda = 0, intercept = TRUE,
  x_center = FALSE, scale = FALSE, method = "inverse", y_scale = FALSE)
}
\arguments{
\item{X}{matrix; Design matrix for labeled data}

\item{y}{factor or integer vector; Label vector}

\item{lambda}{Regularization parameter of the l2 penalty}

\item{intercept}{TRUE if an intercept should be added to the model}

\item{x_center}{TRUE, whether the dependent variables (features) should be centered}

\item{scale}{If TRUE, apply a z-transform to the design matrix X before running the regression}

\item{method}{Method to use for fitting. One of c("inverse","Normal","QR","BFGS")}

\item{y_scale}{If True scale the target vector}
}
\value{
S4 object of class LeastSquaresClassifier with the following slots:
\item{theta}{weight vector}
\item{classnames}{the names of the classes}
\item{modelform}{formula object of the model used in regression}
\item{scaling}{a scaling object containing the paramters of the z-transforms applied to the data}
}
\description{
Classifier that minimizes the quadratic loss or, equivalently, least squares regression applied to a numeric encoding of the class labels as target. Note this method minimizes quadratic loss, not the truncated quadratic loss. Optionally, L2 regularization can be applied by setting the \code{lambda} parameter.
}
\seealso{
Other RSSL classifiers: \code{\link{EMLeastSquaresClassifier}},
  \code{\link{EMLinearDiscriminantClassifier}},
  \code{\link{GRFClassifier}},
  \code{\link{ICLeastSquaresClassifier}},
  \code{\link{ICLinearDiscriminantClassifier}},
  \code{\link{KernelLeastSquaresClassifier}},
  \code{\link{LaplacianKernelLeastSquaresClassifier}},
  \code{\link{LaplacianSVM}},
  \code{\link{LinearDiscriminantClassifier}},
  \code{\link{LinearSVM}}, \code{\link{LinearTSVM}},
  \code{\link{LogisticLossClassifier}},
  \code{\link{LogisticRegression}},
  \code{\link{MCLinearDiscriminantClassifier}},
  \code{\link{MCNearestMeanClassifier}},
  \code{\link{MCPLDA}},
  \code{\link{MajorityClassClassifier}},
  \code{\link{NearestMeanClassifier}},
  \code{\link{QuadraticDiscriminantClassifier}},
  \code{\link{S4VM}}, \code{\link{SVM}},
  \code{\link{SelfLearning}}, \code{\link{TSVM}},
  \code{\link{USMLeastSquaresClassifier}},
  \code{\link{WellSVM}}, \code{\link{svmlin}}
}
