% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym_regression.R
\name{sym.svm}
\alias{sym.svm}
\title{Symbolic Support Vector Machines Regression}
\usage{
sym.svm(
  formula,
  sym.data,
  method = c("cm", "crm"),
  scale = TRUE,
  kernel = "radial"
)
}
\arguments{
\item{formula}{a symbolic description of the model to be fit.}

\item{sym.data}{symbolic data.table}

\item{method}{method}

\item{scale}{A logical vector indicating the variables to be scaled. If scale is of length 1, the value is recycled as many times as needed. Per default, data are scaled internally (both x and y variables) to zero mean and unit variance. The center and scale values are returned and used for later predictions.}

\item{kernel}{the kernel used in training and predicting. You might consider changing some of the following parameters, depending on the kernel type.}
}
\description{
Symbolic Support Vector Machines Regression
}
\references{
Lima-Neto, E.A., De Carvalho, F.A.T., (2008). Centre and range method to fitting a linear regression model on symbolic interval data. Computational Statistics and Data Analysis52, 1500-1515


Lima-Neto, E.A., De Carvalho, F.A.T., (2010). Constrained linear regression models for symbolic interval-valued variables.  Computational Statistics and Data Analysis 54, 333-347


Lima Neto, E.d.A., de Carvalho, F.d.A.T. Nonlinear regression applied to interval-valued data. Pattern Anal Applic 20, 809–824 (2017). https://doi.org/10.1007/s10044-016-0538-y


Rodriguez, O. (2018). Shrinkage linear regression for symbolic interval-valued variables.Journal MODULAD 2018, vol. Modulad 45, pp.19-38
}
