% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r2.R
\name{R2.U}
\alias{R2.U}
\title{Upper boundary correlation coefficient.}
\usage{
R2.U(ref, pred)
}
\arguments{
\item{ref}{Variable that was predicted.}

\item{pred}{The prediction given by the model.}
}
\value{
The upper boundary correlation coefficient.
}
\description{
Compute the upper boundary correlation coefficient for two interval variables.
}
\examples{
data(int_prost_train)
data(int_prost_test)
res.cm <- sym.lm(lpsa ~ ., sym.data = int_prost_train, method = "cm")
pred.cm <- sym.predict(res.cm, int_prost_test)
R2.U(int_prost_test$lpsa, pred.cm$Fitted)
}
\references{
LIMA-NETO, E.A., DE CARVALHO, F.A.T., (2008). Centre and range method
to fitting a linear regression model on symbolic interval data. Computational
Statistics and Data Analysis 52, 1500-1515.

LIMA-NETO, E.A., DE CARVALHO, F.A.T., (2010). Constrained linear regression models
for symbolic interval-valued variables. Computational Statistics and
Data Analysis 54, 333-347.
}
\seealso{
sym.glm
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{correlation}
\keyword{upper}
