% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sym.interval.pca.R
\name{sym.interval.pca}
\alias{sym.interval.pca}
\title{Interval Principal Components Analysis.}
\usage{
sym.interval.pca(sym.data, method = c('classic', 'tops','centers',
'principal.curves', 'optimized.distance', 'optimized.variance'))
}
\arguments{
\item{sym.data}{Shoud be a symbolic data table}

\item{method}{It is use so select the method, 'classic' execute a classical principal component
analysis over the centers of the intervals, 'tops' to use the vertices algorithm
and 'centers' to use the centers algorithm.}
}
\value{
Sym.Components: This a symbolic data table with the interval principal components. As
this is a symbolic data table we can apply over this table any other symbolic data
analysis method (symbolic propagation).

Sym.Prin.Correlations: This is the interval correlations between the original interval
variables and the interval principal components, it can be use to plot the symbolic
circle of correlations.
}
\description{
Cazes, Chouakria, Diday and Schektman (1997)
proposed the Centers and the Tops Methods to extend the well known principal
components analysis method to a particular kind of symbolic objects
characterized by multi--values variables of interval type.
}
\examples{
\dontrun{
data(oils)
res<-sym.interval.pca(oils,'centers')
class(res) <- c('sym.data.table')
sym.scatterplot(res$Sym.Components[,1],res$Sym.Components[,1],
                labels=TRUE,col='red',main='PCA Oils Data')
sym.scatterplot3d(res$Sym.Components[,1],res$Sym.Components[,2],
                  res$Sym.Components[,3],color='blue',main='PCA Oils Data')
sym.scatterplot.ggplot(res$Sym.Components[,1],res$Sym.Components[,2],
                       labels=TRUE)
sym.circle.plot(res$Sym.Prin.Correlations)

res<-sym.interval.pca(oils,'classic')
plot(res,choix='ind')
plot(res,choix='var')

data(lynne2)
res<-sym.interval.pca(lynne2,'centers')
class(res$Sym.Components) <- c('sym.data.table')
sym.scatterplot(res$Sym.Components[,1],res$Sym.Components[,2],
                labels=TRUE,col='red',main='PCA Lynne Data')
sym.scatterplot3d(res$Sym.Components[,1],res$Sym.Components[,2],
                  res$Sym.Components[,3],color='blue', main='PCA Lynne Data')
sym.scatterplot.ggplot(res$Sym.Components[,1],res$Sym.Components[,2],
                       labels=TRUE)
sym.circle.plot(res$Sym.Prin.Correlations)

data(StudentsGrades)
st<-StudentsGrades
s.pca<-sym.interval.pca(st)
plot(s.pca,choix='ind')
plot(s.pca,choix='var')
}
}
\references{
Bock H-H. and Diday E. (eds.) (2000).
Analysis of Symbolic Data. Exploratory methods for extracting statistical information from
complex data. Springer, Germany.

Cazes P., Chouakria A., Diday E. et Schektman Y. (1997).  Extension de l'analyse en
composantes principales a des donnees de type intervalle, Rev. Statistique Appliquee,
Vol. XLV Num. 3 pag. 5-24, France.

Chouakria A. (1998)
Extension des methodes d'analysis factorialle a des
donnees de type intervalle, Ph.D. Thesis, Paris IX Dauphine University.

Makosso-Kallyth S. and Diday E. (2012).  Adaptation of interval PCA to symbolic histogram
variables, Advances in Data Analysis and Classification July, Volume 6, Issue 2, pp 147-159.

Rodriguez, O. (2000).
Classification et Modeles Lineaires en Analyse des Donnees Symboliques. Ph.D. Thesis,
Paris IX-Dauphine University.
}
\seealso{
sym.histogram.pca
}
\author{
Oldemar Rodriguez Rojas
}
\keyword{Intervals}
\keyword{PCA}
