% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSAGA-modules.R
\name{rsaga.intersect.polygons}
\alias{rsaga.intersect.polygons}
\title{Spatial intersection of two polygon layers}
\usage{
rsaga.intersect.polygons(
  layer_a = NULL,
  layer_b = NULL,
  result = NULL,
  split = FALSE,
  load = NULL,
  env = rsaga.env()
)
}
\arguments{
\item{layer_a}{A \code{character} string representing the path to a polygon
shapefile.}

\item{layer_b}{A \code{character} string representing the path to a polygon
shapefile with which to intersect layer_a.}

\item{result}{A \code{character} string indicating where the resulting
shapefile should be stored.}

\item{split}{If \code{TRUE}, multipart polygons become separated polygons
(default: FALSE).}

\item{load}{Deprecated, will be removed in a future release. Ignored
if \code{FALSE}, and causes an error if \code{TRUE} (default: NULL).}

\item{env}{RSAGA geoprocessing environment created by
\code{\link[=rsaga.env]{rsaga.env()}}.}
}
\value{
The function saves the output shapefile to the path indicated in
function argument \code{result}.
}
\description{
The function \code{rsaga.intersect.polygons} calculates the
geometric intersection of two overlayed polygon layers using SAGA module
"\code{Intersect}".
}
\details{
Function \code{gIntersection} in \code{rgeos} package can also be used to
define the intersection between two polygon layers. However,
\code{\link[=rsaga.intersect.polygons]{rsaga.intersect.polygons()}} will be usually much faster,
especially when intersecting thousands of polygons.
}
\author{
Jannes Muenchow and Alexander Brenning (R interface), Olaf Conrad and Angus Johnson (SAGA
modules)
}
\keyword{operations}
\keyword{polygons}
\keyword{vector}
